/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.templateengine;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.templateengine.TemplateEngineMessages;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public class ProjectCreatedActions {
    IProject project;
    IPath projectLocation;
    IConfiguration[] configs;
    String artifactExtension;
    private static final String PROPERTY = "org.eclipse.cdt.build.core.buildType";
    private static final String PROP_VAL = "org.eclipse.cdt.build.core.buildType.debug";
    Map original2newConfigs;

    public IManagedBuildInfo createProject(IProgressMonitor monitor, String indexerId, boolean isCProject) throws CoreException, BuildException {
        if (!this.areFieldsValid()) {
            throw new IllegalArgumentException(TemplateEngineMessages.getString((String)"ProjectCreatedActions.InsufficientInformation"));
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(this.project.getName());
        if (this.projectLocation != null && !this.projectLocation.equals((Object)Platform.getLocation())) {
            description.setLocation(this.projectLocation);
        }
        Preferences corePrefs = CCorePlugin.getDefault().getPluginPreferences();
        corePrefs.setValue("indexer", indexerId);
        CCorePlugin.getDefault().createCDTProject(description, this.project, monitor);
        if (!this.project.isOpen()) {
            this.project.open(monitor);
        }
        if (isCProject) {
            CProjectNature.addCNature((IProject)this.project, (IProgressMonitor)monitor);
        } else {
            CProjectNature.addCNature((IProject)this.project, (IProgressMonitor)monitor);
            CCProjectNature.addCCNature((IProject)this.project, (IProgressMonitor)monitor);
        }
        CoreModel coreModel = CoreModel.getDefault();
        ICProjectDescription des = coreModel.createProjectDescription(this.project, false);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)this.project);
        ManagedProject newManagedProject = new ManagedProject((IResource)this.project, this.configs[0].getProjectType());
        info.setManagedProject(newManagedProject);
        this.original2newConfigs = new HashMap();
        ICConfigurationDescription active = null;
        int i = 0;
        while (i < this.configs.length) {
            IConfiguration config = this.configs[i];
            if (config != null) {
                String id = ManagedBuildManager.calculateChildId(config.getId(), null);
                Configuration configuration = new Configuration(newManagedProject, (Configuration)config, id, false, true);
                CConfigurationData data = configuration.getConfigurationData();
                ICConfigurationDescription cfgDes = des.createConfiguration(ManagedBuildManager.CFG_DATA_PROVIDER_ID, data);
                configuration.setConfigurationDescription(cfgDes);
                configuration.exportArtifactInfo();
                configuration.setArtifactExtension(this.artifactExtension);
                this.original2newConfigs.put(config, configuration);
                IBuilder builder = configuration.getEditableBuilder();
                if (builder != null) {
                    builder.setManagedBuildOn(builder.isManagedBuildOn());
                }
                configuration.setName(config.getName());
                configuration.setArtifactName(this.project.getName());
                IBuildProperty buildProperty = configuration.getBuildProperties().getProperty(PROPERTY);
                if (buildProperty != null && buildProperty.getValue() != null && PROP_VAL.equals(buildProperty.getValue().getId())) {
                    active = cfgDes;
                } else if (active == null) {
                    active = cfgDes;
                }
            }
            ++i;
        }
        if (active != null) {
            active.setActive();
        }
        coreModel.setProjectDescription(this.project, des);
        info.setValid(true);
        ManagedBuildManager.saveBuildInfo(this.project, true);
        IStatus status = ManagedBuildManager.initBuildInfoContainer((IResource)this.project);
        if (status.getCode() != 0) {
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
        CCorePlugin.getDefault().getCProjectDescription(this.project, false).get("org.eclipse.cdt.core.BinaryParser", true);
        return info;
    }

    protected boolean areFieldsValid() {
        return this.project != null && this.configs != null && this.artifactExtension != null;
    }

    public IConfiguration getNewConfiguration(IConfiguration original) {
        return (IConfiguration)this.original2newConfigs.get(original);
    }

    public Set getNewConfigurations(Collection originalConfigs) {
        HashSet<IConfiguration> result = new HashSet<IConfiguration>();
        Iterator i = originalConfigs.iterator();
        while (i.hasNext()) {
            result.add(this.getNewConfiguration((IConfiguration)i.next()));
        }
        return result;
    }

    protected IConfiguration chooseDefaultConfiguration(IConfiguration[] configs) {
        return configs[0];
    }

    public void setArtifactExtension(String artifactExtension) {
        this.artifactExtension = artifactExtension;
    }

    public IConfiguration[] getConfigs() {
        return this.configs;
    }

    public void setConfigs(IConfiguration[] configs) {
        this.configs = configs;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IPath getProjectLocation() {
        return this.projectLocation;
    }

    public void setProjectLocation(IPath projectLocation) {
        this.projectLocation = projectLocation;
    }

    protected IConfiguration createNewConfiguration(IManagedProject managedProject, IConfiguration config) {
        return managedProject.createConfiguration(config, String.valueOf(config.getId()) + "." + ManagedBuildManager.getRandomNumber());
    }
}

