/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public class IndexViewSearchQuery
extends PDOMSearchQuery {
    private IIndexBinding fBinding;
    private long fLastWrite;
    private String fName;
    private ICProject fProject;

    public IndexViewSearchQuery(ICElement[] scope, ICProject project, long pdomLastWrite, IIndexBinding binding, String name, int flags) {
        super(scope, flags);
        this.fProject = project;
        this.fBinding = binding;
        this.fLastWrite = pdomLastWrite;
        this.fName = name;
    }

    public IStatus runWithIndex(IIndex index, IProgressMonitor monitor) throws OperationCanceledException {
        try {
            if (CCoreInternals.getPDOMManager().getPDOM(this.fProject).getLastWriteAccess() == this.fLastWrite) {
                this.createMatches(index, (IBinding)this.fBinding);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.cdt.ui", 0, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getLabel() {
        return String.valueOf(super.getLabel()) + " " + this.fName;
    }
}

