/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class LinkedNamesFinder {
    private static final IRegion[] EMPTY_LOCATIONS_ARRAY = new IRegion[0];

    public static IRegion[] findByName(IASTTranslationUnit root, IASTName name) {
        IBinding target = name.resolveBinding();
        if (target == null) {
            return EMPTY_LOCATIONS_ARRAY;
        }
        BindingFinder bindingFinder = new BindingFinder(root);
        bindingFinder.find(target);
        return bindingFinder.getLocations();
    }

    private static class BindingFinder {
        private final IASTTranslationUnit root;
        private final List<IRegion> locations;

        public BindingFinder(IASTTranslationUnit root) {
            this.root = root;
            this.locations = new ArrayList<IRegion>();
        }

        public void find(IBinding target) {
            try {
                if (target instanceof ICPPConstructor || target instanceof ICPPMethod && ((ICPPMethod)target).isDestructor()) {
                    target = ((ICPPMethod)target).getClassOwner();
                }
            }
            catch (DOMException dOMException) {}
            this.findBinding(target);
            if (target instanceof ICPPClassType) {
                try {
                    ICPPMethod[] methods;
                    ICPPConstructor[] constructors;
                    ICPPConstructor[] iCPPConstructorArray = constructors = ((ICPPClassType)target).getConstructors();
                    int n = constructors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPConstructor ctor = iCPPConstructorArray[n2];
                        if (!ctor.isImplicit()) {
                            this.findBinding((IBinding)ctor);
                        }
                        ++n2;
                    }
                    ICPPMethod[] iCPPMethodArray = methods = ((ICPPClassType)target).getDeclaredMethods();
                    int n3 = methods.length;
                    n = 0;
                    while (n < n3) {
                        ICPPMethod method = iCPPMethodArray[n];
                        if (method.isDestructor()) {
                            this.findBinding((IBinding)method);
                        }
                        ++n;
                    }
                }
                catch (DOMException dOMException) {}
            }
        }

        public IRegion[] getLocations() {
            if (this.locations.isEmpty()) {
                return EMPTY_LOCATIONS_ARRAY;
            }
            return this.locations.toArray(new IRegion[this.locations.size()]);
        }

        private void findBinding(IBinding target) {
            IASTName candidate;
            IASTName[] names = this.root.getDeclarationsInAST(target);
            int i = 0;
            while (i < names.length) {
                candidate = names[i];
                if (candidate.isPartOfTranslationUnitFile()) {
                    this.addLocation(candidate);
                }
                ++i;
            }
            names = this.root.getReferences(target);
            i = 0;
            while (i < names.length) {
                candidate = names[i];
                if (candidate.isPartOfTranslationUnitFile()) {
                    this.addLocation(candidate);
                }
                ++i;
            }
        }

        private void addLocation(IASTName name) {
            IBinding binding = name.resolveBinding();
            if (binding != null) {
                IASTImageLocation fileLocation;
                if (name instanceof ICPPASTTemplateId) {
                    name = ((ICPPASTTemplateId)name).getTemplateName();
                }
                if ((fileLocation = name.getImageLocation()) == null || !this.root.getFilePath().equals(fileLocation.getFileName())) {
                    fileLocation = name.getFileLocation();
                }
                if (fileLocation != null) {
                    int offset = fileLocation.getNodeOffset();
                    int length = fileLocation.getNodeLength();
                    if (binding instanceof ICPPMethod && ((ICPPMethod)binding).isDestructor()) {
                        ++offset;
                        --length;
                    }
                    if (offset >= 0 && length > 0) {
                        this.locations.add((IRegion)new Region(offset, length));
                    }
                }
            }
        }
    }
}

