/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.PDOMSearchElementQuery;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.cdt.internal.ui.search.PDOMSearchTextSelectionQuery;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkbenchSite;

public abstract class FindAction
extends SelectionParseAction {
    public FindAction(CEditor editor) {
        super(editor);
    }

    public FindAction(IWorkbenchSite site) {
        super(site);
    }

    public void run() {
        PDOMSearchQuery searchJob = null;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof ISourceReference) {
                searchJob = this.createQuery((ISourceReference)object);
            }
        } else if (selection instanceof ITextSelection) {
            ITextSelection selNode = (ITextSelection)selection;
            ICElement element = this.fEditor.getInputCElement();
            while (element != null && !(element instanceof ITranslationUnit)) {
                element = element.getParent();
            }
            if (element != null) {
                searchJob = this.createQuery(element, selNode);
            }
        }
        if (searchJob == null) {
            this.showStatusLineMessage(CSearchMessages.CSearchOperation_operationUnavailable_message);
            return;
        }
        this.clearStatusLine();
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground(searchJob);
    }

    protected PDOMSearchQuery createQuery(ISourceReference object) {
        return new PDOMSearchElementQuery(this.getScope(), object, this.getLimitTo());
    }

    protected PDOMSearchQuery createQuery(ICElement element, ITextSelection selNode) {
        return new PDOMSearchTextSelectionQuery(this.getScope(), (ITranslationUnit)element, selNode, this.getLimitTo());
    }

    protected abstract String getScopeDescription();

    protected abstract ICElement[] getScope();

    protected abstract int getLimitTo();
}

