/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgDiscoveredPathManager;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.model.util.CDTListComparator;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.make.ui.dialogs.AbstractDiscoveryOptionsBlock;
import org.eclipse.cdt.make.ui.dialogs.AbstractDiscoveryPage;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.DiscoveryPageWrapper;
import org.eclipse.cdt.managedbuilder.ui.properties.IBuildInfoContainer;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryTab
extends AbstractCBuildPropertyTab
implements IBuildInfoContainer {
    protected static final String PREFIX = "ScannerConfigOptionsDialog";
    private static final String SC_GROUP_LABEL = "ScannerConfigOptionsDialog.scGroup.label";
    private static final String SC_ENABLED_BUTTON = "ScannerConfigOptionsDialog.scGroup.enabled.button";
    private static final String SC_PROBLEM_REPORTING_ENABLED_BUTTON = "ScannerConfigOptionsDialog.scGroup.problemReporting.enabled.button";
    private static final String SC_SELECTED_PROFILE_COMBO = "ScannerConfigOptionsDialog.scGroup.selectedProfile.combo";
    private static final String NAMESPACE = "org.eclipse.cdt.make.ui";
    private static final String POINT = "DiscoveryProfilePage";
    private static final String PROFILE_PAGE = "profilePage";
    private static final String PROFILE_ID = "profileId";
    private static final String PROFILE_NAME = "name";
    private static final int DEFAULT_HEIGHT = 110;
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{10, 20};
    private Label fTableDefinition;
    private Table resTable;
    private Button scEnabledButton;
    private Button scProblemReportingEnabledButton;
    private Combo profileComboBox;
    private Combo scopeComboBox;
    private Composite profileComp;
    private Group scGroup;
    private ICfgScannerConfigBuilderInfo2Set cbi;
    private Map<InfoContext, Object> baseInfoMap;
    private IScannerConfigBuilderInfo2 buildInfo;
    private CfgInfoContext iContext;
    private List<DiscoveryProfilePageConfiguration> pagesList = null;
    private List<String> visibleProfilesList = null;
    private IPath configPath;
    private AbstractDiscoveryPage[] realPages;
    protected SashForm sashForm;
    private DiscoveryPageWrapper wrapper = null;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.wrapper = new DiscoveryPageWrapper(this.page, this);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        if (this.page.isForProject() || this.page.isForPrefs()) {
            Group scopeGroup = this.setupGroup(this.usercomp, Messages.getString("DiscoveryTab.0"), 1, 768);
            scopeGroup.setLayoutData((Object)new GridData(768));
            this.scopeComboBox = new Combo((Composite)scopeGroup, 2060);
            this.scopeComboBox.setLayoutData((Object)new GridData(768));
            this.scopeComboBox.add(Messages.getString("DiscoveryTab.1"));
            this.scopeComboBox.add(Messages.getString("DiscoveryTab.2"));
            this.scopeComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (DiscoveryTab.this.cbi == null) {
                        return;
                    }
                    DiscoveryTab.this.cbi.setPerRcTypeDiscovery(DiscoveryTab.this.scopeComboBox.getSelectionIndex() == 0);
                    DiscoveryTab.this.updateData();
                }
            });
        }
        this.sashForm = new SashForm(this.usercomp, 0);
        this.sashForm.setOrientation(256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        Composite comp = new Composite((Composite)this.sashForm, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(1808));
        this.fTableDefinition = new Label(comp, 16384);
        this.fTableDefinition.setLayoutData((Object)new GridData(768));
        this.resTable = new Table(comp, 2820);
        GridData gd = new GridData(1808);
        gd.widthHint = 150;
        this.resTable.setLayoutData((Object)gd);
        this.resTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryTab.this.handleToolSelected();
            }
        });
        this.initializeProfilePageMap();
        Composite c = new Composite((Composite)this.sashForm, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(1808));
        this.createScannerConfigControls(c);
        this.profileComp = new Composite(c, 0);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)DiscoveryTab.getFontMetrics((Control)parent), (int)110);
        this.profileComp.setLayoutData((Object)gd);
        this.profileComp.setLayout((Layout)new TabFolderLayout());
        this.sashForm.setWeights(DEFAULT_SASH_WEIGHTS);
    }

    private void createScannerConfigControls(Composite parent) {
        this.scGroup = this.setupGroup(parent, UIMessages.getString((String)SC_GROUP_LABEL), 2, 768);
        this.scEnabledButton = this.setupCheck((Composite)this.scGroup, UIMessages.getString((String)SC_ENABLED_BUTTON), 2, 768);
        this.scEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryTab.this.buildInfo.setAutoDiscoveryEnabled(DiscoveryTab.this.scEnabledButton.getSelection());
                DiscoveryTab.this.enableAllControls();
                if (DiscoveryTab.this.scEnabledButton.getSelection()) {
                    DiscoveryTab.this.handleDiscoveryProfileChanged();
                }
            }
        });
        this.scProblemReportingEnabledButton = this.setupCheck((Composite)this.scGroup, UIMessages.getString((String)SC_PROBLEM_REPORTING_ENABLED_BUTTON), 2, 768);
        this.scProblemReportingEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryTab.this.buildInfo.setProblemReportingEnabled(DiscoveryTab.this.scProblemReportingEnabledButton.getSelection());
            }
        });
        this.setupLabel((Composite)this.scGroup, UIMessages.getString((String)SC_SELECTED_PROFILE_COMBO), 1, 1);
        this.profileComboBox = new Combo((Composite)this.scGroup, 2060);
        this.profileComboBox.setLayoutData((Object)new GridData(768));
        this.profileComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int x = DiscoveryTab.this.profileComboBox.getSelectionIndex();
                String s = (String)DiscoveryTab.this.visibleProfilesList.get(x);
                DiscoveryTab.this.buildInfo.setSelectedProfileId(s);
                DiscoveryTab.this.handleDiscoveryProfileChanged();
            }
        });
    }

    private void enableAllControls() {
        boolean isSCDEnabled = this.scEnabledButton.getSelection();
        this.scProblemReportingEnabledButton.setEnabled(isSCDEnabled);
        this.profileComboBox.setEnabled(isSCDEnabled);
        this.profileComp.setVisible(isSCDEnabled);
    }

    public void updateData(ICResourceDescription rcfg) {
        if (this.page.isMultiCfg()) {
            this.setAllVisible(false, null);
            return;
        }
        this.setAllVisible(true, null);
        this.configPath = rcfg.getPath();
        IConfiguration cfg = DiscoveryTab.getCfg(rcfg.getConfiguration());
        this.cbi = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)cfg);
        if (!this.page.isForPrefs() && this.baseInfoMap == null) {
            try {
                IScannerConfigBuilderInfo2Set baseCbi = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set((IProject)cfg.getOwner().getProject());
                this.baseInfoMap = baseCbi.getInfoMap();
            }
            catch (CoreException coreException) {}
        }
        this.updateData();
    }

    private void updateData() {
        int selScope = 0;
        String lblText = "Tools:";
        if (!this.cbi.isPerRcTypeDiscovery()) {
            selScope = 1;
            lblText = "Configuration:";
        }
        if (this.scopeComboBox != null) {
            this.scopeComboBox.select(selScope);
        }
        this.fTableDefinition.setText(lblText);
        Map m = this.cbi.getInfoMap();
        int pos = this.resTable.getSelectionIndex();
        this.resTable.removeAll();
        for (CfgInfoContext ic : m.keySet()) {
            String s = null;
            IResourceInfo rci = ic.getResourceInfo();
            if (rci == null) {
                s = ic.getConfiguration().getName();
            } else {
                ITool tool;
                if (!this.configPath.equals((Object)rci.getPath())) continue;
                IInputType typ = ic.getInputType();
                if (typ != null) {
                    s = typ.getName();
                }
                if (s == null && (tool = ic.getTool()) != null) {
                    s = tool.getName();
                }
                if (s == null) {
                    s = Messages.getString("DiscoveryTab.3");
                }
            }
            IScannerConfigBuilderInfo2 bi2 = (IScannerConfigBuilderInfo2)m.get(ic);
            TableItem ti = new TableItem(this.resTable, 0);
            ti.setText(s);
            ti.setData("cont", (Object)ic);
            ti.setData("info", (Object)bi2);
        }
        int len = this.resTable.getItemCount();
        if (len > 0) {
            this.setVisibility(null);
            this.resTable.select(pos < len && pos > -1 ? pos : 0);
            this.handleToolSelected();
        } else {
            this.setVisibility(Messages.getString("DiscoveryTab.6"));
        }
    }

    private void setVisibility(String errMsg) {
        this.scGroup.setVisible(errMsg == null);
        this.profileComp.setVisible(errMsg == null);
        this.resTable.setEnabled(errMsg == null);
        if (errMsg != null) {
            String[] ss = errMsg.split("\n");
            int i = 0;
            while (i < ss.length) {
                new TableItem(this.resTable, 0).setText(ss[i]);
                ++i;
            }
        }
    }

    private String getProfileName(String id) {
        int x = id.lastIndexOf(".");
        return x == -1 ? id : id.substring(x + 1);
    }

    private void handleToolSelected() {
        if (this.resTable.getSelectionCount() == 0) {
            return;
        }
        this.performOK(false);
        TableItem ti = this.resTable.getSelection()[0];
        this.buildInfo = (IScannerConfigBuilderInfo2)ti.getData("info");
        this.iContext = (CfgInfoContext)ti.getData("cont");
        this.scEnabledButton.setSelection(this.buildInfo.isAutoDiscoveryEnabled());
        this.scProblemReportingEnabledButton.setSelection(this.buildInfo.isProblemReportingEnabled());
        this.profileComboBox.removeAll();
        List profilesList = this.buildInfo.getProfileIdList();
        Collections.sort(profilesList, CDTListComparator.getInstance());
        this.visibleProfilesList = new ArrayList<String>(profilesList.size());
        if (this.realPages != null && this.realPages.length > 0) {
            int i = 0;
            while (i < this.realPages.length) {
                if (this.realPages[i] != null) {
                    this.realPages[i].setVisible(false);
                    this.realPages[i].dispose();
                }
                ++i;
            }
        }
        this.realPages = new AbstractDiscoveryPage[profilesList.size()];
        String[] labels = new String[profilesList.size()];
        String[] profiles = new String[profilesList.size()];
        int counter = 0;
        int pos = 0;
        String savedId = this.buildInfo.getSelectedProfileId();
        ITool[] tools = null;
        boolean needPerRcProfile = this.cbi.isPerRcTypeDiscovery();
        if (!this.page.isForPrefs()) {
            Tool tool = (Tool)this.iContext.getTool();
            if (tool == null) {
                IConfiguration conf = this.iContext.getConfiguration();
                if (conf != null) {
                    tools = conf.getToolChain().getTools();
                }
                if (tools == null) {
                    return;
                }
            } else {
                tools = new ITool[]{tool};
            }
        }
        for (String profileId : profilesList) {
            if (tools != null) {
                boolean ok = false;
                int i = 0;
                while (i < tools.length) {
                    IInputType[] inputTypes = ((Tool)tools[i]).getAllInputTypes();
                    if (inputTypes != null) {
                        IInputType[] iInputTypeArray = inputTypes;
                        int n = inputTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IInputType it = iInputTypeArray[n2];
                            String[] requiedProfiles = this.getDiscoveryProfileIds(tools[i], it);
                            if (requiedProfiles != null) {
                                String[] stringArray = requiedProfiles;
                                int n3 = requiedProfiles.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String requiredProfile = stringArray[n4];
                                    if (profileId.equals(requiredProfile)) {
                                        ok = true;
                                        break;
                                    }
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                    }
                    if (ok) break;
                    ++i;
                }
                if (!ok) continue;
            }
            if (needPerRcProfile && !CfgScannerConfigProfileManager.isPerFileProfile((String)profileId)) continue;
            this.visibleProfilesList.add(profileId);
            labels[counter] = profiles[counter] = this.getProfileName(profileId);
            if (profileId.equals(savedId)) {
                pos = counter;
            }
            this.buildInfo.setSelectedProfileId(profileId);
            for (DiscoveryProfilePageConfiguration p : this.pagesList) {
                AbstractDiscoveryPage pg;
                if (p == null || !p.profId.equals(profileId) || (pg = p.getPage()) == null) continue;
                this.realPages[counter] = pg;
                String s = p.name;
                if (s != null && s.length() > 0) {
                    labels[counter] = s;
                }
                pg.setContainer((AbstractDiscoveryOptionsBlock)this.wrapper);
                pg.createControl(this.profileComp);
                this.profileComp.layout(true);
                break;
            }
            ++counter;
        }
        this.profileComboBox.setItems(this.normalize(labels, profiles, counter));
        this.buildInfo.setSelectedProfileId(savedId);
        if (this.profileComboBox.getItemCount() > 0) {
            this.profileComboBox.select(pos);
        }
        this.enableAllControls();
        this.handleDiscoveryProfileChanged();
    }

    private String[] getDiscoveryProfileIds(ITool iTool, IInputType it) {
        String attribute = ((InputType)it).getDiscoveryProfileIdAttribute();
        if (attribute == null) {
            return new String[0];
        }
        String[] profileIds = attribute.split("\\|");
        int i = 0;
        while (i < profileIds.length) {
            profileIds[i] = profileIds[i].trim();
            ++i;
        }
        return profileIds;
    }

    private String[] normalize(String[] labels, String[] ids, int counter) {
        int j;
        int mode = CDTPrefUtil.getInt((String)"properties.discovery.naming");
        String[] tmp = new String[counter];
        if (mode == 2 || mode == 3) {
            int i = 0;
            while (i < counter) {
                tmp[i] = mode == 3 ? ids[i] : this.combine(labels[i], ids[i]);
                ++i;
            }
            return tmp;
        }
        boolean doubles = false;
        int i = 0;
        block1: while (i < counter) {
            j = 0;
            while (j < counter) {
                if (i < j && labels[i].equals(labels[j])) {
                    doubles = true;
                    break block1;
                }
                ++j;
            }
            ++i;
        }
        if (!doubles) {
            i = 0;
            while (i < counter) {
                tmp[i] = labels[i];
                ++i;
            }
        } else {
            i = 0;
            while (i < counter) {
                doubles = false;
                j = 0;
                while (j < counter) {
                    if (i != j && labels[i].equals(labels[j])) {
                        doubles = true;
                        break;
                    }
                    ++j;
                }
                tmp[i] = doubles ? (mode == 1 ? ids[i] : this.combine(labels[i], ids[i])) : labels[i];
                ++i;
            }
        }
        return tmp;
    }

    private String combine(String s1, String s2) {
        if (s1.equals(s2)) {
            return s1;
        }
        return String.valueOf(s1) + " (" + s2 + ")";
    }

    private void handleDiscoveryProfileChanged() {
        int pos = this.profileComboBox.getSelectionIndex();
        int i = 0;
        while (i < this.realPages.length) {
            if (this.realPages[i] != null) {
                this.realPages[i].setVisible(i == pos);
            }
            ++i;
        }
    }

    private void initializeProfilePageMap() {
        this.pagesList = new ArrayList<DiscoveryProfilePageConfiguration>(5);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, POINT);
        if (point == null) {
            return;
        }
        IConfigurationElement[] infos = point.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getName().equals(PROFILE_PAGE)) {
                this.pagesList.add(new DiscoveryProfilePageConfiguration(infos[i]));
            }
            ++i;
        }
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (this.page.isMultiCfg()) {
            return;
        }
        ICfgScannerConfigBuilderInfo2Set cbi1 = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)DiscoveryTab.getCfg(src.getConfiguration()));
        ICfgScannerConfigBuilderInfo2Set cbi2 = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)DiscoveryTab.getCfg(dst.getConfiguration()));
        cbi2.setPerRcTypeDiscovery(cbi1.isPerRcTypeDiscovery());
        Map m1 = cbi1.getInfoMap();
        Map m2 = cbi2.getInfoMap();
        for (CfgInfoContext ic : m2.keySet()) {
            if (m1.keySet().contains(ic)) {
                IScannerConfigBuilderInfo2 bi1 = (IScannerConfigBuilderInfo2)m1.get(ic);
                try {
                    cbi2.applyInfo(ic, bi1);
                }
                catch (CoreException e) {
                    ManagedBuilderUIPlugin.log(e);
                }
                continue;
            }
            CUIPlugin.getDefault().logErrorMessage(Messages.getString("DiscoveryTab.7"));
        }
        this.clearChangedDiscoveredInfos();
    }

    protected void performOK() {
        this.performOK(true);
    }

    private void performOK(boolean ok) {
        if (this.page.isMultiCfg()) {
            return;
        }
        if (this.buildInfo == null) {
            return;
        }
        String savedId = this.buildInfo.getSelectedProfileId();
        int i = 0;
        while (i < this.realPages.length) {
            if (this.realPages != null && this.realPages[i] != null) {
                String s = this.visibleProfilesList.get(i);
                this.buildInfo.setSelectedProfileId(s);
                this.realPages[i].performApply();
                this.realPages[i].setVisible(false);
            }
            ++i;
        }
        this.buildInfo.setSelectedProfileId(savedId);
        this.handleDiscoveryProfileChanged();
        if (ok) {
            this.clearChangedDiscoveredInfos();
        }
    }

    private void clearChangedDiscoveredInfos() {
        List<CfgInfoContext> changedContexts = this.checkChanges();
        IProject project = this.getProject();
        int i = 0;
        while (i < changedContexts.size()) {
            CfgInfoContext c = changedContexts.get(i);
            CfgDiscoveredPathManager.getInstance().removeDiscoveredInfo(project, c);
            ++i;
        }
    }

    private List<CfgInfoContext> checkChanges() {
        if (this.cbi == null || this.baseInfoMap == null) {
            return new ArrayList<CfgInfoContext>(0);
        }
        Map cfgInfoMap = this.cbi.getInfoMap();
        HashMap<InfoContext, Object> baseCopy = new HashMap<InfoContext, Object>(this.baseInfoMap);
        ArrayList<CfgInfoContext> list = new ArrayList<CfgInfoContext>();
        for (Map.Entry entry : cfgInfoMap.entrySet()) {
            CfgInfoContext cic = (CfgInfoContext)entry.getKey();
            InfoContext c = cic.toInfoContext();
            if (c == null) continue;
            IScannerConfigBuilderInfo2 changed = (IScannerConfigBuilderInfo2)entry.getValue();
            IScannerConfigBuilderInfo2 old = (IScannerConfigBuilderInfo2)baseCopy.remove(c);
            if (old == null) {
                list.add(cic);
                continue;
            }
            if (this.settingsEqual(changed, old)) continue;
            list.add(cic);
        }
        if (baseCopy.size() != 0) {
            IConfiguration cfg = this.cbi.getConfiguration();
            for (InfoContext c : baseCopy.keySet()) {
                CfgInfoContext cic = CfgInfoContext.fromInfoContext((IConfiguration)cfg, (InfoContext)c);
                if (cic == null) continue;
                list.add(cic);
            }
        }
        return list;
    }

    private boolean settingsEqual(IScannerConfigBuilderInfo2 info1, IScannerConfigBuilderInfo2 info2) {
        if (!CDataUtil.objectsEqual((Object)info1.getSelectedProfileId(), (Object)info2.getSelectedProfileId())) {
            return false;
        }
        if (!CDataUtil.objectsEqual((Object)info1.getBuildOutputFilePath(), (Object)info2.getBuildOutputFilePath())) {
            return false;
        }
        if (!CDataUtil.objectsEqual((Object)info1.getContext(), (Object)info2.getContext())) {
            return false;
        }
        if (!CDataUtil.objectsEqual((Object)info1.getSelectedProfileId(), (Object)info2.getSelectedProfileId())) {
            return false;
        }
        if (info1.isAutoDiscoveryEnabled() != info2.isAutoDiscoveryEnabled() || info1.isBuildOutputFileActionEnabled() != info2.isBuildOutputFileActionEnabled() || info1.isBuildOutputParserEnabled() != info2.isBuildOutputParserEnabled() || info1.isProblemReportingEnabled() != info2.isProblemReportingEnabled()) {
            return false;
        }
        if (!this.listEqual(info1.getProfileIdList(), info2.getProfileIdList())) {
            return false;
        }
        return this.listEqual(info1.getProviderIdList(), info2.getProviderIdList());
    }

    private boolean listEqual(List<String> l1, List<String> l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        if (l1.equals(l2)) {
            return true;
        }
        for (String s : l1) {
            if (l2.contains(s)) continue;
            return false;
        }
        return true;
    }

    public boolean canBeVisible() {
        if (this.page.isMultiCfg()) {
            this.setAllVisible(false, null);
            return false;
        }
        this.setAllVisible(true, null);
        if (this.page.isForProject() || this.page.isForPrefs()) {
            return true;
        }
        ICfgScannerConfigBuilderInfo2Set _cbi = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)DiscoveryTab.getCfg(this.page.getResDesc().getConfiguration()));
        return _cbi.isPerRcTypeDiscovery();
    }

    @Override
    public IScannerConfigBuilderInfo2 getBuildInfo() {
        return this.buildInfo;
    }

    @Override
    public CfgInfoContext getContext() {
        return this.iContext;
    }

    @Override
    public IProject getProject() {
        return this.page.getProject();
    }

    @Override
    public ICConfigurationDescription getConfiguration() {
        return this.getResDesc().getConfiguration();
    }

    protected void performDefaults() {
        if (this.page.isMultiCfg()) {
            return;
        }
        this.cbi.setPerRcTypeDiscovery(true);
        for (CfgInfoContext cic : this.cbi.getInfoMap().keySet()) {
            try {
                this.cbi.applyInfo(cic, null);
            }
            catch (CoreException coreException) {}
        }
        this.updateData();
    }

    protected void updateButtons() {
    }

    protected static class DiscoveryProfilePageConfiguration {
        IConfigurationElement fElement;
        private String profId;
        private String name;

        protected DiscoveryProfilePageConfiguration(IConfigurationElement element) {
            this.fElement = element;
            this.profId = this.fElement.getAttribute(DiscoveryTab.PROFILE_ID);
            this.name = this.fElement.getAttribute(DiscoveryTab.PROFILE_NAME);
        }

        protected String getName() {
            return this.name;
        }

        private AbstractDiscoveryPage getPage() {
            try {
                return (AbstractDiscoveryPage)this.fElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                return null;
            }
        }
    }
}

