/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuildPropertiesRestriction;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.PluginVersionIdentifier;

public class Option
extends BuildObject
implements IOption,
IBuildPropertiesRestriction {
    public static final String EMPTY_STRING = new String();
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final OptionStringValue[] EMPTY_LV_ARRAY = new OptionStringValue[0];
    private IOption superClass;
    private String superClassId;
    private IHoldsOptions holder;
    private String unusedChildren;
    private Integer browseType;
    private List builtIns;
    private IOptionCategory category;
    private String categoryId;
    private String command;
    private String commandFalse;
    private String tip;
    private String contextId;
    private List enumList;
    private Map enumCommands;
    private Map enumNames;
    private Object value;
    private Object defaultValue;
    private Integer valueType;
    private Boolean isAbstract;
    private Integer resourceFilter;
    private IConfigurationElement valueHandlerElement;
    private IManagedOptionValueHandler valueHandler;
    private String valueHandlerExtraArgument;
    private IConfigurationElement applicabilityCalculatorElement;
    private IOptionApplicability applicabilityCalculator;
    private BooleanExpressionApplicabilityCalculator booleanExpressionCalculator;
    private boolean isExtensionOption;
    private boolean isDirty;
    private boolean resolved;
    private boolean verified;
    private boolean isValid;
    private boolean wasOptRef;
    private boolean isUdjusted;
    private boolean rebuildState;

    public Option(IHoldsOptions parent, IManagedConfigElement element) {
        this.valueHandlerElement = null;
        this.valueHandler = null;
        this.applicabilityCalculatorElement = null;
        this.applicabilityCalculator = null;
        this.booleanExpressionCalculator = null;
        this.isExtensionOption = false;
        this.isDirty = false;
        this.resolved = true;
        this.verified = false;
        this.isValid = true;
        this.wasOptRef = false;
        this.isUdjusted = false;
        this.holder = parent;
        this.isExtensionOption = true;
        this.resolved = false;
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionOption(this);
    }

    public Option(IHoldsOptions parent, IOption superClass, String Id, String name, boolean isExtensionElement) {
        this.valueHandlerElement = null;
        this.valueHandler = null;
        this.applicabilityCalculatorElement = null;
        this.applicabilityCalculator = null;
        this.booleanExpressionCalculator = null;
        this.isExtensionOption = false;
        this.isDirty = false;
        this.resolved = true;
        this.verified = false;
        this.isValid = true;
        this.wasOptRef = false;
        this.isUdjusted = false;
        this.holder = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionOption = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionOption(this);
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public Option(IHoldsOptions parent, ICStorageElement element) {
        this.valueHandlerElement = null;
        this.valueHandler = null;
        this.applicabilityCalculatorElement = null;
        this.applicabilityCalculator = null;
        this.booleanExpressionCalculator = null;
        this.isExtensionOption = false;
        this.isDirty = false;
        this.resolved = true;
        this.verified = false;
        this.isValid = true;
        this.wasOptRef = false;
        this.isUdjusted = false;
        this.holder = parent;
        this.isExtensionOption = false;
        this.loadFromProject(element);
    }

    public Option(IHoldsOptions parent, String Id, String name, Option option) {
        boolean copyIds;
        block31: {
            this.valueHandlerElement = null;
            this.valueHandler = null;
            this.applicabilityCalculatorElement = null;
            this.applicabilityCalculator = null;
            this.booleanExpressionCalculator = null;
            this.isExtensionOption = false;
            this.isDirty = false;
            this.resolved = true;
            this.verified = false;
            this.isValid = true;
            this.wasOptRef = false;
            this.isUdjusted = false;
            this.holder = parent;
            this.superClass = option.superClass;
            if (this.superClass != null) {
                this.superClassId = option.superClass.getId();
            }
            this.setId(Id);
            this.setName(name);
            this.isExtensionOption = false;
            copyIds = Id.equals(option.id);
            if (option.unusedChildren != null) {
                this.unusedChildren = new String(option.unusedChildren);
            }
            if (option.isAbstract != null) {
                this.isAbstract = new Boolean(option.isAbstract);
            }
            if (option.command != null) {
                this.command = new String(option.command);
            }
            if (option.commandFalse != null) {
                this.commandFalse = new String(option.commandFalse);
            }
            if (option.tip != null) {
                this.tip = new String(option.tip);
            }
            if (option.contextId != null) {
                this.contextId = new String(option.contextId);
            }
            if (option.categoryId != null) {
                this.categoryId = new String(option.categoryId);
            }
            if (option.builtIns != null) {
                this.builtIns = new ArrayList(option.builtIns);
            }
            if (option.browseType != null) {
                this.browseType = new Integer(option.browseType);
            }
            if (option.resourceFilter != null) {
                this.resourceFilter = new Integer(option.resourceFilter);
            }
            if (option.enumList != null) {
                this.enumList = new ArrayList(option.enumList);
                this.enumCommands = new HashMap(option.enumCommands);
                this.enumNames = new HashMap(option.enumNames);
            }
            if (option.valueType != null) {
                this.valueType = new Integer(option.valueType);
            }
            Integer vType = null;
            try {
                vType = new Integer(option.getValueType());
                if (vType == null) break block31;
                switch (vType) {
                    case 0: {
                        if (option.value != null) {
                            this.value = new Boolean((Boolean)option.value);
                        }
                        if (option.defaultValue != null) {
                            this.defaultValue = new Boolean((Boolean)option.defaultValue);
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (option.value != null) {
                            this.value = new String((String)option.value);
                        }
                        if (option.defaultValue != null) {
                            this.defaultValue = new String((String)option.defaultValue);
                        }
                        break;
                    }
                    case -11: 
                    case -10: 
                    case -9: 
                    case -8: 
                    case -5: 
                    case -4: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        if (option.value != null) {
                            this.value = new ArrayList((ArrayList)option.value);
                        }
                        if (option.defaultValue == null) break;
                        this.defaultValue = new ArrayList((ArrayList)option.defaultValue);
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (BuildException buildException) {}
        }
        this.category = option.category;
        this.applicabilityCalculatorElement = option.applicabilityCalculatorElement;
        this.applicabilityCalculator = option.applicabilityCalculator;
        this.booleanExpressionCalculator = option.booleanExpressionCalculator;
        if (option.valueHandlerElement != null) {
            this.valueHandlerElement = option.valueHandlerElement;
            this.valueHandler = option.valueHandler;
        }
        if (option.valueHandlerExtraArgument != null) {
            this.valueHandlerExtraArgument = new String(option.valueHandlerExtraArgument);
        }
        if (copyIds) {
            this.isDirty = option.isDirty;
            this.rebuildState = option.rebuildState;
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String applicabilityCalculatorStr;
        String browseTypeStr;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.superClassId = element.getAttribute("superClass");
        this.unusedChildren = element.getAttribute("unusedChildren");
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        this.command = element.getAttribute("command");
        this.commandFalse = element.getAttribute("commandFalse");
        this.tip = element.getAttribute("tip");
        this.contextId = element.getAttribute("contextId");
        String valueTypeStr = element.getAttribute("valueType");
        if (valueTypeStr != null) {
            this.valueType = new Integer(this.ValueTypeStrToInt(valueTypeStr));
        }
        if ((browseTypeStr = element.getAttribute("browseType")) == null) {
            this.browseType = null;
        } else if (browseTypeStr.equals("none")) {
            this.browseType = new Integer(0);
        } else if (browseTypeStr.equals("file")) {
            this.browseType = new Integer(1);
        } else if (browseTypeStr.equals("directory")) {
            this.browseType = new Integer(2);
        }
        this.categoryId = element.getAttribute("category");
        String resFilterStr = element.getAttribute("resourceFilter");
        if (resFilterStr == null) {
            this.resourceFilter = null;
        } else if (resFilterStr.equals("all")) {
            this.resourceFilter = new Integer(0);
        } else if (resFilterStr.equals("file")) {
            this.resourceFilter = new Integer(1);
        } else if (resFilterStr.equals("project")) {
            this.resourceFilter = new Integer(2);
        }
        IManagedConfigElement[] enablements = element.getChildren("enablement");
        if (enablements.length > 0) {
            this.booleanExpressionCalculator = new BooleanExpressionApplicabilityCalculator(enablements);
        }
        if ((applicabilityCalculatorStr = element.getAttribute("applicabilityCalculator")) != null && element instanceof DefaultManagedConfigElement) {
            this.applicabilityCalculatorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        } else {
            this.applicabilityCalculator = this.booleanExpressionCalculator;
        }
        String valueHandler = element.getAttribute("valueHandler");
        if (valueHandler != null && element instanceof DefaultManagedConfigElement) {
            this.valueHandlerElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.valueHandlerExtraArgument = element.getAttribute("valueHandlerExtraArgument");
    }

    protected void loadFromProject(ICStorageElement element) {
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(element.getAttribute("name"));
        }
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionOption(this.superClassId);
        }
        if (element.getAttribute("unusedChildren") != null) {
            this.unusedChildren = element.getAttribute("unusedChildren");
        }
        if (element.getAttribute("isAbstract") != null && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.getAttribute("command") != null) {
            this.command = element.getAttribute("command");
        }
        if (element.getAttribute("commandFalse") != null) {
            this.commandFalse = element.getAttribute("commandFalse");
        }
        if (element.getAttribute("tip") != null) {
            this.tip = element.getAttribute("tip");
        }
        if (element.getAttribute("contextId") != null) {
            this.contextId = element.getAttribute("contextId");
        }
        if (element.getAttribute("valueType") != null) {
            String valueTypeStr = element.getAttribute("valueType");
            this.valueType = new Integer(this.ValueTypeStrToInt(valueTypeStr));
        }
        try {
            int valType = this.getValueType();
            switch (valType) {
                case 0: {
                    if (element.getAttribute("value") != null) {
                        this.value = new Boolean(element.getAttribute("value"));
                    }
                    if (element.getAttribute("defaultValue") != null) {
                        this.defaultValue = new Boolean(element.getAttribute("defaultValue"));
                    }
                    break;
                }
                case 2: {
                    if (element.getAttribute("value") != null) {
                        this.value = element.getAttribute("value");
                    }
                    if (element.getAttribute("defaultValue") != null) {
                        this.defaultValue = element.getAttribute("defaultValue");
                    }
                    break;
                }
                case 1: {
                    if (element.getAttribute("value") != null) {
                        this.value = element.getAttribute("value");
                    }
                    if (element.getAttribute("defaultValue") != null) {
                        this.defaultValue = element.getAttribute("defaultValue");
                    }
                    ICStorageElement[] configElements = element.getChildren();
                    int i = 0;
                    while (i < configElements.length) {
                        ICStorageElement configNode = configElements[i];
                        if (configNode.getName().equals("enumeratedOptionValue")) {
                            Boolean isDefault;
                            ICStorageElement configElement = configNode;
                            String optId = configElement.getAttribute("id");
                            if (i == 0) {
                                this.enumList = new ArrayList();
                                if (this.defaultValue == null) {
                                    this.defaultValue = optId;
                                }
                            }
                            this.enumList.add(optId);
                            if (configElement.getAttribute("command") != null) {
                                this.getEnumCommandMap().put(optId, configElement.getAttribute("command"));
                            } else {
                                this.getEnumCommandMap().put(optId, EMPTY_STRING);
                            }
                            this.getEnumNameMap().put(optId, configElement.getAttribute("name"));
                            if (configElement.getAttribute("isDefault") != null && (isDefault = new Boolean(configElement.getAttribute("isDefault"))).booleanValue()) {
                                this.defaultValue = optId;
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -5: 
                case -4: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    ArrayList<OptionStringValue> vList = null;
                    ArrayList<OptionStringValue> biList = null;
                    ICStorageElement[] configElements = element.getChildren();
                    int i = 0;
                    while (i < configElements.length) {
                        ICStorageElement veNode;
                        if (i == 0) {
                            vList = new ArrayList<OptionStringValue>();
                            biList = new ArrayList<OptionStringValue>();
                        }
                        if ((veNode = configElements[i]).getName().equals("listOptionValue")) {
                            OptionStringValue ve = new OptionStringValue(veNode);
                            if (ve.isBuiltIn()) {
                                biList.add(ve);
                            } else {
                                vList.add(ve);
                            }
                        }
                        ++i;
                    }
                    if (vList != null && vList.size() != 0) {
                        this.value = vList;
                    }
                    if (biList != null && biList.size() != 0) {
                        this.builtIns = biList;
                    }
                    break;
                }
            }
        }
        catch (BuildException buildException) {}
        if (element.getAttribute("browseType") != null) {
            String browseTypeStr = element.getAttribute("browseType");
            if (browseTypeStr == null) {
                this.browseType = null;
            } else if (browseTypeStr.equals("none")) {
                this.browseType = new Integer(0);
            } else if (browseTypeStr.equals("file")) {
                this.browseType = new Integer(1);
            } else if (browseTypeStr.equals("directory")) {
                this.browseType = new Integer(2);
            }
        }
        if (element.getAttribute("category") != null) {
            this.categoryId = element.getAttribute("category");
            if (this.categoryId != null) {
                this.category = this.holder.getOptionCategory(this.categoryId);
            }
        }
        if (element.getAttribute("resourceFilter") != null) {
            String resFilterStr = element.getAttribute("resourceFilter");
            if (resFilterStr == null) {
                this.resourceFilter = null;
            } else if (resFilterStr.equals("all")) {
                this.resourceFilter = new Integer(0);
            } else if (resFilterStr.equals("file")) {
                this.resourceFilter = new Integer(1);
            } else if (resFilterStr.equals("project")) {
                this.resourceFilter = new Integer(2);
            }
        }
        if (element.getAttribute("valueHandlerExtraArgument") != null) {
            this.valueHandlerExtraArgument = element.getAttribute("valueHandlerExtraArgument");
        }
    }

    private int ValueTypeStrToInt(String valueTypeStr) {
        if (valueTypeStr == null) {
            return -1;
        }
        if (valueTypeStr.equals("string")) {
            return 2;
        }
        if (valueTypeStr.equals("stringList")) {
            return 3;
        }
        if (valueTypeStr.equals("boolean")) {
            return 0;
        }
        if (valueTypeStr.equals("enumerated")) {
            return 1;
        }
        if (valueTypeStr.equals("includePath")) {
            return 4;
        }
        if (valueTypeStr.equals("libs")) {
            return 6;
        }
        if (valueTypeStr.equals("userObjs")) {
            return 7;
        }
        if (valueTypeStr.equals("definedSymbols")) {
            return 5;
        }
        if (valueTypeStr.equals("libPaths")) {
            return 9;
        }
        if (valueTypeStr.equals("libFiles")) {
            return 10;
        }
        if (valueTypeStr.equals("includeFiles")) {
            return 8;
        }
        if (valueTypeStr.equals("symbolFiles")) {
            return 11;
        }
        if (valueTypeStr.equals("undefIncludePath")) {
            return -4;
        }
        if (valueTypeStr.equals("undefDefinedSymbols")) {
            return -5;
        }
        if (valueTypeStr.equals("undefLibPaths")) {
            return -9;
        }
        if (valueTypeStr.equals("undefLibFiles")) {
            return -10;
        }
        if (valueTypeStr.equals("undefIncludeFiles")) {
            return -8;
        }
        if (valueTypeStr.equals("undefSymbolFiles")) {
            return -11;
        }
        return 5;
    }

    public void serialize(ICStorageElement element) throws BuildException {
        String str;
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.unusedChildren != null) {
            element.setAttribute("unusedChildren", this.unusedChildren);
        }
        if (this.isAbstract != null) {
            element.setAttribute("isAbstract", this.isAbstract.toString());
        }
        if (this.command != null) {
            element.setAttribute("command", this.command);
        }
        if (this.commandFalse != null) {
            element.setAttribute("commandFalse", this.commandFalse);
        }
        if (this.tip != null) {
            element.setAttribute("tip", this.tip);
        }
        if (this.contextId != null) {
            element.setAttribute("contextId", this.contextId);
        }
        boolean storeValueType = false;
        if (this.value != null) {
            storeValueType = true;
            switch (this.getValueType()) {
                case 0: {
                    element.setAttribute("value", ((Boolean)this.value).toString());
                    break;
                }
                case 1: 
                case 2: {
                    element.setAttribute("value", (String)this.value);
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -5: 
                case -4: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    if (this.value != null) {
                        ArrayList stringList = (ArrayList)this.value;
                        ListIterator iter = stringList.listIterator();
                        while (iter.hasNext()) {
                            ICStorageElement valueElement = element.createChild("listOptionValue");
                            OptionStringValue ve = (OptionStringValue)iter.next();
                            ve.serialize(valueElement);
                        }
                    }
                    if (this.builtIns == null) break;
                    ListIterator iter = this.builtIns.listIterator();
                    while (iter.hasNext()) {
                        ICStorageElement valueElement = element.createChild("listOptionValue");
                        OptionStringValue ve = (OptionStringValue)iter.next();
                        ve.serialize(valueElement);
                    }
                    break;
                }
            }
        }
        if (this.defaultValue != null) {
            storeValueType = true;
            switch (this.getValueType()) {
                case 0: {
                    element.setAttribute("defaultValue", ((Boolean)this.defaultValue).toString());
                    break;
                }
                case 1: 
                case 2: {
                    element.setAttribute("defaultValue", (String)this.defaultValue);
                    break;
                }
            }
        }
        if (storeValueType) {
            switch (this.getValueType()) {
                case 0: {
                    str = "boolean";
                    break;
                }
                case 2: {
                    str = "string";
                    break;
                }
                case 1: {
                    str = "enumerated";
                    break;
                }
                case 3: {
                    str = "stringList";
                    break;
                }
                case 4: {
                    str = "includePath";
                    break;
                }
                case 6: {
                    str = "libs";
                    break;
                }
                case 7: {
                    str = "userObjs";
                    break;
                }
                case 5: {
                    str = "definedSymbols";
                    break;
                }
                case 8: {
                    str = "includeFiles";
                    break;
                }
                case 9: {
                    str = "libPaths";
                    break;
                }
                case 10: {
                    str = "libFiles";
                    break;
                }
                case 11: {
                    str = "symbolFiles";
                    break;
                }
                case -4: {
                    str = "undefIncludePath";
                    break;
                }
                case -5: {
                    str = "undefDefinedSymbols";
                    break;
                }
                case -8: {
                    str = "undefIncludeFiles";
                    break;
                }
                case -9: {
                    str = "undefLibPaths";
                    break;
                }
                case -10: {
                    str = "undefLibFiles";
                    break;
                }
                case -11: {
                    str = "undefSymbolFiles";
                    break;
                }
                default: {
                    str = EMPTY_STRING;
                }
            }
            element.setAttribute("valueType", str);
        }
        if (this.browseType != null) {
            switch (this.getBrowseType()) {
                case 0: {
                    str = "none";
                    break;
                }
                case 1: {
                    str = "file";
                    break;
                }
                case 2: {
                    str = "directory";
                    break;
                }
                default: {
                    str = EMPTY_STRING;
                }
            }
            element.setAttribute("browseType", str);
        }
        if (this.categoryId != null) {
            element.setAttribute("category", this.categoryId);
        }
        if (this.resourceFilter != null) {
            switch (this.getResourceFilter()) {
                case 0: {
                    str = "all";
                    break;
                }
                case 1: {
                    str = "file";
                    break;
                }
                case 2: {
                    str = "project";
                    break;
                }
                default: {
                    str = EMPTY_STRING;
                }
            }
            element.setAttribute("resourceFilter", str);
        }
        if (this.valueHandlerExtraArgument != null) {
            element.setAttribute("valueHandlerExtraArgument", this.valueHandlerExtraArgument);
        }
        this.isDirty = false;
    }

    public IBuildObject getParent() {
        return this.holder;
    }

    public IHoldsOptions getOptionHolder() {
        return this.holder;
    }

    public IOption getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    public String[] getApplicableValues() {
        if (this.enumList == null) {
            if (this.superClass != null) {
                return this.superClass.getApplicableValues();
            }
            return EMPTY_STRING_ARRAY;
        }
        if (this.enumList.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] enumNames = new String[this.enumList.size()];
        int index = 0;
        while (index < this.enumList.size()) {
            enumNames[index] = (String)this.getEnumNameMap().get(this.enumList.get(index));
            ++index;
        }
        return enumNames;
    }

    public boolean getBooleanValue() {
        return (Boolean)this.getValue();
    }

    public int getBrowseType() {
        if (this.browseType == null) {
            if (this.superClass != null) {
                return this.superClass.getBrowseType();
            }
            return 0;
        }
        return this.browseType;
    }

    public int getResourceFilter() {
        if (this.resourceFilter == null) {
            if (this.superClass != null) {
                return this.superClass.getResourceFilter();
            }
            return 0;
        }
        return this.resourceFilter;
    }

    public IConfigurationElement getApplicabilityCalculatorElement() {
        return this.applicabilityCalculatorElement;
    }

    public IOptionApplicability getApplicabilityCalculator() {
        if (this.applicabilityCalculator == null) {
            if (this.applicabilityCalculatorElement != null) {
                try {
                    if (this.applicabilityCalculatorElement.getAttribute("applicabilityCalculator") != null) {
                        this.applicabilityCalculator = (IOptionApplicability)this.applicabilityCalculatorElement.createExecutableExtension("applicabilityCalculator");
                    }
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            } else if (this.superClass != null) {
                this.applicabilityCalculator = this.superClass.getApplicabilityCalculator();
            }
        }
        return this.applicabilityCalculator;
    }

    public String[] getBuiltIns() {
        List list = this.getExactBuiltinsList();
        List valueList = this.listValueListToValueList(list);
        if (valueList == null) {
            return EMPTY_STRING_ARRAY;
        }
        return valueList.toArray(new String[valueList.size()]);
    }

    public List getExactBuiltinsList() {
        if (this.builtIns == null) {
            if (this.superClass != null) {
                return ((Option)this.superClass).getExactBuiltinsList();
            }
            return null;
        }
        return this.builtIns;
    }

    public IOptionCategory getCategory() {
        if (this.category == null) {
            if (this.superClass != null) {
                return this.superClass.getCategory();
            }
            if (this.getOptionHolder() instanceof ITool) {
                return ((ITool)this.getOptionHolder()).getTopOptionCategory();
            }
            return null;
        }
        return this.category;
    }

    public String getCommand() {
        if (this.command == null) {
            if (this.superClass != null) {
                return this.superClass.getCommand();
            }
            return EMPTY_STRING;
        }
        return this.command;
    }

    public String getCommandFalse() {
        if (this.commandFalse == null) {
            if (this.superClass != null) {
                return this.superClass.getCommandFalse();
            }
            return EMPTY_STRING;
        }
        return this.commandFalse;
    }

    public String getToolTip() {
        if (this.tip == null) {
            if (this.superClass != null) {
                return this.superClass.getToolTip();
            }
            return EMPTY_STRING;
        }
        return this.tip;
    }

    public String getContextId() {
        if (this.contextId == null) {
            if (this.superClass != null) {
                return this.superClass.getContextId();
            }
            return EMPTY_STRING;
        }
        return this.contextId;
    }

    public String[] getDefinedSymbols() throws BuildException {
        if (this.getValueType() != 5) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getEnumCommand(String id) throws BuildException {
        if (id == null) {
            return EMPTY_STRING;
        }
        if (this.enumList == null) {
            if (this.superClass != null) {
                return this.superClass.getEnumCommand(id);
            }
            return EMPTY_STRING;
        }
        if (this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        String cmd = (String)this.getEnumCommandMap().get(id);
        if (cmd == null) {
            ListIterator iter = this.enumList.listIterator();
            while (iter.hasNext()) {
                String realID = (String)iter.next();
                String name = (String)this.getEnumNameMap().get(realID);
                if (!id.equals(name)) continue;
                cmd = (String)this.getEnumCommandMap().get(realID);
                break;
            }
        }
        return cmd == null ? EMPTY_STRING : cmd;
    }

    public String getEnumName(String id) throws BuildException {
        if (id == null) {
            return EMPTY_STRING;
        }
        if (this.enumList == null) {
            if (this.superClass != null) {
                return this.superClass.getEnumName(id);
            }
            return EMPTY_STRING;
        }
        if (this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        String name = (String)this.getEnumNameMap().get(id);
        if (name == null) {
            name = id;
        }
        return name;
    }

    private Map getEnumCommandMap() {
        if (this.enumCommands == null) {
            this.enumCommands = new HashMap();
        }
        return this.enumCommands;
    }

    public String getEnumeratedId(String name) throws BuildException {
        if (name == null) {
            return null;
        }
        if (this.enumList == null) {
            if (this.superClass != null) {
                return this.superClass.getEnumeratedId(name);
            }
            return EMPTY_STRING;
        }
        if (this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        Set idSet = this.getEnumNameMap().keySet();
        for (String id : idSet) {
            String enumName = (String)this.getEnumNameMap().get(id);
            if (!name.equals(enumName)) continue;
            return id;
        }
        return null;
    }

    private Map getEnumNameMap() {
        if (this.enumNames == null) {
            this.enumNames = new HashMap();
        }
        return this.enumNames;
    }

    public String[] getIncludePaths() throws BuildException {
        if (this.getValueType() != 4) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String[] getLibraries() throws BuildException {
        if (this.getValueType() != 6) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getSelectedEnum() throws BuildException {
        if (this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.getStringValue();
    }

    public String[] getStringListValue() throws BuildException {
        if (this.getValueType() != 3) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public String getStringValue() throws BuildException {
        if (this.getValueType() != 2 && this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.getValue() == null ? EMPTY_STRING : (String)this.getValue();
    }

    public String[] getUserObjects() throws BuildException {
        if (this.getValueType() != 7) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    public int getValueType() throws BuildException {
        if (this.valueType == null) {
            if (this.superClass != null) {
                return this.superClass.getValueType();
            }
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.valueType;
    }

    public Object getValue() {
        Serializable val = this.getRawValue();
        if (val == null && (val = this.getDefaultValue()) == null) {
            int valType;
            try {
                valType = this.getValueType();
            }
            catch (BuildException buildException) {
                return EMPTY_STRING;
            }
            switch (valType) {
                case 0: {
                    val = new Boolean(false);
                    break;
                }
                case 2: {
                    val = EMPTY_STRING;
                    break;
                }
                case 1: {
                    val = EMPTY_STRING;
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -5: 
                case -4: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    val = new ArrayList();
                    break;
                }
                default: {
                    val = EMPTY_STRING;
                }
            }
        }
        return val;
    }

    public Object getExactValue() {
        Serializable val = this.getExactRawValue();
        if (val == null && (val = this.getExactDefaultValue()) == null) {
            int valType;
            try {
                valType = this.getValueType();
            }
            catch (BuildException buildException) {
                return EMPTY_STRING;
            }
            switch (valType) {
                case 0: {
                    val = new Boolean(false);
                    break;
                }
                case 2: {
                    val = EMPTY_STRING;
                    break;
                }
                case 1: {
                    val = EMPTY_STRING;
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -5: 
                case -4: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    val = new ArrayList();
                    break;
                }
                default: {
                    val = EMPTY_STRING;
                }
            }
        }
        return val;
    }

    public Object getRawValue() {
        Object ev = this.getExactRawValue();
        if (ev instanceof List) {
            ev = this.listValueListToValueList((List)ev);
        }
        return ev;
    }

    public Object getExactRawValue() {
        if (this.value == null && this.superClass != null) {
            Option mySuperClass = (Option)this.superClass;
            return mySuperClass.getExactRawValue();
        }
        return this.value;
    }

    private List listValueListToValueList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> valueList = new ArrayList<String>(list.size());
        int i = 0;
        while (i < list.size()) {
            OptionStringValue el = (OptionStringValue)list.get(i);
            valueList.add(el.getValue());
            ++i;
        }
        return valueList;
    }

    private List valueListToListValueList(List list, boolean builtIn) {
        if (list == null) {
            return null;
        }
        ArrayList<OptionStringValue> lvList = new ArrayList<OptionStringValue>(list.size());
        int i = 0;
        while (i < list.size()) {
            String v = (String)list.get(i);
            lvList.add(new OptionStringValue(v, builtIn));
            ++i;
        }
        return lvList;
    }

    public Object getDefaultValue() {
        Object ev = this.getExactDefaultValue();
        if (ev instanceof List) {
            ev = this.listValueListToValueList((List)ev);
        }
        return ev;
    }

    public Object getExactDefaultValue() {
        if (this.defaultValue == null && this.superClass != null) {
            return ((Option)this.superClass).getExactDefaultValue();
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Object v) {
        if (v instanceof List) {
            v = this.valueListToListValueList((List)v, false);
        }
        this.defaultValue = v;
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    public void setCategory(IOptionCategory category) {
        if (this.category != category) {
            this.category = category;
            this.categoryId = category != null ? category.getId() : null;
            if (!this.isExtensionElement()) {
                this.setDirty(true);
                this.rebuildState = true;
            }
        }
    }

    public void setCommand(String cmd) {
        if (cmd == null && this.command == null) {
            return;
        }
        if (cmd == null || this.command == null || !cmd.equals(this.command)) {
            this.command = cmd;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    public void setCommandFalse(String cmd) {
        if (cmd == null && this.commandFalse == null) {
            return;
        }
        if (cmd == null || this.commandFalse == null || !cmd.equals(this.commandFalse)) {
            this.commandFalse = cmd;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    public void setToolTip(String tooltip) {
        if (tooltip == null && this.tip == null) {
            return;
        }
        if (tooltip == null || this.tip == null || !tooltip.equals(this.tip)) {
            this.tip = tooltip;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    public void setContextId(String id) {
        if (id == null && this.contextId == null) {
            return;
        }
        if (id == null || this.contextId == null || !id.equals(this.contextId)) {
            this.contextId = id;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    public void setResourceFilter(int filter) {
        if (this.resourceFilter == null || filter != this.resourceFilter) {
            this.resourceFilter = new Integer(filter);
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    public void setBrowseType(int type) {
        if (this.browseType == null || type != this.browseType) {
            this.browseType = new Integer(type);
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    public void setValue(boolean value) throws BuildException {
        if (this.getValueType() != 0) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = new Boolean(value);
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    public void setValue(String value) throws BuildException {
        if (this.getValueType() != 2 && this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = value;
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    public void setValue(String[] value) throws BuildException {
        if (this.getValueType() == 3 || this.getValueType() == 4 || this.getValueType() == 5 || this.getValueType() == 6 || this.getValueType() == 7 || this.getValueType() == 8 || this.getValueType() == 9 || this.getValueType() == 10 || this.getValueType() == 11 || this.getValueType() == -4 || this.getValueType() == -5 || this.getValueType() == -8 || this.getValueType() == -9 || this.getValueType() == -10 || this.getValueType() == -11) {
            this.value = value == null ? null : this.valueListToListValueList(Arrays.asList(value), false);
        } else {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    public void setValue(OptionStringValue[] value) throws BuildException {
        if (this.getValueType() == 3 || this.getValueType() == 4 || this.getValueType() == 5 || this.getValueType() == 6 || this.getValueType() == 7 || this.getValueType() == 8 || this.getValueType() == 9 || this.getValueType() == 10 || this.getValueType() == 11 || this.getValueType() == -4 || this.getValueType() == -5 || this.getValueType() == -8 || this.getValueType() == -9 || this.getValueType() == -10 || this.getValueType() == -11) {
            this.value = value == null ? null : new ArrayList<OptionStringValue>(Arrays.asList(value));
        } else {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    public void setValue(Object v) {
        if (v instanceof List) {
            v = this.valueListToListValueList((List)v, false);
        }
        this.value = v;
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    public void setValueType(int type) {
        if (this.valueType == null || this.valueType != type) {
            this.valueType = new Integer(type);
            if (!this.isExtensionElement()) {
                this.setDirty(true);
                this.rebuildState = true;
            }
        }
    }

    public IConfigurationElement getValueHandlerElement() {
        if (this.valueHandlerElement == null && this.superClass != null) {
            return ((Option)this.superClass).getValueHandlerElement();
        }
        return this.valueHandlerElement;
    }

    public void setValueHandlerElement(IConfigurationElement element) {
        this.valueHandlerElement = element;
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    public IManagedOptionValueHandler getValueHandler() {
        if (this.valueHandler != null) {
            return this.valueHandler;
        }
        IConfigurationElement element = this.getValueHandlerElement();
        if (element != null) {
            try {
                if (element.getAttribute("valueHandler") != null) {
                    this.valueHandler = (IManagedOptionValueHandler)element.createExecutableExtension("valueHandler");
                    return this.valueHandler;
                }
            }
            catch (CoreException coreException) {
                ManagedBuildManager.optionValueHandlerError(element.getAttribute("valueHandler"), this.getId());
                this.valueHandler = ManagedOptionValueHandler.getManagedOptionValueHandler();
                return this.valueHandler;
            }
        }
        return ManagedOptionValueHandler.getManagedOptionValueHandler();
    }

    public String getValueHandlerExtraArgument() {
        if (this.valueHandlerExtraArgument == null) {
            if (this.superClass != null) {
                return this.superClass.getValueHandlerExtraArgument();
            }
            return EMPTY_STRING;
        }
        return this.valueHandlerExtraArgument;
    }

    public void setValueHandlerExtraArgument(String extraArgument) {
        if (extraArgument == null && this.valueHandlerExtraArgument == null) {
            return;
        }
        if (extraArgument == null || this.valueHandlerExtraArgument == null || !extraArgument.equals(this.valueHandlerExtraArgument)) {
            this.valueHandlerExtraArgument = extraArgument;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    public boolean isExtensionElement() {
        return this.isExtensionOption;
    }

    public boolean overridesOnlyValue() {
        return this.superClass != null && this.unusedChildren == null && this.browseType == null && (this.builtIns == null || this.builtIns.size() == 0) && this.category == null && this.categoryId == null && this.command == null && this.commandFalse == null && this.tip == null && this.contextId == null && this.enumList == null && this.enumCommands == null && this.enumNames == null && this.defaultValue == null;
    }

    public boolean isDirty() {
        if (this.isExtensionOption) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionOption(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.outputResolveError("superClass", this.superClassId, "option", this.getId());
                } else {
                    ((Option)this.superClass).resolveReferences();
                }
            }
            if (this.categoryId != null) {
                this.category = this.holder.getOptionCategory(this.categoryId);
                if (this.category == null) {
                    ManagedBuildManager.outputResolveError("category", this.categoryId, "option", this.getId());
                }
            }
            try {
                IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
                switch (this.getValueType()) {
                    case 0: {
                        String val = element.getAttribute("value");
                        if (val != null) {
                            this.value = new Boolean(val);
                        }
                        if ((val = element.getAttribute("defaultValue")) != null) {
                            this.defaultValue = new Boolean(val);
                        }
                        break;
                    }
                    case 2: {
                        this.value = element.getAttribute("value");
                        this.defaultValue = element.getAttribute("defaultValue");
                        break;
                    }
                    case 1: {
                        this.value = element.getAttribute("value");
                        this.defaultValue = element.getAttribute("defaultValue");
                        IManagedConfigElement[] enumElements = element.getChildren("enumeratedOptionValue");
                        int i = 0;
                        while (i < enumElements.length) {
                            String optId = enumElements[i].getAttribute("id");
                            if (i == 0) {
                                this.enumList = new ArrayList();
                                if (this.defaultValue == null) {
                                    this.defaultValue = optId;
                                }
                            }
                            this.enumList.add(optId);
                            this.getEnumCommandMap().put(optId, enumElements[i].getAttribute("command"));
                            this.getEnumNameMap().put(optId, enumElements[i].getAttribute("name"));
                            Boolean isDefault = new Boolean(enumElements[i].getAttribute("isDefault"));
                            if (isDefault.booleanValue()) {
                                this.defaultValue = optId;
                            }
                            ++i;
                        }
                        break;
                    }
                    case -11: 
                    case -10: 
                    case -9: 
                    case -8: 
                    case -5: 
                    case -4: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        ArrayList<OptionStringValue> vList = null;
                        IManagedConfigElement[] vElements = element.getChildren("listOptionValue");
                        int i = 0;
                        while (i < vElements.length) {
                            OptionStringValue ve;
                            if (i == 0) {
                                vList = new ArrayList<OptionStringValue>();
                                this.builtIns = new ArrayList();
                            }
                            if ((ve = new OptionStringValue(vElements[i])).isBuiltIn()) {
                                this.builtIns.add(ve);
                            } else {
                                vList.add(ve);
                            }
                            ++i;
                        }
                        this.value = vList;
                        break;
                    }
                }
            }
            catch (BuildException buildException) {}
        }
    }

    public String getManagedBuildRevision() {
        if (this.managedBuildRevision == null && this.getParent() != null) {
            return this.getParent().getManagedBuildRevision();
        }
        return this.managedBuildRevision;
    }

    protected boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    private void verify() {
        if (this.verified) {
            return;
        }
        this.verified = true;
        if (this.getOptionHolder() instanceof IToolChain && !this.isAbstract()) {
            if (this.getCategory() == null) {
                ManagedBuildManager.optionValidError(0, this.getId());
                this.isValid = false;
            }
            if (this.resourceFilter != null) {
                switch (this.getResourceFilter()) {
                    case 1: {
                        ManagedBuildManager.optionValidError(1, this.getId());
                        this.isValid = false;
                    }
                }
            }
        }
    }

    public boolean isValid() {
        if (!this.verified && this.resolved) {
            this.verify();
        }
        return this.isValid;
    }

    public boolean wasOptRef() {
        return this.wasOptRef;
    }

    public void setWasOptRef(boolean was) {
        this.wasOptRef = was;
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }

    public BooleanExpressionApplicabilityCalculator getBooleanExpressionCalculator(boolean isExtensionAdjustment) {
        if (this.booleanExpressionCalculator == null && !isExtensionAdjustment && this.superClass != null) {
            return ((Option)this.superClass).getBooleanExpressionCalculator(isExtensionAdjustment);
        }
        return this.booleanExpressionCalculator;
    }

    public boolean isAdjustedExtension() {
        return this.isUdjusted;
    }

    public void setAdjusted(boolean adjusted) {
        this.isUdjusted = adjusted;
    }

    public void setSuperClass(IOption superClass) {
        if (this.superClass != superClass) {
            this.superClass = superClass;
            this.superClassId = this.superClass == null ? null : this.superClass.getId();
            if (!this.isExtensionElement()) {
                this.setDirty(true);
            }
        }
    }

    public boolean needsRebuild() {
        return this.rebuildState;
    }

    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        this.rebuildState = rebuild;
    }

    public boolean matches(IOption option) {
        block3: {
            try {
                if (option.getValueType() == this.getValueType()) break block3;
                return false;
            }
            catch (BuildException buildException) {
                return false;
            }
        }
        return option.getName().equals(this.getName());
    }

    public String[] getRequiredTypeIds() {
        return new String[0];
    }

    public String[] getSupportedTypeIds() {
        String[] referenced = null;
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator(false);
        if (calc != null) {
            referenced = calc.getReferencedPropertyIds();
        }
        if (referenced == null) {
            referenced = new String[]{};
        }
        return referenced;
    }

    public String[] getSupportedValueIds(String typeId) {
        String[] referenced = null;
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator(false);
        if (calc != null) {
            referenced = calc.getReferencedValueIds(typeId);
        }
        if (referenced == null) {
            referenced = new String[]{};
        }
        return referenced;
    }

    public boolean requiresType(String typeId) {
        return false;
    }

    public boolean supportsType(String id) {
        boolean supports = false;
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator(false);
        if (calc != null && calc.referesProperty(id)) {
            supports = true;
        }
        return supports;
    }

    public boolean supportsValue(String typeId, String valueId) {
        boolean supports = false;
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator(false);
        if (calc != null && calc.referesPropertyValue(typeId, valueId)) {
            supports = true;
        }
        return supports;
    }

    public String[] getBasicStringListValue() throws BuildException {
        if (this.getBasicValueType() != 3) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        return v.toArray(new String[v.size()]);
    }

    public OptionStringValue[] getBasicStringListValueElements() throws BuildException {
        if (this.getBasicValueType() != 3) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getExactValue();
        if (v == null) {
            return EMPTY_LV_ARRAY;
        }
        return v.toArray(new OptionStringValue[v.size()]);
    }

    public int getBasicValueType() throws BuildException {
        switch (this.getValueType()) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 3;
    }

    public boolean hasCustomSettings() {
        if (this.superClass == null) {
            return true;
        }
        return this.value != null && !this.value.equals(this.superClass.getValue());
    }

    public static int getOppositeType(int type) {
        switch (type) {
            case 4: {
                return -4;
            }
            case 5: {
                return -5;
            }
            case 8: {
                return -8;
            }
            case 9: {
                return -9;
            }
            case 10: {
                return -10;
            }
            case 11: {
                return -11;
            }
            case -4: {
                return 4;
            }
            case -5: {
                return 5;
            }
            case -8: {
                return 8;
            }
            case -9: {
                return 9;
            }
            case -10: {
                return 10;
            }
            case -11: {
                return 11;
            }
        }
        return 0;
    }
}

