/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChainModificationHelper;
import org.eclipse.cdt.managedbuilder.internal.core.ToolListModificationInfo;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ConflictSet;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.DbgTcmUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.Messages;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeSetStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.TcModificationUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolChainModificationManager;
import org.eclipse.cdt.managedbuilder.tcmodification.CompatibilityStatus;
import org.eclipse.cdt.managedbuilder.tcmodification.IModificationOperation;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolListModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolModification;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class ToolListModification
implements IToolListModification {
    private HashSet fInputExtsSet = new HashSet();
    private ResourceInfo fRcInfo;
    private LinkedHashMap fProjCompInfoMap = new LinkedHashMap();
    private HashMap fSysCompInfoMap = new HashMap();
    private Tool[] fAllSysTools;
    private HashSet fFilteredOutSysTools;
    private PerTypeMapStorage fCompleteObjectStorage;
    protected TreeMap fCompletePathMapStorage;
    private HashSet fAddCapableTools;
    private Map fFilteredOutTools;
    private ToolListModificationInfo fModificationInfo;

    protected Set getInputExtsSet() {
        return this.fInputExtsSet;
    }

    private Set getAddCompatibleSysTools() {
        if (this.fAddCapableTools == null) {
            this.fAddCapableTools = new HashSet<Tool>(Arrays.asList(this.getAllSysTools()));
            PerTypeMapStorage storage = this.getCompleteObjectStore();
            ToolChainModificationManager.ConflictMatchSet conflicts = ToolChainModificationManager.getInstance().getConflictInfo(2, storage);
            this.fAddCapableTools.removeAll(conflicts.fObjToConflictListMap.keySet());
        }
        return this.fAddCapableTools;
    }

    public ToolListModification(ResourceInfo rcInfo, ITool[] tools) {
        this.fRcInfo = rcInfo;
        this.clearToolInfo(tools);
    }

    public ToolListModification(ResourceInfo rcInfo, ToolListModification base) {
        this.fRcInfo = rcInfo;
        IRealBuildObjectAssociation[] initialTools = (Tool[])rcInfo.getTools();
        Map initRealToToolMap = TcModificationUtil.getRealToObjectsMap(initialTools, new LinkedHashMap());
        IRealBuildObjectAssociation[] updatedTools = base.getTools(true, false);
        Map updatedRealToToolMap = TcModificationUtil.getRealToObjectsMap(updatedTools, new LinkedHashMap());
        for (Map.Entry entry : updatedRealToToolMap.entrySet()) {
            Object real = entry.getKey();
            Object initial = initRealToToolMap.get(real);
            if (initial != null) {
                entry.setValue(initial);
                continue;
            }
            IRealBuildObjectAssociation updated = (IRealBuildObjectAssociation)entry.getValue();
            if (updated.isExtensionBuildObject()) continue;
            updated = updated.getExtensionObject();
            entry.setValue(updated);
        }
        updatedRealToToolMap.values().toArray(updatedTools);
        this.clearToolInfo((ITool[])updatedTools);
        if (base.fAllSysTools != null) {
            this.fAllSysTools = (Tool[])base.fAllSysTools.clone();
        }
        if (base.fFilteredOutSysTools != null) {
            this.fFilteredOutSysTools = (HashSet)base.fFilteredOutSysTools.clone();
        }
        if (base.fCompleteObjectStorage != null) {
            this.fCompleteObjectStorage = TcModificationUtil.cloneRealToolToPathSet(base.fCompleteObjectStorage);
        }
        if (base.fCompletePathMapStorage != null) {
            this.fCompletePathMapStorage = base.fCompletePathMapStorage;
        }
    }

    public IResourceInfo getResourceInfo() {
        return this.fRcInfo;
    }

    protected abstract boolean canRemove(ITool var1);

    protected abstract boolean canReplace(Tool var1, Tool var2);

    protected abstract boolean canAdd(Tool var1);

    protected abstract Set getToolApplicabilityPathSet(Tool var1, boolean var2);

    protected abstract Set getExtensionConflictToolSet(Tool var1, Tool[] var2);

    protected abstract Tool[] filterTools(Tool[] var1);

    private Tool[] getAllSysTools() {
        if (this.fAllSysTools == null) {
            ITool[] allSys = ManagedBuildManager.getRealTools();
            this.fAllSysTools = this.filterTools((Tool[])allSys);
            HashSet<ITool> set = new HashSet<ITool>(Arrays.asList(allSys));
            set.removeAll(Arrays.asList(this.fAllSysTools));
            this.fFilteredOutSysTools = set;
        }
        return this.fAllSysTools;
    }

    public final void apply() throws CoreException {
        TreeMap initialMap = TcModificationUtil.createPathMap(this.fRcInfo.getParent());
        TreeMap cur = this.getCompletePathMapStorage();
        TreeMap result = TcModificationUtil.createResultingChangesMap(cur, initialMap);
        this.apply(result);
    }

    private void apply(TreeMap resultingChangeMap) throws CoreException {
        int[] types = new int[]{1, 4, 2};
        IConfiguration cfg = this.fRcInfo.getParent();
        for (Map.Entry entry : resultingChangeMap.entrySet()) {
            IPath path = (IPath)entry.getKey();
            ResourceInfo rcInfo = (ResourceInfo)cfg.getResourceInfo(path, true);
            if (rcInfo == null) {
                rcInfo = (FolderInfo)cfg.createFolderInfo(path);
            }
            PerTypeSetStorage storage = (PerTypeSetStorage)entry.getValue();
            int i = 0;
            while (i < types.length) {
                int type = types[i];
                Set set = storage.getSet(type, false);
                if (set != null) {
                    this.apply(rcInfo, type, set);
                }
                ++i;
            }
        }
    }

    private void apply(ResourceInfo rcInfo, int type, Set set) throws CoreException {
        switch (type) {
            case 2: {
                ToolListModificationInfo info = rcInfo == this.fRcInfo ? this.getModificationInfo() : ToolChainModificationHelper.getModificationInfo(rcInfo, rcInfo.getTools(), set.toArray(new Tool[set.size()]));
                info.apply();
                break;
            }
            case 1: {
                if (!rcInfo.isFolderInfo() || set.size() == 0) break;
                ToolChain tc = (ToolChain)set.iterator().next();
                try {
                    ((FolderInfo)rcInfo).changeToolChain(tc, CDataUtil.genId((String)tc.getId()), null);
                    break;
                }
                catch (BuildException e) {
                    throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e));
                }
            }
            case 4: {
                if (!rcInfo.isRoot() || set.size() == 0) break;
                Builder b = (Builder)set.iterator().next();
                rcInfo.getParent().changeBuilder(b, CDataUtil.genId((String)b.getId()), null);
            }
        }
    }

    private ToolListModificationInfo getModificationInfo() {
        if (this.fModificationInfo == null) {
            this.fModificationInfo = ToolChainModificationHelper.getModificationInfo(this.fRcInfo, this.fRcInfo.getTools(), this.getTools(true, false));
        }
        return this.fModificationInfo;
    }

    public IToolModification[] getProjectToolModifications() {
        Map map = this.getMap(true);
        return map.values().toArray(new ProjToolCompatibilityStatusInfo[map.size()]);
    }

    public ITool[] getProjectTools() {
        return this.getTools(true, false);
    }

    public IToolModification[] getSystemToolModifications() {
        Map map = this.getMap(false);
        return map.values().toArray(new SysToolCompatibilityStatusInfo[map.size()]);
    }

    public IToolModification getToolModification(ITool tool) {
        Tool rt = (Tool)ManagedBuildManager.getRealTool(tool);
        boolean isProj = this.isProjectTool(rt);
        Map map = this.getMap(isProj);
        IToolModification m = (IToolModification)map.get(rt);
        if (m == null) {
            ITool realTool = ManagedBuildManager.getRealTool(tool);
            boolean projFiltered = this.fFilteredOutTools.keySet().contains(realTool);
            m = new FilteredTool(tool, projFiltered);
        }
        return m;
    }

    private Map getMap(Tool tool) {
        return this.getMap(this.isProjectTool(tool));
    }

    private Map getMap(boolean proj) {
        return proj ? this.fProjCompInfoMap : this.fSysCompInfoMap;
    }

    private Tool[] getTools(boolean proj, boolean real) {
        if (proj) {
            if (real) {
                return this.fProjCompInfoMap.keySet().toArray(new Tool[this.fProjCompInfoMap.size()]);
            }
            Tool[] tools = new Tool[this.fProjCompInfoMap.size()];
            int i = 0;
            Iterator iter = this.fProjCompInfoMap.values().iterator();
            while (iter.hasNext()) {
                tools[i++] = ((ProjToolCompatibilityStatusInfo)iter.next()).fSelectedTool;
            }
            return tools;
        }
        return this.fSysCompInfoMap.keySet().toArray(new Tool[this.fSysCompInfoMap.size()]);
    }

    private boolean isProjectTool(Tool tool) {
        return this.fProjCompInfoMap.containsKey(tool.getRealBuildObject());
    }

    public void changeProjectTools(ITool removeTool, ITool addTool) {
        boolean added;
        boolean removed;
        HashMap map = this.createRealToToolMap();
        Tool realAdded = (Tool)ManagedBuildManager.getRealTool(addTool);
        Tool realRemoved = (Tool)ManagedBuildManager.getRealTool(removeTool);
        boolean bl = realRemoved != null ? map.remove(realRemoved) != null : (removed = false);
        boolean bl2 = realAdded != null ? map.put(realAdded, addTool) == null : (added = false);
        if (!added && !removed) {
            return;
        }
        Set rmSet = null;
        Set addSet = null;
        if (removed) {
            rmSet = this.getToolApplicabilityPathSet(realRemoved, true);
        }
        if (added) {
            addSet = rmSet == null ? this.getToolApplicabilityPathSet(realAdded, false) : rmSet;
        }
        ArrayList list = new ArrayList();
        list.addAll(map.values());
        this.clearToolInfo(map.values().toArray(new Tool[map.size()]));
        PerTypeMapStorage storage = this.getCompleteObjectStore();
        Map toolMap = storage.getMap(2, true);
        if (rmSet != null) {
            TcModificationUtil.removePaths(toolMap, realRemoved, rmSet);
        }
        if (addSet != null) {
            TcModificationUtil.addPaths(toolMap, realAdded, addSet);
        }
    }

    private HashMap createRealToToolMap() {
        HashMap map = new HashMap();
        for (Map.Entry entry : this.fProjCompInfoMap.entrySet()) {
            map.put(entry.getKey(), ((IToolModification)entry.getValue()).getTool());
        }
        return map;
    }

    protected void clearToolCompatibilityInfo() {
        Iterator iter = this.fProjCompInfoMap.values().iterator();
        while (iter.hasNext()) {
            ((ProjToolCompatibilityStatusInfo)iter.next()).clearCompatibilityInfo();
        }
        iter = this.fSysCompInfoMap.values().iterator();
        while (iter.hasNext()) {
            ((SysToolCompatibilityStatusInfo)iter.next()).clearCompatibilityInfo();
        }
    }

    protected void clearToolInfo(ITool[] tools) {
        IRealBuildObjectAssociation[] allTools;
        if (tools instanceof Tool[]) {
            allTools = (Tool[])tools;
        } else {
            allTools = new Tool[tools.length];
            System.arraycopy(tools, 0, allTools, 0, tools.length);
        }
        IRealBuildObjectAssociation[] filteredTools = this.filterTools((Tool[])allTools);
        Map filteredMap = TcModificationUtil.getRealToObjectsMap(filteredTools, null);
        Map allMap = TcModificationUtil.getRealToObjectsMap(allTools, null);
        allMap.keySet().removeAll(filteredMap.keySet());
        this.fFilteredOutTools = allMap;
        this.fModificationInfo = null;
        this.fInputExtsSet.clear();
        this.fProjCompInfoMap.clear();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            ITool realTool = ManagedBuildManager.getRealTool(tool);
            this.fProjCompInfoMap.put(realTool, new ProjToolCompatibilityStatusInfo((Tool)tool));
            if (!this.fFilteredOutTools.containsKey(realTool)) {
                this.fInputExtsSet.addAll(Arrays.asList(tool.getPrimaryInputExtensions()));
            }
            ++i;
        }
        this.fSysCompInfoMap.clear();
        Tool[] sysTools = this.getAllSysTools();
        int i2 = 0;
        while (i2 < sysTools.length) {
            Tool sysTool = sysTools[i2];
            if (!this.fProjCompInfoMap.containsKey(sysTool)) {
                this.fSysCompInfoMap.put(sysTool, new SysToolCompatibilityStatusInfo(sysTool));
            }
            ++i2;
        }
        this.fAddCapableTools = null;
        this.fCompletePathMapStorage = null;
    }

    protected PerTypeMapStorage getCompleteObjectStore() {
        if (this.fCompleteObjectStorage == null) {
            this.fCompleteObjectStorage = TcModificationUtil.createRealToolToPathSet(this.fRcInfo.getParent(), null, false);
            if (DbgTcmUtil.DEBUG) {
                DbgTcmUtil.println("dumping complete storage");
                DbgTcmUtil.dumpStorage(this.fCompleteObjectStorage);
            }
        }
        return this.fCompleteObjectStorage;
    }

    protected TreeMap getCompletePathMapStorage() {
        if (this.fCompletePathMapStorage == null) {
            this.fCompletePathMapStorage = TcModificationUtil.createPathMap(this.getCompleteObjectStore());
        }
        return this.fCompletePathMapStorage;
    }

    private class FilteredTool
    implements IToolModification {
        private ITool fTool;
        private boolean fIsProject;

        public FilteredTool(ITool tool, boolean isProject) {
            this.fTool = tool;
            this.fIsProject = isProject;
        }

        public CompatibilityStatus getCompatibilityStatus() {
            return this.fIsProject ? CompatibilityStatus.OK_COMPATIBILITY_STATUS : new CompatibilityStatus(4, Messages.getString("ToolListModification.0"), null);
        }

        public IModificationOperation[] getSupportedOperations() {
            return new IModificationOperation[0];
        }

        public ITool getTool() {
            return this.fTool;
        }

        public boolean isCompatible() {
            return this.fIsProject;
        }

        public boolean isProjectTool() {
            return this.fIsProject;
        }

        public IResourceInfo getResourceInfo() {
            return ToolListModification.this.getResourceInfo();
        }
    }

    private class ModificationOperation
    implements IModificationOperation {
        private ITool fReplacement;
        private IToolModification fModification;

        ModificationOperation(IToolModification modification, ITool tool) {
            this.fModification = modification;
            this.fReplacement = tool;
        }

        public ITool getReplacementTool() {
            return this.fReplacement;
        }

        public IToolModification getToolModification() {
            return this.fModification;
        }
    }

    public class ProjToolCompatibilityStatusInfo
    implements IToolModification {
        private ToolCompatibilityInfoElement fCurrentElement;
        private Map fCompatibleTools;
        private Map fInCompatibleTools;
        private IModificationOperation[] fOperations;
        private Tool fSelectedTool;
        private Tool fRealTool;
        private boolean fInited;
        private Set fExtConflictTools;

        ProjToolCompatibilityStatusInfo(Tool tool) {
            this.fSelectedTool = tool;
            this.fRealTool = (Tool)ManagedBuildManager.getRealTool(tool);
        }

        private ToolCompatibilityInfoElement getCurrentElement() {
            this.checkInitCompatibleTools();
            return this.fCurrentElement;
        }

        public CompatibilityStatus getCompatibilityStatus() {
            return this.getCurrentElement().getCompatibilityStatus();
        }

        public boolean isCompatible() {
            return this.getCurrentElement().isCompatible();
        }

        public boolean isProjectTool() {
            return true;
        }

        public Map getCompatibleTools() {
            this.checkInitCompatibleTools();
            return this.fCompatibleTools;
        }

        private void checkInitCompatibleTools() {
            if (this.fInited) {
                return;
            }
            if (DbgTcmUtil.DEBUG) {
                DbgTcmUtil.println("calculating compatibility for tool " + this.fRealTool.getUniqueRealName());
            }
            PerTypeMapStorage storage = ToolListModification.this.getCompleteObjectStore();
            Tool tool = this.fRealTool;
            Set rmSet = ToolListModification.this.getToolApplicabilityPathSet(tool, true);
            try {
                if (rmSet != null && rmSet.size() != 0) {
                    TcModificationUtil.removePaths(storage.getMap(2, false), tool, rmSet);
                }
                if (DbgTcmUtil.DEBUG) {
                    DbgTcmUtil.dumpStorage(storage);
                }
                ToolChainModificationManager.ConflictMatchSet conflicts = ToolChainModificationManager.getInstance().getConflictInfo(2, storage);
                this.fCompatibleTools = new HashMap();
                this.fInCompatibleTools = new HashMap();
                Tool[] sysTools = ToolListModification.this.getTools(false, true);
                Map conflictMap = conflicts.fObjToConflictListMap;
                int i = 0;
                while (i < sysTools.length) {
                    Tool t = sysTools[i];
                    List l = (List)conflictMap.get(t);
                    ToolCompatibilityInfoElement el = new ToolCompatibilityInfoElement(this, t, l);
                    if (el.isCompatible()) {
                        this.fCompatibleTools.put(t, el);
                    } else {
                        this.fInCompatibleTools.put(t, el);
                    }
                    ++i;
                }
                Tool t = this.fRealTool;
                List l = (List)conflictMap.get(t);
                this.fCurrentElement = new ToolCompatibilityInfoElement(this, t, l);
            }
            finally {
                if (rmSet != null && rmSet.size() != 0) {
                    TcModificationUtil.addPaths(storage.getMap(2, false), tool, rmSet);
                }
            }
            this.fInited = true;
        }

        private Set getConflictingTools() {
            if (this.fExtConflictTools == null) {
                Tool[] tmp = new Tool[]{this.fSelectedTool};
                this.fExtConflictTools = (tmp = ToolListModification.this.filterTools(tmp)).length == 0 ? Collections.EMPTY_SET : ToolListModification.this.getExtensionConflictToolSet(this.fSelectedTool, ToolListModification.this.filterTools(ToolListModification.this.getTools(true, false)));
            }
            return this.fExtConflictTools;
        }

        public IModificationOperation[] getSupportedOperations() {
            if (this.fOperations == null) {
                this.checkInitCompatibleTools();
                if (ToolListModification.this.fFilteredOutTools.containsKey(this.fRealTool)) {
                    this.fOperations = ToolListModification.this.canRemove(this.fRealTool) ? new ModificationOperation[]{new ModificationOperation(this, null)} : new ModificationOperation[0];
                } else {
                    ArrayList<ModificationOperation> opList = new ArrayList<ModificationOperation>(this.fCompatibleTools.size() + 1);
                    for (Tool tool : this.fCompatibleTools.keySet()) {
                        if (tool == this.fRealTool || !ToolListModification.this.canReplace(this.fRealTool, tool)) continue;
                        opList.add(new ModificationOperation(this, tool));
                    }
                    if (this.fCompatibleTools.size() == 0 || ToolListModification.this.canRemove(this.fRealTool)) {
                        opList.add(new ModificationOperation(this, null));
                    }
                    this.fOperations = opList.toArray(new ModificationOperation[opList.size()]);
                }
            }
            return (IModificationOperation[])this.fOperations.clone();
        }

        public ITool getTool() {
            return this.fSelectedTool;
        }

        public ITool getRealTool() {
            return this.fRealTool;
        }

        public IResourceInfo getResourceInfo() {
            return ToolListModification.this.fRcInfo;
        }

        public void clearCompatibilityInfo() {
            this.fInited = false;
            this.fCompatibleTools = null;
            this.fInCompatibleTools = null;
            this.fOperations = null;
            this.fCurrentElement = null;
            this.fExtConflictTools = null;
        }
    }

    public class SysToolCompatibilityStatusInfo
    implements IToolModification {
        private IModificationOperation[] fOperations;
        private Tool fSelectedTool;
        private Tool fRealTool;
        private CompatibilityStatus fStatus;

        SysToolCompatibilityStatusInfo(Tool tool) {
            this.fSelectedTool = tool;
            this.fRealTool = (Tool)ManagedBuildManager.getRealTool(tool);
        }

        public CompatibilityStatus getCompatibilityStatus() {
            if (this.fStatus == null) {
                String message;
                int severity;
                if (!this.isCompatible()) {
                    severity = 4;
                    message = Messages.getString("ToolListModification.2");
                } else {
                    severity = 0;
                    message = "";
                }
                this.fStatus = new CompatibilityStatus(severity, message, null);
            }
            return this.fStatus;
        }

        public boolean isCompatible() {
            return this.getSupportedOperationsArray().length > 0;
        }

        public boolean isProjectTool() {
            return false;
        }

        public IModificationOperation[] getSupportedOperationsArray() {
            if (this.fOperations == null) {
                Set addCompatibleSysToolsSet = ToolListModification.this.getAddCompatibleSysTools();
                if (addCompatibleSysToolsSet.contains(this.fRealTool) && ToolListModification.this.canAdd(this.fRealTool)) {
                    this.fOperations = new ModificationOperation[]{new ModificationOperation(this, null)};
                } else {
                    Map projMap = ToolListModification.this.getMap(true);
                    ArrayList<ModificationOperation> opList = new ArrayList<ModificationOperation>(projMap.size());
                    for (ProjToolCompatibilityStatusInfo info : projMap.values()) {
                        if (!info.getCompatibleTools().containsKey(this.fRealTool) || ToolListModification.this.fFilteredOutTools.containsKey(info.fRealTool) || !ToolListModification.this.canReplace(info.fSelectedTool, this.fSelectedTool)) continue;
                        opList.add(new ModificationOperation(this, info.fSelectedTool));
                    }
                    this.fOperations = opList.toArray(new ModificationOperation[opList.size()]);
                }
            }
            return this.fOperations;
        }

        public IModificationOperation[] getSupportedOperations() {
            return (IModificationOperation[])this.getSupportedOperationsArray().clone();
        }

        public ITool getTool() {
            return this.fSelectedTool;
        }

        public ITool getRealTool() {
            return this.fRealTool;
        }

        public IResourceInfo getResourceInfo() {
            return ToolListModification.this.fRcInfo;
        }

        public void clearCompatibilityInfo() {
            this.fOperations = null;
            this.fStatus = null;
        }
    }

    public class ToolCompatibilityInfoElement {
        private Tool fRealTool;
        private List fErrComflictMatchList;
        private CompatibilityStatus fStatus;
        private ProjToolCompatibilityStatusInfo fStatusInfo;

        ToolCompatibilityInfoElement(ProjToolCompatibilityStatusInfo statusInfo, Tool realTool, List errConflictList) {
            this.fStatusInfo = statusInfo;
            this.fRealTool = realTool;
            if (errConflictList != null && errConflictList.size() != 0) {
                this.fErrComflictMatchList = errConflictList;
            }
        }

        public CompatibilityStatus getCompatibilityStatus() {
            if (this.fStatus == null) {
                ConflictSet conflicts;
                String message;
                int severity;
                if (!this.isCompatible()) {
                    severity = 4;
                    message = Messages.getString("ToolListModification.4");
                    conflicts = new ConflictSet(this.fRealTool, this.fErrComflictMatchList, this.fStatusInfo.getConflictingTools());
                } else {
                    severity = 0;
                    message = "";
                    conflicts = null;
                }
                this.fStatus = new CompatibilityStatus(severity, message, conflicts);
            }
            return this.fStatus;
        }

        public boolean isCompatible() {
            return this.noCompatibilityConflicts() && (this.fRealTool != this.fStatusInfo.getRealTool() || this.fStatusInfo.getConflictingTools().size() == 0);
        }

        public boolean noCompatibilityConflicts() {
            return this.fErrComflictMatchList == null;
        }
    }
}

