/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.propertypages;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.model.ICBreakpointFilterExtension;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICThread;
import org.eclipse.cdt.debug.internal.ui.propertypages.CBreakpointFilteringPage;
import org.eclipse.cdt.debug.internal.ui.propertypages.PropertyPageMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ThreadFilterEditor {
    private CBreakpointFilteringPage fPage;
    private CheckboxTreeViewer fThreadViewer;
    private ThreadFilterContentProvider fContentProvider;
    private CheckHandler fCheckHandler;

    public ThreadFilterEditor(Composite parent, CBreakpointFilteringPage page) {
        this.fPage = page;
        this.fContentProvider = new ThreadFilterContentProvider();
        this.fCheckHandler = new CheckHandler();
        this.createThreadViewer(parent);
    }

    protected CBreakpointFilteringPage getPage() {
        return this.fPage;
    }

    private void createThreadViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PropertyPageMessages.getString("ThreadFilterEditor.0"));
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fThreadViewer = new CheckboxTreeViewer(parent, 2048);
        this.fThreadViewer.addCheckStateListener((ICheckStateListener)this.fCheckHandler);
        this.fThreadViewer.getTree().setLayoutData((Object)data);
        this.fThreadViewer.getTree().setFont(parent.getFont());
        this.fThreadViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fThreadViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        this.fThreadViewer.setInput((Object)DebugPlugin.getDefault().getLaunchManager());
        this.setInitialCheckedState();
    }

    protected IDebugTarget[] getDebugTargets() {
        Object input = this.fThreadViewer.getInput();
        if (!(input instanceof ILaunchManager)) {
            return new IDebugTarget[0];
        }
        ILaunchManager launchManager = (ILaunchManager)input;
        return launchManager.getDebugTargets();
    }

    protected CheckboxTreeViewer getThreadViewer() {
        return this.fThreadViewer;
    }

    protected void setInitialCheckedState() {
        ICBreakpointFilterExtension filterExtension = this.fPage.getFilterExtension();
        try {
            ICDebugTarget[] targets = filterExtension.getTargetFilters();
            int i = 0;
            while (i < targets.length) {
                ICThread[] filteredThreads = filterExtension.getThreadFilters(targets[i]);
                if (filteredThreads != null) {
                    int j = 0;
                    while (j < filteredThreads.length) {
                        this.fCheckHandler.checkThread((IThread)filteredThreads[j], true);
                        ++j;
                    }
                } else {
                    this.fCheckHandler.checkTarget((IDebugTarget)targets[i], true);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
        }
    }

    protected void doStore() {
        ICBreakpointFilterExtension filterExtension = this.fPage.getFilterExtension();
        IDebugTarget[] targets = this.getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] instanceof ICDebugTarget) {
                try {
                    if (this.getThreadViewer().getChecked((Object)targets[i])) {
                        if (this.getThreadViewer().getGrayed((Object)targets[i])) {
                            ICThread[] threads = this.getTargetThreadFilters((ICDebugTarget)targets[i]);
                            filterExtension.setThreadFilters(threads);
                        } else {
                            filterExtension.setTargetFilter((ICDebugTarget)targets[i]);
                        }
                    } else {
                        filterExtension.removeTargetFilter((ICDebugTarget)targets[i]);
                    }
                    DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)this.fPage.getBreakpoint());
                }
                catch (CoreException e) {
                    CDebugUIPlugin.log(e);
                }
            }
            ++i;
        }
    }

    private ICThread[] getTargetThreadFilters(ICDebugTarget target) {
        Object[] threads = ((ITreeContentProvider)this.getThreadViewer().getContentProvider()).getChildren((Object)target);
        ArrayList<Object> list = new ArrayList<Object>(threads.length);
        int i = 0;
        while (i < threads.length) {
            if (this.getThreadViewer().getChecked(threads[i])) {
                list.add(threads[i]);
            }
            ++i;
        }
        return list.toArray(new ICThread[list.size()]);
    }

    public class CheckHandler
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof IDebugTarget) {
                this.checkTarget((IDebugTarget)element, event.getChecked());
            } else if (element instanceof IThread) {
                this.checkThread((IThread)element, event.getChecked());
            }
        }

        protected void checkTarget(IDebugTarget target, boolean checked) {
            IThread[] threads;
            ThreadFilterEditor.this.getThreadViewer().setChecked((Object)target, checked);
            ThreadFilterEditor.this.getThreadViewer().setGrayed((Object)target, false);
            ThreadFilterEditor.this.getThreadViewer().expandToLevel((Object)target, -1);
            try {
                threads = target.getThreads();
            }
            catch (DebugException exception) {
                CDebugUIPlugin.log(exception);
                return;
            }
            int i = 0;
            while (i < threads.length) {
                ThreadFilterEditor.this.getThreadViewer().setChecked((Object)threads[i], checked);
                ThreadFilterEditor.this.getThreadViewer().setGrayed((Object)threads[i], false);
                ++i;
            }
        }

        protected void checkThread(IThread thread, boolean checked) {
            IThread[] threads;
            ThreadFilterEditor.this.getThreadViewer().setChecked((Object)thread, checked);
            IDebugTarget target = thread.getDebugTarget();
            try {
                threads = target.getThreads();
            }
            catch (DebugException exception) {
                CDebugUIPlugin.log(exception);
                return;
            }
            int checkedNumber = 0;
            int i = 0;
            while (i < threads.length) {
                if (ThreadFilterEditor.this.getThreadViewer().getChecked((Object)threads[i])) {
                    ++checkedNumber;
                }
                ++i;
            }
            if (checkedNumber == 0) {
                ThreadFilterEditor.this.getThreadViewer().setChecked((Object)target, false);
                ThreadFilterEditor.this.getThreadViewer().setGrayed((Object)target, false);
            } else if (checkedNumber == threads.length) {
                ThreadFilterEditor.this.getThreadViewer().setChecked((Object)target, true);
                ThreadFilterEditor.this.getThreadViewer().setGrayed((Object)target, false);
            } else {
                ThreadFilterEditor.this.getThreadViewer().setGrayChecked((Object)target, true);
            }
        }
    }

    public class ThreadFilterContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parent) {
            ICDebugTarget target;
            if (parent instanceof IDebugTarget && (target = (ICDebugTarget)((IDebugTarget)parent).getAdapter(ICDebugTarget.class)) != null) {
                try {
                    return ((ICDebugTarget)parent).getThreads();
                }
                catch (DebugException e) {
                    CDebugUIPlugin.log(e);
                }
            }
            if (parent instanceof ILaunchManager) {
                ArrayList<ICDebugTarget> children = new ArrayList<ICDebugTarget>();
                ILaunch[] launches = ((ILaunchManager)parent).getLaunches();
                int i = 0;
                int numLaunches = launches.length;
                while (i < numLaunches) {
                    IDebugTarget[] targets = launches[i].getDebugTargets();
                    int j = 0;
                    int numTargets = targets.length;
                    while (j < numTargets) {
                        ICDebugTarget target2 = (ICDebugTarget)targets[j].getAdapter(ICDebugTarget.class);
                        if (target2 != null && !target2.isDisconnected() && !target2.isTerminated()) {
                            children.add(target2);
                        }
                        ++j;
                    }
                    ++i;
                }
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IThread) {
                return ((IThread)element).getDebugTarget();
            }
            if (element instanceof IDebugTarget) {
                return ((IDebugElement)element).getLaunch();
            }
            if (element instanceof ILaunch) {
                return DebugPlugin.getDefault().getLaunchManager();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IStackFrame) {
                return false;
            }
            if (element instanceof IDebugElement) {
                return this.getChildren(element).length > 0;
            }
            if (element instanceof ILaunch) {
                return true;
            }
            if (element instanceof ILaunchManager) {
                return ((ILaunchManager)element).getLaunches().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

