/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.disassembly;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.core.resources.IMarker;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class DisassemblyAnnotationModel
extends AnnotationModel {
    private DisassemblyEditorInput fInput;

    protected void breakpointsAdded(final IBreakpoint[] breakpoints, final IDocument document) {
        DisassemblyEditorInput input = this.getInput();
        if (DisassemblyEditorInput.EMPTY_EDITOR_INPUT.equals(input) || DisassemblyEditorInput.PENDING_EDITOR_INPUT.equals(input)) {
            return;
        }
        this.asyncExec(new Runnable(){

            public void run() {
                DisassemblyAnnotationModel.this.breakpointsAdded0(breakpoints, document);
            }
        });
    }

    protected void breakpointsRemoved(final IBreakpoint[] breakpoints, final IDocument document) {
        DisassemblyEditorInput input = this.getInput();
        if (DisassemblyEditorInput.EMPTY_EDITOR_INPUT.equals(input) || DisassemblyEditorInput.PENDING_EDITOR_INPUT.equals(input)) {
            return;
        }
        this.asyncExec(new Runnable(){

            public void run() {
                DisassemblyAnnotationModel.this.breakpointsRemoved0(breakpoints, document);
            }
        });
    }

    protected void breakpointsChanged(final IBreakpoint[] breakpoints, final IDocument document) {
        DisassemblyEditorInput input = this.getInput();
        if (DisassemblyEditorInput.EMPTY_EDITOR_INPUT.equals(input) || DisassemblyEditorInput.PENDING_EDITOR_INPUT.equals(input)) {
            return;
        }
        this.asyncExec(new Runnable(){

            public void run() {
                DisassemblyAnnotationModel.this.breakpointsChanged0(breakpoints, document);
            }
        });
    }

    protected void breakpointsAdded0(IBreakpoint[] breakpoints, IDocument document) {
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof ICLineBreakpoint && this.isApplicable(breakpoints[i])) {
                this.addBreakpointAnnotation((ICLineBreakpoint)breakpoints[i], document);
            }
            ++i;
        }
        this.fireModelChanged();
    }

    protected void breakpointsRemoved0(IBreakpoint[] breakpoints, IDocument document) {
        this.removeAnnotations(this.findAnnotationsforBreakpoints(breakpoints), true, false);
    }

    protected void breakpointsChanged0(IBreakpoint[] breakpoints, IDocument document) {
        List annotations = this.findAnnotationsforBreakpoints(breakpoints);
        ArrayList<IMarker> markers = new ArrayList<IMarker>(annotations.size());
        for (MarkerAnnotation ma : annotations) {
            markers.add(ma.getMarker());
            this.modifyAnnotationPosition((Annotation)ma, this.getPosition((Annotation)ma), false);
        }
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof ICLineBreakpoint && !markers.contains(breakpoints[i].getMarker())) {
                this.addBreakpointAnnotation((ICLineBreakpoint)breakpoints[i], document);
            }
            ++i;
        }
        this.fireModelChanged();
    }

    protected DisassemblyEditorInput getInput() {
        return this.fInput;
    }

    protected void setInput(DisassemblyEditorInput input, IDocument document) {
        DisassemblyEditorInput oldInput = this.fInput;
        this.fInput = input;
        if (this.fInput != null && !this.fInput.equals(oldInput)) {
            this.updateAnnotations(document);
        }
    }

    private boolean isApplicable(IBreakpoint breakpoint) {
        return true;
    }

    private void addBreakpointAnnotation(ICLineBreakpoint breakpoint, IDocument document) {
        Position position = this.createBreakpointPosition(breakpoint, document);
        if (position != null) {
            try {
                this.addAnnotation((Annotation)this.createMarkerAnnotation((IBreakpoint)breakpoint), position, false);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private Position createBreakpointPosition(ICLineBreakpoint breakpoint, IDocument document) {
        Position position = null;
        DisassemblyEditorInput input = this.getInput();
        if (input != null) {
            int instrNumber;
            int start = -1;
            if (document != null && (instrNumber = input.getInstructionLine(breakpoint)) > 0) {
                try {
                    start = this.fDocument.getLineOffset(instrNumber - 1);
                    if (start > -1) {
                        int lineLen = document.getLineLength(instrNumber - 1);
                        if (start == 0) {
                            ++start;
                            --lineLen;
                        }
                        if (start + lineLen == document.getLength()) {
                            --lineLen;
                        }
                        return new Position(start, lineLen);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return position;
    }

    private MarkerAnnotation createMarkerAnnotation(IBreakpoint breakpoint) {
        return new MarkerAnnotation(breakpoint.getMarker());
    }

    protected void dispose() {
    }

    private List findAnnotationsforBreakpoints(IBreakpoint[] breakpoints) {
        LinkedList<Annotation> annotations = new LinkedList<Annotation>();
        Iterator it = this.getAnnotationIterator();
        while (it.hasNext()) {
            IMarker marker;
            Annotation ann = (Annotation)it.next();
            if (!(ann instanceof MarkerAnnotation) || (marker = ((MarkerAnnotation)ann).getMarker()) == null) continue;
            int i = 0;
            while (i < breakpoints.length) {
                if (marker.equals((Object)breakpoints[i].getMarker())) {
                    annotations.add(ann);
                }
                ++i;
            }
        }
        return annotations;
    }

    private void asyncExec(Runnable r) {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(r);
        }
    }

    private void updateAnnotations(final IDocument document) {
        this.asyncExec(new Runnable(){

            public void run() {
                DisassemblyAnnotationModel.this.doUpdateAnnotations(document);
            }
        });
    }

    protected void doUpdateAnnotations(IDocument document) {
        this.breakpointsAdded0(DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(), document);
    }
}

