/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.xlc.ui.properties;

import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionComboFieldEditor;
import org.eclipse.cdt.managedbuilder.xlc.ui.Messages;
import org.eclipse.cdt.managedbuilder.xlc.ui.XLCUIPlugin;
import org.eclipse.cdt.managedbuilder.xlc.ui.preferences.PreferenceConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class XLCompilerPropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private String originalMessage = this.getMessage();
    private DirectoryFieldEditor fPathEditor;
    private BuildOptionComboFieldEditor fVersionEditor;
    private IAdaptable element;

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.fPathEditor = new DirectoryFieldEditor("XL_compilerRoot", Messages.XLCompilerPropertyPage_0, parent){

            protected boolean doCheckState() {
                if (!super.doCheckState()) {
                    XLCompilerPropertyPage.this.setMessage(Messages.XLCompilerPropertyPage_2, 2);
                } else {
                    XLCompilerPropertyPage.this.setMessage(XLCompilerPropertyPage.this.originalMessage);
                }
                return true;
            }

            protected boolean checkState() {
                return this.doCheckState();
            }
        };
        this.addField((FieldEditor)this.fPathEditor);
        IProject project = ((IResource)this.getElement().getAdapter(IResource.class)).getProject();
        String currentPath = null;
        try {
            currentPath = project.getPersistentProperty(new QualifiedName("", "XL_compilerRoot"));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (currentPath == null) {
            IPreferenceStore prefStore = XLCUIPlugin.getDefault().getPreferenceStore();
            currentPath = prefStore.getString("XL_compilerRoot");
        }
        this.fPathEditor.setStringValue(currentPath);
        String[] versionEntries = new String[]{PreferenceConstants.P_XL_COMPILER_VERSION_8_NAME, PreferenceConstants.P_XL_COMPILER_VERSION_9_NAME, PreferenceConstants.P_XL_COMPILER_VERSION_10_NAME};
        Composite versionParent = this.getFieldEditorParent();
        this.fVersionEditor = new BuildOptionComboFieldEditor("XLC_compilerVersion", Messages.XLCompilerPropertyPage_1, versionEntries, null, versionParent);
        this.addField((FieldEditor)this.fVersionEditor);
        String currentVersion = null;
        try {
            currentVersion = project.getPersistentProperty(new QualifiedName("", "XLC_compilerVersion"));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (currentVersion == null) {
            IPreferenceStore prefStore = XLCUIPlugin.getDefault().getPreferenceStore();
            currentVersion = prefStore.getString("XLC_compilerVersion");
        }
        Combo versionCombo = this.fVersionEditor.getComboControl(versionParent);
        versionCombo.setText(PreferenceConstants.getVersionLabel(currentVersion));
    }

    public XLCompilerPropertyPage() {
        super(0);
    }

    protected void performDefaults() {
        IPreferenceStore prefStore = XLCUIPlugin.getDefault().getPreferenceStore();
        String currentPath = prefStore.getString("XL_compilerRoot");
        String currentVersion = prefStore.getString("XLC_compilerVersion");
        String currentVersionLabel = PreferenceConstants.getVersionLabel(currentVersion);
        this.fPathEditor.setStringValue(currentPath);
        this.fVersionEditor.getComboControl(this.getFieldEditorParent()).setText(currentVersionLabel);
    }

    public boolean performOk() {
        try {
            IProject project = ((IResource)this.getElement().getAdapter(IResource.class)).getProject();
            project.setPersistentProperty(new QualifiedName("", "XL_compilerRoot"), this.fPathEditor.getStringValue());
            String version = PreferenceConstants.getVersion(this.fVersionEditor.getSelection());
            project.setPersistentProperty(new QualifiedName("", "XLC_compilerVersion"), version);
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }
}

