/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.cdtvariables;

import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;

public class CdtVariable
implements ICdtVariable {
    protected String fName;
    protected int fType;
    protected String fStringValue;
    protected String[] fStringListValue;

    protected CdtVariable() {
    }

    public CdtVariable(String name, int type, String value) {
        this.fName = name;
        this.fType = type;
        this.fStringValue = value;
    }

    public CdtVariable(String name, int type, String[] value) {
        this.fName = name;
        this.fType = type;
        this.fStringListValue = value;
    }

    public CdtVariable(ICdtVariable var) {
        this.fName = var.getName();
        this.fType = var.getValueType();
        try {
            if (CdtVariableResolver.isStringListVariable(this.fType)) {
                this.fStringListValue = var.getStringListValue();
            } else {
                this.fStringValue = var.getStringValue();
            }
        }
        catch (CdtVariableException cdtVariableException) {}
    }

    public String getName() {
        return this.fName;
    }

    public int getValueType() {
        return this.fType;
    }

    public String getStringValue() throws CdtVariableException {
        if (CdtVariableResolver.isStringListVariable(this.fType)) {
            throw new CdtVariableException(4, this.fName, null, this.fName);
        }
        return this.fStringValue;
    }

    public String[] getStringListValue() throws CdtVariableException {
        if (!CdtVariableResolver.isStringListVariable(this.fType)) {
            throw new CdtVariableException(5, this.fName, null, this.fName);
        }
        return this.fStringListValue;
    }
}

