/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class CASTTypeId
extends ASTNode
implements IASTTypeId {
    private IASTDeclSpecifier declSpecifier;
    private IASTDeclarator declarator;

    public CASTTypeId() {
    }

    public CASTTypeId(IASTDeclSpecifier declSpecifier, IASTDeclarator declarator) {
        this.setDeclSpecifier(declSpecifier);
        this.setAbstractDeclarator(declarator);
    }

    public CASTTypeId copy() {
        CASTTypeId copy = new CASTTypeId();
        copy.setDeclSpecifier(this.declSpecifier == null ? null : this.declSpecifier.copy());
        copy.setAbstractDeclarator(this.declarator == null ? null : this.declarator.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpecifier;
    }

    public void setDeclSpecifier(IASTDeclSpecifier declSpec) {
        this.assertNotFrozen();
        this.declSpecifier = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    public IASTDeclarator getAbstractDeclarator() {
        return this.declarator;
    }

    public void setAbstractDeclarator(IASTDeclarator abstractDeclarator) {
        this.assertNotFrozen();
        this.declarator = abstractDeclarator;
        if (abstractDeclarator != null) {
            abstractDeclarator.setParent(this);
            abstractDeclarator.setPropertyInParent(ABSTRACT_DECLARATOR);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitTypeIds) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declSpecifier != null && !this.declSpecifier.accept(action)) {
            return false;
        }
        if (this.declarator != null && !this.declarator.accept(action)) {
            return false;
        }
        if (action.shouldVisitTypeIds) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

