/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTBinaryExpression
extends ASTNode
implements ICPPASTBinaryExpression,
IASTAmbiguityParent {
    private int op;
    private IASTExpression operand1;
    private IASTExpression operand2;
    private IType type;
    private ICPPFunction overload = UNINITIALIZED_FUNCTION;
    private IASTImplicitName[] implicitNames = null;

    public CPPASTBinaryExpression() {
    }

    public CPPASTBinaryExpression(int op, IASTExpression operand1, IASTExpression operand2) {
        this.op = op;
        this.setOperand1(operand1);
        this.setOperand2(operand2);
    }

    public CPPASTBinaryExpression copy() {
        CPPASTBinaryExpression copy = new CPPASTBinaryExpression();
        copy.op = this.op;
        copy.setOperand1(this.operand1 == null ? null : this.operand1.copy());
        copy.setOperand2(this.operand2 == null ? null : this.operand2.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public int getOperator() {
        return this.op;
    }

    public IASTExpression getOperand1() {
        return this.operand1;
    }

    public IASTExpression getOperand2() {
        return this.operand2;
    }

    public void setOperator(int op) {
        this.assertNotFrozen();
        this.op = op;
    }

    public void setOperand1(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand1 = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_ONE);
        }
    }

    public void setOperand2(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand2 = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_TWO);
        }
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction overload = this.getOverload();
            if (overload == null) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            CPPASTImplicitName operatorName = new CPPASTImplicitName(overload.getNameCharArray(), (IASTNode)this);
            operatorName.setBinding(overload);
            operatorName.setOperator(true);
            operatorName.computeOperatorOffsets(this.operand1, true);
            this.implicitNames = new IASTImplicitName[]{operatorName};
        }
        return this.implicitNames;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.operand1 != null && !this.operand1.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (!name.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.operand2 != null && !this.operand2.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand1) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand1 = (IASTExpression)other;
        }
        if (child == this.operand2) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand2 = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        if (this.type == null) {
            this.type = this.createExpressionType();
        }
        return this.type;
    }

    public ICPPFunction getOverload() {
        if (this.overload != UNINITIALIZED_FUNCTION) {
            return this.overload;
        }
        this.overload = CPPSemantics.findOverloadedOperator(this);
        return this.overload;
    }

    private IType createExpressionType() {
        IType type1;
        IType ultimateType1;
        ICPPFunction o = this.getOverload();
        if (o != null) {
            try {
                return o.getType().getReturnType();
            }
            catch (DOMException e) {
                e.getProblem();
            }
        }
        if ((ultimateType1 = SemanticUtil.getUltimateTypeUptoPointers(type1 = this.getOperand1().getExpressionType())) instanceof IProblemBinding) {
            return type1;
        }
        IType type2 = this.getOperand2().getExpressionType();
        IType ultimateType2 = SemanticUtil.getUltimateTypeUptoPointers(type2);
        if (ultimateType2 instanceof IProblemBinding) {
            return type2;
        }
        int op = this.getOperator();
        switch (op) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 28: 
            case 29: {
                CPPBasicType basicType = new CPPBasicType(6, 0);
                basicType.setFromExpression(this);
                return basicType;
            }
            case 4: {
                if (!(ultimateType2 instanceof IPointerType)) break;
                return ultimateType2;
            }
            case 5: {
                if (!(ultimateType2 instanceof IPointerType)) break;
                if (ultimateType1 instanceof IPointerType) {
                    return CPPVisitor.getPointerDiffType(this);
                }
                return ultimateType1;
            }
            case 30: 
            case 31: {
                if (type2 instanceof ICPPPointerToMemberType) {
                    try {
                        return ((ICPPPointerToMemberType)type2).getType();
                    }
                    catch (DOMException e) {
                        return e.getProblem();
                    }
                }
                return new ProblemBinding(this, 5, this.getRawSignature().toCharArray());
            }
        }
        return type1;
    }
}

