/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTParameterDeclaration
extends ASTNode
implements ICPPASTParameterDeclaration,
IASTAmbiguityParent {
    private IASTDeclSpecifier declSpec;
    private IASTDeclarator declarator;

    public CPPASTParameterDeclaration() {
    }

    public CPPASTParameterDeclaration(IASTDeclSpecifier declSpec, IASTDeclarator declarator) {
        this.setDeclSpecifier(declSpec);
        this.setDeclarator(declarator);
    }

    public CPPASTParameterDeclaration copy() {
        CPPASTParameterDeclaration copy = new CPPASTParameterDeclaration();
        copy.setDeclSpecifier(this.declSpec == null ? null : this.declSpec.copy());
        copy.setDeclarator(this.declarator == null ? null : this.declarator.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpec;
    }

    public IASTDeclarator getDeclarator() {
        return this.declarator;
    }

    public void setDeclSpecifier(IASTDeclSpecifier declSpec) {
        this.assertNotFrozen();
        this.declSpec = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    public void setDeclarator(IASTDeclarator declarator) {
        this.assertNotFrozen();
        this.declarator = declarator;
        if (declarator != null) {
            declarator.setParent(this);
            declarator.setPropertyInParent(DECLARATOR);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitParameterDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declSpec != null && !this.declSpec.accept(action)) {
            return false;
        }
        if (this.declarator != null && !this.declarator.accept(action)) {
            return false;
        }
        if (action.shouldVisitParameterDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.declarator) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.declarator = (IASTDeclarator)other;
        }
    }
}

