/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.index.PointerTypeClone;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public class PDOMPointerType
extends PDOMNode
implements IPointerType,
ITypeContainer,
IIndexType {
    private static final int FLAGS = 8;
    private static final int TYPE = 9;
    protected static final int RECORD_SIZE = 13;
    private static final int CONST = 1;
    private static final int VOLATILE = 2;
    private byte flags = (byte)-1;
    private IType targetType;

    public PDOMPointerType(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public PDOMPointerType(PDOMLinkage linkage, PDOMNode parent, IPointerType type) throws CoreException {
        super(linkage, parent);
        Database db = this.getDB();
        try {
            long typeRec = 0L;
            byte flags = 0;
            if (type != null) {
                IType targetType = type.getType();
                PDOMNode targetTypeNode = this.getLinkage().addType(this, targetType);
                if (targetTypeNode != null) {
                    typeRec = targetTypeNode.getRecord();
                }
                if (type.isConst()) {
                    flags = (byte)(flags | 1);
                }
                if (type.isVolatile()) {
                    flags = (byte)(flags | 2);
                }
            }
            db.putRecPtr(this.record + 9L, typeRec);
            db.putByte(this.record + 8L, flags);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    protected int getRecordSize() {
        return 13;
    }

    public int getNodeType() {
        return 1;
    }

    private byte getFlags() throws CoreException {
        if (this.flags == -1) {
            this.flags = this.getDB().getByte(this.record + 8L);
        }
        return this.flags;
    }

    public IType getType() {
        if (this.targetType == null) {
            this.targetType = this.readType();
        }
        return this.targetType;
    }

    private IType readType() {
        try {
            PDOMNode node = this.getLinkage().getNode(this.getDB().getRecPtr(this.record + 9L));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isConst() {
        try {
            return (this.getFlags() & 1) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isVolatile() {
        try {
            return (this.getFlags() & 2) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isSameType(IType type) {
        if (type instanceof ITypedef) {
            return ((ITypedef)type).isSameType(this);
        }
        if (!(type instanceof IPointerType)) {
            return false;
        }
        if (this instanceof ICPPPointerToMemberType != type instanceof ICPPPointerToMemberType) {
            return false;
        }
        IPointerType rhs = (IPointerType)type;
        try {
            IType type1;
            if (this.isConst() == rhs.isConst() && this.isVolatile() == rhs.isVolatile() && (type1 = this.getType()) != null) {
                return type1.isSameType(rhs.getType());
            }
        }
        catch (DOMException dOMException) {}
        return false;
    }

    public void setType(IType type) {
        throw new PDOMNotImplementedError();
    }

    public Object clone() {
        return new PointerTypeClone(this);
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        linkage.deleteType(this.getType(), this.record);
        super.delete(linkage);
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }
}

