/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCAnnotation;

class PDOMCPPAnnotation {
    public static final int MUTABLE_OFFSET = 2;
    public static final int EXTERN_C_OFFSET = 6;
    public static final int VISIBILITY_OFFSET = 6;
    private static final int VISIBILITY_MASK = 3;
    public static final int VIRTUAL_OFFSET = 0;
    public static final int DESTRUCTOR_OFFSET = 1;
    public static final int IMPLICIT_METHOD_OFFSET = 2;
    public static final int EXPLICIT_CONSTRUCTOR_OFFSET = 3;
    public static final int PURE_VIRTUAL_OFFSET = 4;
    public static final int MAX_EXTRA_OFFSET = 4;

    PDOMCPPAnnotation() {
    }

    public static byte encodeAnnotation(IBinding binding) throws DOMException {
        byte modifiers = PDOMCAnnotation.encodeAnnotation(binding);
        if (binding instanceof ICPPMember) {
            ICPPMember member = (ICPPMember)binding;
            int mask = -193;
            modifiers = (byte)(modifiers & mask);
            modifiers = (byte)(modifiers | (member.getVisibility() & 3) << 6);
            if (binding instanceof ICPPField) {
                ICPPField variable = (ICPPField)binding;
                modifiers = (byte)(modifiers | (variable.isMutable() ? 1 : 0) << 2);
            }
        } else {
            if (binding instanceof ICPPFunction && ((ICPPFunction)binding).isExternC()) {
                modifiers = (byte)(modifiers | 0x40);
            }
            if (binding instanceof ICPPVariable && ((ICPPVariable)binding).isExternC()) {
                modifiers = (byte)(modifiers | 0x40);
            }
        }
        return modifiers;
    }

    public static byte encodeExtraAnnotation(IBinding binding) throws DOMException {
        ICPPConstructor constructor;
        byte modifiers = 0;
        if (binding instanceof ICPPMethod) {
            ICPPMethod method = (ICPPMethod)binding;
            modifiers = (byte)(modifiers | (method.isVirtual() ? 1 : 0) << 0);
            modifiers = (byte)(modifiers | (method.isDestructor() ? 1 : 0) << 1);
            modifiers = (byte)(modifiers | (method.isImplicit() ? 1 : 0) << 2);
            modifiers = (byte)(modifiers | (method.isPureVirtual() ? 1 : 0) << 4);
        }
        if (binding instanceof ICPPConstructor && (constructor = (ICPPConstructor)binding).isExplicit()) {
            modifiers = (byte)(modifiers | 8);
        }
        return modifiers;
    }

    public static int getVisibility(byte annotation) {
        return annotation >> 6 & 3;
    }
}

