/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMPartialSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPArgumentList;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassTemplate;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassTemplatePartialSpecialization
extends PDOMCPPClassTemplate
implements IPDOMPartialSpecialization,
ICPPSpecialization,
IPDOMOverloader {
    private static final int ARGUMENTS = 52;
    private static final int SIGNATURE_HASH = 56;
    private static final int PRIMARY = 60;
    private static final int NEXT_PARTIAL = 64;
    protected static final int RECORD_SIZE = 68;

    public PDOMCPPClassTemplatePartialSpecialization(PDOMCPPLinkage linkage, PDOMNode parent, ICPPClassTemplatePartialSpecialization partial, PDOMCPPClassTemplate primary) throws CoreException, DOMException {
        super(linkage, parent, partial);
        this.getDB().putRecPtr(this.record + 60L, primary.getRecord());
        primary.addPartial(this);
        try {
            Integer sigHash = IndexCPPSignatureUtil.getSignatureHash(partial);
            this.getDB().putInt(this.record + 56L, sigHash != null ? sigHash : 0);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
        PDOMCPPLinkage pDOMCPPLinkage = linkage;
        pDOMCPPLinkage.getClass();
        new PDOMCPPLinkage.ConfigurePartialSpecialization(pDOMCPPLinkage, this, partial);
    }

    public PDOMCPPClassTemplatePartialSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    public int getSignatureHash() throws CoreException {
        return this.getDB().getInt(this.record + 56L);
    }

    protected int getRecordSize() {
        return 68;
    }

    public int getNodeType() {
        return 25;
    }

    public PDOMCPPClassTemplatePartialSpecialization getNextPartial() throws CoreException {
        long value = this.getDB().getRecPtr(this.record + 64L);
        return value != 0L ? new PDOMCPPClassTemplatePartialSpecialization((PDOMLinkage)this.getLinkage(), value) : null;
    }

    public void setNextPartial(PDOMCPPClassTemplatePartialSpecialization partial) throws CoreException {
        long value = partial != null ? partial.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 64L, value);
    }

    public ICPPClassTemplate getPrimaryClassTemplate() {
        try {
            return new PDOMCPPClassTemplate((PDOMLinkage)this.getLinkage(), this.getDB().getRecPtr(this.record + 60L));
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IBinding getSpecializedBinding() {
        return this.getPrimaryClassTemplate();
    }

    public void setArguments(ICPPTemplateArgument[] templateArguments) throws CoreException {
        Database db = this.getPDOM().getDB();
        long oldRec = db.getRecPtr(this.record + 52L);
        long rec = PDOMCPPArgumentList.putArguments(this, templateArguments);
        db.putRecPtr(this.record + 52L, rec);
        if (oldRec != 0L) {
            PDOMCPPArgumentList.clearArguments(this, oldRec);
        }
    }

    public ICPPTemplateArgument[] getTemplateArguments() {
        try {
            long rec = this.getPDOM().getDB().getRecPtr(this.record + 52L);
            return PDOMCPPArgumentList.getArguments(this, rec);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPTemplateArgument.EMPTY_ARGUMENTS;
        }
    }

    @Deprecated
    public IType[] getArguments() {
        return CPPTemplates.getArguments(this.getTemplateArguments());
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        if (cmp == 0) {
            if (other instanceof PDOMCPPClassTemplatePartialSpecialization) {
                try {
                    PDOMCPPClassTemplatePartialSpecialization otherSpec = (PDOMCPPClassTemplatePartialSpecialization)other;
                    int mySM = this.getSignatureHash();
                    int otherSM = otherSpec.getSignatureHash();
                    return mySM == otherSM ? 0 : (mySM < otherSM ? -1 : 1);
                }
                catch (CoreException ce) {
                    CCorePlugin.log(ce);
                }
            } else {
                throw new PDOMNotImplementedError();
            }
        }
        return cmp;
    }

    public ICPPTemplateParameterMap getTemplateParameterMap() {
        return CPPTemplates.createParameterMap(this.getPrimaryClassTemplate(), this.getTemplateArguments());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            if (node.getRecord() != this.getRecord()) return false;
            return true;
        }
        if (!(type instanceof ICPPClassTemplatePartialSpecialization)) {
            return false;
        }
        ICPPClassTemplatePartialSpecialization rhs = (ICPPClassTemplatePartialSpecialization)type;
        try {
            ICPPTemplateArgument[] args2;
            ICPPClassTemplate ct1 = this.getPrimaryClassTemplate();
            ICPPClassTemplate ct2 = rhs.getPrimaryClassTemplate();
            if (!ct1.isSameType(ct2)) {
                return false;
            }
            ICPPTemplateArgument[] args1 = this.getTemplateArguments();
            if (args1.length != (args2 = rhs.getTemplateArguments()).length) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= args2.length) {
                    return true;
                }
                if (args1[i].isSameValue(args2[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    @Deprecated
    public ObjectMap getArgumentMap() {
        try {
            ICPPTemplateParameter[] params = this.getPrimaryClassTemplate().getTemplateParameters();
            ICPPTemplateArgument[] args = this.getTemplateArguments();
            int len = Math.min(params.length, args.length);
            ObjectMap result = new ObjectMap(len);
            int i = 0;
            while (i < len) {
                result.put(params[i], args[i]);
                ++i;
            }
        }
        catch (DOMException dOMException) {}
        return ObjectMap.EMPTY_MAP;
    }
}

