/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.List;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;

public class CExternalSettingSerializer {
    static final String ELEMENT_SETTING_INFO = "externalSetting";
    private static final String ATTRIBUTE_EXTENSIONS = "extensions";
    private static final String ATTRIBUTE_CONTENT_TYPE_IDS = "contentTypes";
    private static final String ATTRIBUTE_LANGUAGE_IDS = "languages";
    private static final String SEPARATOR = ":";

    public static CExternalSetting load(ICStorageElement element) {
        String[] langIds = null;
        String[] cTypeIds = null;
        String[] exts = null;
        String tmp = element.getAttribute(ATTRIBUTE_LANGUAGE_IDS);
        if (tmp != null) {
            langIds = CDataUtil.stringToArray(tmp, SEPARATOR);
        }
        if ((tmp = element.getAttribute(ATTRIBUTE_CONTENT_TYPE_IDS)) != null) {
            cTypeIds = CDataUtil.stringToArray(tmp, SEPARATOR);
        }
        if ((tmp = element.getAttribute(ATTRIBUTE_EXTENSIONS)) != null) {
            exts = CDataUtil.stringToArray(tmp, SEPARATOR);
        }
        List entriesList = LanguageSettingEntriesSerializer.loadEntriesList(element, 63);
        ICSettingEntry[] entries = entriesList.toArray(new ICSettingEntry[entriesList.size()]);
        return new CExternalSetting(langIds, cTypeIds, exts, entries);
    }

    public static void store(CExternalSetting setting, ICStorageElement el) {
        String[] tmp = setting.getCompatibleLanguageIds();
        if (tmp != null) {
            el.setAttribute(ATTRIBUTE_LANGUAGE_IDS, CDataUtil.arrayToString(tmp, SEPARATOR));
        }
        if ((tmp = setting.getCompatibleContentTypeIds()) != null) {
            el.setAttribute(ATTRIBUTE_CONTENT_TYPE_IDS, CDataUtil.arrayToString(tmp, SEPARATOR));
        }
        if ((tmp = setting.getCompatibleExtensions()) != null) {
            el.setAttribute(ATTRIBUTE_EXTENSIONS, CDataUtil.arrayToString(tmp, SEPARATOR));
        }
        LanguageSettingEntriesSerializer.serializeEntries(setting.getEntries(), el);
    }
}

