/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.pty.PTYInputStream;
import org.eclipse.cdt.utils.pty.PTYOutputStream;

public class PTY {
    String slave;
    PTYInputStream in;
    PTYOutputStream out;
    int master;
    private static boolean hasPTY;

    static {
        try {
            System.loadLibrary("pty");
            hasPTY = true;
        }
        catch (SecurityException securityException) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
    }

    public PTY() throws IOException {
        if (hasPTY) {
            this.slave = this.openMaster();
        }
        if (this.slave == null) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.cannotCreatePty"));
        }
        this.in = new PTYInputStream(new MasterFD());
        this.out = new PTYOutputStream(new MasterFD());
    }

    public String getSlaveName() {
        return this.slave;
    }

    public MasterFD getMasterFD() {
        return new MasterFD();
    }

    public PTYOutputStream getOutputStream() {
        return this.out;
    }

    public PTYInputStream getInputStream() {
        return this.in;
    }

    public static boolean isSupported() {
        return hasPTY;
    }

    native String openMaster();

    public class MasterFD {
        public int getFD() {
            return PTY.this.master;
        }

        void setFD(int fd) {
            PTY.this.master = fd;
        }
    }
}

