/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.internal.ui.search.PDOMSearchElement;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class LineSearchElement
extends PDOMSearchElement {
    private final int fOffset;
    private final int fNumber;
    private final String fContent;
    private final Match[] fMatches;
    private static final MatchesComparator MATCHES_COMPARATOR = new MatchesComparator();

    private LineSearchElement(IIndexFileLocation file, Match[] matches, int number, String content, int offset) {
        super(file);
        this.fMatches = matches;
        this.fNumber = number;
        int index = 0;
        int length = content.length();
        int firstMatchOffset = matches[0].getOffset();
        while (offset < firstMatchOffset && length > 0) {
            if (!Character.isWhitespace(content.charAt(index))) break;
            ++index;
            ++offset;
            --length;
        }
        this.fOffset = offset;
        this.fContent = content.substring(index);
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLineNumber() {
        return this.fNumber;
    }

    public String getContent() {
        return this.fContent;
    }

    public Match[] getMatches() {
        return this.fMatches;
    }

    public String toString() {
        return String.valueOf(this.fNumber) + ": " + this.fContent;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LineSearchElement)) {
            return false;
        }
        LineSearchElement other = (LineSearchElement)obj;
        return this.fOffset == other.fOffset && super.equals(obj) && this.fMatches.equals(other.fMatches);
    }

    public int hashCode() {
        return this.fOffset + 31 * (super.hashCode() + 31 * this.fMatches.hashCode());
    }

    public static LineSearchElement[] createElements(IIndexFileLocation fileLocation, Match[] matches) {
        Arrays.sort(matches, MATCHES_COMPARATOR);
        LineSearchElement[] result = new LineSearchElement[]{};
        try {
            String path = fileLocation.getURI().getPath();
            CodeReader reader = new CodeReader(path);
            result = LineSearchElement.collectLineElements(reader.buffer, matches, fileLocation);
        }
        catch (IOException e) {
            CUIPlugin.log(e);
        }
        return result;
    }

    public static LineSearchElement[] createElements(IIndexFileLocation fileLocation, Match[] matches, IDocument document) {
        Arrays.sort(matches, MATCHES_COMPARATOR);
        ArrayList<LineSearchElement> result = new ArrayList<LineSearchElement>();
        int firstMatch = 0;
        while (firstMatch < matches.length) {
            try {
                int lineNumber = document.getLineOfOffset(matches[firstMatch].getOffset());
                int lineOffset = document.getLineOffset(lineNumber);
                int lineLength = document.getLineLength(lineNumber);
                int nextlineOffset = lineOffset + lineLength;
                int nextMatch = firstMatch;
                int nextMatchOffset = matches[nextMatch].getOffset();
                while (nextMatch < matches.length && nextMatchOffset < nextlineOffset) {
                    if (++nextMatch >= matches.length) continue;
                    nextMatchOffset = matches[nextMatch].getOffset();
                }
                int lineMatchesCount = nextMatch - firstMatch;
                Match[] lineMatches = new Match[lineMatchesCount];
                System.arraycopy(matches, firstMatch, lineMatches, 0, lineMatchesCount);
                String content = document.get(lineOffset, lineLength);
                result.add(new LineSearchElement(fileLocation, lineMatches, lineNumber + 1, content, lineOffset));
                firstMatch = nextMatch;
            }
            catch (BadLocationException e) {
                CUIPlugin.log(e);
            }
        }
        return result.toArray(new LineSearchElement[result.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private static LineSearchElement[] collectLineElements(char[] buffer, Match[] matches, IIndexFileLocation fileLocation) {
        result = new ArrayList<LineSearchElement>();
        skipLF = false;
        lineNumber = 1;
        lineOffset = 0;
        lineFirstMatch = -1;
        nextMatch = 0;
        nextMatchOffset = matches[nextMatch].getOffset();
        pos = 0;
        while (pos < buffer.length) {
            c = buffer[pos];
            if (!skipLF) ** GOTO lbl-1000
            skipLF = false;
            if (c == '\n') {
                lineOffset = pos + 1;
            } else if (c == '\n' || c == '\r') {
                if (lineFirstMatch != -1) {
                    lineLength = pos - lineOffset;
                    lineMatchesCount = nextMatch - lineFirstMatch;
                    lineMatches = new Match[lineMatchesCount];
                    System.arraycopy(matches, lineFirstMatch, lineMatches, 0, lineMatchesCount);
                    lineContent = new String(buffer, lineOffset, lineLength);
                    result.add(new LineSearchElement(fileLocation, lineMatches, lineNumber, lineContent, lineOffset));
                    lineFirstMatch = -1;
                    if (nextMatch >= matches.length) break;
                    if (matches[nextMatch].getOffset() < pos) {
                        lineFirstMatch = nextMatch;
                    }
                }
                ++lineNumber;
                lineOffset = pos + 1;
                if (c == '\r') {
                    skipLF = true;
                }
            } else if (nextMatchOffset <= pos) {
                if (lineFirstMatch == -1) {
                    lineFirstMatch = nextMatch;
                }
                nextMatchOffset = ++nextMatch < matches.length ? matches[nextMatch].getOffset() : buffer.length;
            }
            ++pos;
        }
        if (lineFirstMatch != -1) {
            lineLength = buffer.length - lineOffset;
            lineMatchesCount = nextMatch - lineFirstMatch;
            lineMatches = new Match[lineMatchesCount];
            System.arraycopy(matches, lineFirstMatch, lineMatches, 0, lineMatchesCount);
            lineContent = new String(buffer, lineOffset, lineLength);
            result.add(new LineSearchElement(fileLocation, lineMatches, lineNumber, lineContent, lineOffset));
        }
        return result.toArray(new LineSearchElement[result.size()]);
    }

    public static final class Match {
        private final int fOffset;
        private final int fLength;
        private final boolean fIsPolymorphicCall;
        private final ICElement fEnclosingElement;

        public Match(int offset, int length, boolean isPolymorphicCall, ICElement enclosingElement) {
            this.fOffset = offset;
            this.fLength = length;
            this.fIsPolymorphicCall = isPolymorphicCall;
            this.fEnclosingElement = enclosingElement;
        }

        public int getOffset() {
            return this.fOffset;
        }

        public int getLength() {
            return this.fLength;
        }

        public boolean isPolymorphicCall() {
            return this.fIsPolymorphicCall;
        }

        public ICElement getEnclosingElement() {
            return this.fEnclosingElement;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Match)) {
                return false;
            }
            Match m = (Match)obj;
            return this.fOffset == m.fOffset && this.fLength == m.fLength;
        }

        public int hashCode() {
            return 31 * this.fOffset + this.fLength;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MatchesComparator
    implements Comparator<Match> {
        private MatchesComparator() {
        }

        @Override
        public int compare(Match m1, Match m2) {
            return m1.getOffset() - m2.getOffset();
        }
    }
}

