/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling.engine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.eclipse.cdt.internal.ui.text.spelling.SpellingPreferences;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellCheckIterator;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellEvent;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellEventListener;
import org.eclipse.cdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.cdt.internal.ui.text.spelling.engine.SpellEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSpellChecker
implements ISpellChecker {
    public static final String[] URL_PREFIXES = new String[]{"http://", "https://", "www.", "ftp://", "ftps://", "news://", "mailto://"};
    private final Set<ISpellDictionary> fDictionaries = Collections.synchronizedSet(new HashSet());
    private final Set<String> fIgnored = Collections.synchronizedSet(new HashSet());
    private final Set<ISpellEventListener> fListeners = Collections.synchronizedSet(new HashSet());
    private Locale fLocale;

    protected static boolean isDigits(String word) {
        int index = 0;
        while (index < word.length()) {
            if (Character.isDigit(word.charAt(index))) {
                return true;
            }
            ++index;
        }
        return false;
    }

    protected static boolean isMixedCase(String word, boolean sentence) {
        int length = word.length();
        boolean upper = Character.isUpperCase(word.charAt(0));
        if (sentence && upper && length > 1) {
            upper = Character.isUpperCase(word.charAt(1));
        }
        if (upper) {
            int index = length - 1;
            while (index > 0) {
                if (Character.isLowerCase(word.charAt(index))) {
                    return true;
                }
                --index;
            }
        } else {
            int index = length - 1;
            while (index > 0) {
                if (Character.isUpperCase(word.charAt(index))) {
                    return true;
                }
                --index;
            }
        }
        return false;
    }

    protected static boolean isUpperCase(String word) {
        int index = word.length() - 1;
        while (index >= 0) {
            if (Character.isLowerCase(word.charAt(index))) {
                return false;
            }
            --index;
        }
        return true;
    }

    protected static boolean isUrl(String word) {
        String[] stringArray = URL_PREFIXES;
        int n = URL_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (word.startsWith(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public DefaultSpellChecker(IPreferenceStore store, Locale locale) {
        Assert.isLegal((store != null ? 1 : 0) != 0);
        Assert.isLegal((locale != null ? 1 : 0) != 0);
        this.fLocale = locale;
    }

    @Override
    public final void addDictionary(ISpellDictionary dictionary) {
        this.fDictionaries.add(dictionary);
    }

    @Override
    public final void addListener(ISpellEventListener listener) {
        this.fListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptsWords() {
        HashSet<ISpellDictionary> copy;
        Set<ISpellDictionary> set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet<ISpellDictionary>(this.fDictionaries);
        }
        ISpellDictionary dictionary2 = null;
        for (ISpellDictionary dictionary2 : copy) {
            if (!dictionary2.acceptsWords()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWord(String word) {
        HashSet<ISpellDictionary> copy;
        Set<ISpellDictionary> set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet<ISpellDictionary>(this.fDictionaries);
        }
        String addable = word.toLowerCase();
        for (ISpellDictionary dictionary : copy) {
            if (!dictionary.acceptsWords()) continue;
            dictionary.addWord(addable);
        }
    }

    @Override
    public final void checkWord(String word) {
        this.fIgnored.remove(word.toLowerCase());
    }

    @Override
    public void execute(ISpellCheckIterator iterator) {
        boolean ignoreDigits = SpellingPreferences.isIgnoreDigits();
        boolean ignoreMixed = SpellingPreferences.isIgnoreMixed();
        boolean ignoreSentence = SpellingPreferences.isIgnoreSentence();
        boolean ignoreUpper = SpellingPreferences.isIgnoreUpper();
        boolean ignoreUrls = SpellingPreferences.isIgnoreUrls();
        boolean ignoreNonLetters = SpellingPreferences.isIgnoreNonLetters();
        boolean ignoreSingleLetters = SpellingPreferences.isIgnoreSingleLetters();
        iterator.setIgnoreSingleLetters(ignoreSingleLetters);
        Iterator<ISpellDictionary> iter = this.fDictionaries.iterator();
        while (iter.hasNext()) {
            iter.next().setStripNonLetters(ignoreNonLetters);
        }
        String word = null;
        boolean starts = false;
        while (iterator.hasNext()) {
            word = (String)iterator.next();
            if (word == null || this.fIgnored.contains(word)) continue;
            starts = iterator.startsSentence();
            if (!this.isCorrect(word)) {
                boolean isMixed = DefaultSpellChecker.isMixedCase(word, true);
                boolean isUpper = DefaultSpellChecker.isUpperCase(word);
                boolean isDigits = DefaultSpellChecker.isDigits(word);
                boolean isUrl = DefaultSpellChecker.isUrl(word);
                if (!(!ignoreMixed && isMixed || !ignoreUpper && isUpper || !ignoreDigits && isDigits || !ignoreUrls && isUrl) && (isMixed || isUpper || isDigits || isUrl)) continue;
                this.fireEvent(new SpellEvent(this, word, iterator.getBegin(), iterator.getEnd(), starts, false));
                continue;
            }
            if (ignoreSentence || !starts || !Character.isLowerCase(word.charAt(0))) continue;
            this.fireEvent(new SpellEvent(this, word, iterator.getBegin(), iterator.getEnd(), true, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireEvent(ISpellEvent event) {
        HashSet<ISpellEventListener> copy;
        Set<ISpellEventListener> set = this.fListeners;
        synchronized (set) {
            copy = new HashSet<ISpellEventListener>(this.fListeners);
        }
        for (ISpellEventListener spellEventListener : copy) {
            spellEventListener.handle(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RankedWordProposal> getProposals(String word, boolean sentence) {
        HashSet<ISpellDictionary> copy;
        Set<ISpellDictionary> set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet<ISpellDictionary>(this.fDictionaries);
        }
        ISpellDictionary dictionary2 = null;
        HashSet<RankedWordProposal> proposals = new HashSet<RankedWordProposal>();
        for (ISpellDictionary dictionary2 : copy) {
            proposals.addAll(dictionary2.getProposals(word, sentence));
        }
        return proposals;
    }

    @Override
    public final void ignoreWord(String word) {
        this.fIgnored.add(word.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isCorrect(String word) {
        HashSet<ISpellDictionary> copy;
        Set<ISpellDictionary> set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet<ISpellDictionary>(this.fDictionaries);
        }
        if (this.fIgnored.contains(word.toLowerCase())) {
            return true;
        }
        ISpellDictionary dictionary2 = null;
        for (ISpellDictionary dictionary2 : copy) {
            if (!dictionary2.isCorrect(word)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void removeDictionary(ISpellDictionary dictionary) {
        this.fDictionaries.remove(dictionary);
    }

    @Override
    public final void removeListener(ISpellEventListener listener) {
        this.fListeners.remove(listener);
    }

    @Override
    public Locale getLocale() {
        return this.fLocale;
    }
}

