/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.transport;

import java.util.Properties;
import java.util.Vector;
import org.eclipse.cdt.debug.ui.memory.transport.MemoryTransportPlugin;
import org.eclipse.cdt.debug.ui.memory.transport.model.IMemoryExporter;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ExportMemoryDialog
extends SelectionDialog {
    private Combo fFormatCombo;
    private IMemoryBlock fMemoryBlock;
    private Control fCurrentControl = null;
    private IMemoryExporter[] fFormatExporters;
    private String[] fFormatNames;
    private Properties fProperties = new Properties();

    public ExportMemoryDialog(Shell parent, IMemoryBlock memoryBlock) {
        super(parent);
        super.setTitle("Export Memory");
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMemoryBlock = memoryBlock;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (results != null) {
            return results;
        }
        return new Object[0];
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.fCurrentControl != null) {
            this.fCurrentControl.dispose();
        }
        this.fFormatExporters[this.fFormatCombo.getSelectionIndex()].exportMemory();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(MemoryTransportPlugin.getUniqueIdentifier()) + ".ExportMemoryDialog_context");
        Composite composite = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        Label textLabel = new Label(composite, 0);
        textLabel.setText("Format: ");
        this.fFormatCombo = new Combo(composite, 2056);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fFormatCombo, 0, 0x1000000);
        textLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)textLabel);
        this.fFormatCombo.setLayoutData((Object)data);
        Vector<IMemoryExporter> exporters = new Vector<IMemoryExporter>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.cdt.debug.ui.memory.transport.memoryTransport");
        IConfigurationElement[] points = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < points.length) {
            IConfigurationElement element = points[i];
            if ("exporter".equals(element.getName())) {
                try {
                    exporters.addElement((IMemoryExporter)element.createExecutableExtension("class"));
                }
                catch (Exception e) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, "Failure", (Throwable)e));
                }
            }
            ++i;
        }
        this.fFormatExporters = new IMemoryExporter[exporters.size()];
        this.fFormatNames = new String[exporters.size()];
        i = 0;
        while (i < this.fFormatExporters.length) {
            this.fFormatExporters[i] = (IMemoryExporter)exporters.elementAt(i);
            this.fFormatNames[i] = ((IMemoryExporter)exporters.elementAt(i)).getName();
            ++i;
        }
        final Composite container = new Composite(composite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fFormatCombo);
        data.left = new FormAttachment(0);
        container.setLayoutData((Object)data);
        this.fFormatCombo.setItems(this.fFormatNames);
        this.fFormatCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ExportMemoryDialog.this.fCurrentControl != null) {
                    ExportMemoryDialog.this.fCurrentControl.dispose();
                }
                ExportMemoryDialog.this.fCurrentControl = ExportMemoryDialog.this.fFormatExporters[ExportMemoryDialog.this.fFormatCombo.getSelectionIndex()].createControl(container, ExportMemoryDialog.this.fMemoryBlock, ExportMemoryDialog.this.fProperties, ExportMemoryDialog.this);
            }
        });
        this.fFormatCombo.select(0);
        this.fCurrentControl = this.fFormatExporters[0].createControl(container, this.fMemoryBlock, this.fProperties, this);
        return composite;
    }

    public void setValid(boolean isValid) {
        this.getButton(0).setEnabled(isValid);
    }
}

