/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICTargetPlatformSetting;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class CoreModelUtil {
    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        int length = exclusionPatterns.length;
        char[][] fullCharExclusionPatterns = new char[length][];
        int i = 0;
        while (i < length) {
            fullCharExclusionPatterns[i] = exclusionPatterns[i].toString().toCharArray();
            ++i;
        }
        return CoreModelUtil.isExcluded(resourcePath, (char[][])fullCharExclusionPatterns);
    }

    public static final boolean isExcluded(IResource resource, char[][] exclusionPatterns) {
        IPath path = resource.getFullPath();
        if (resource.getType() == 2) {
            path = path.append("*");
        }
        return CoreModelUtil.isExcluded(path, exclusionPatterns);
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        char[][] cArray = exclusionPatterns;
        int n = exclusionPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            char[] exclusionPattern = cArray[n2];
            if (CoreModelUtil.prefixOfCharArray(exclusionPattern, path)) {
                return true;
            }
            if (CoreModelUtil.pathMatch(exclusionPattern, path, true, '/')) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static boolean prefixOfCharArray(char[] a, char[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len > b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return i >= b.length || b[i] == '/';
    }

    public static final boolean match(char[] pattern, char[] name, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        return CoreModelUtil.match(pattern, 0, pattern.length, name, 0, name.length, isCaseSensitive);
    }

    public static final boolean match(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        if (patternEnd < 0) {
            patternEnd = pattern.length;
        }
        if (nameEnd < 0) {
            nameEnd = name.length;
        }
        char patternChar = '\u0000';
        while (iPattern < patternEnd && (patternChar = pattern[iPattern]) != '*') {
            if (iName == nameEnd) {
                return false;
            }
            if (patternChar != (isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) && patternChar != '?') {
                return false;
            }
            ++iName;
            ++iPattern;
        }
        int segmentStart = patternChar == '*' ? ++iPattern : 0;
        int prefixStart = iName;
        while (iName < nameEnd) {
            if (iPattern == patternEnd) {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            patternChar = pattern[iPattern];
            if (patternChar == '*') {
                if ((segmentStart = ++iPattern) == patternEnd) {
                    return true;
                }
                prefixStart = iName;
                continue;
            }
            if ((isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) != patternChar && patternChar != '?') {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            ++iName;
            ++iPattern;
        }
        return segmentStart == patternEnd || iName == nameEnd && iPattern == patternEnd || iPattern == patternEnd - 1 && pattern[iPattern] == '*';
    }

    public static final boolean pathMatch(char[] pattern, char[] filepath, boolean isCaseSensitive, char pathSeparator) {
        int pSegmentRestart;
        if (filepath == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int pSegmentStart = pattern[0] == pathSeparator ? 1 : 0;
        int pLength = pattern.length;
        int pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart + 1);
        if (pSegmentEnd < 0) {
            pSegmentEnd = pLength;
        }
        boolean freeTrailingDoubleStar = pattern[pLength - 1] == pathSeparator;
        int fLength = filepath.length;
        int fSegmentStart = filepath[0] != pathSeparator ? 0 : 1;
        if (fSegmentStart != pSegmentStart) {
            return false;
        }
        int fSegmentEnd = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentStart + 1);
        if (fSegmentEnd < 0) {
            fSegmentEnd = fLength;
        }
        while (!(pSegmentStart >= pLength || pSegmentEnd == pLength && freeTrailingDoubleStar || pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*')) {
            if (fSegmentStart >= fLength) {
                return false;
            }
            if (!CoreModelUtil.match(pattern, pSegmentStart, pSegmentEnd, filepath, fSegmentStart, fSegmentEnd, isCaseSensitive)) {
                return false;
            }
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            if ((fSegmentEnd = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentStart = fSegmentEnd + 1)) >= 0) continue;
            fSegmentEnd = fLength;
        }
        if (pSegmentStart >= pLength && freeTrailingDoubleStar || pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*') {
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            pSegmentRestart = pSegmentStart;
        } else {
            if (pSegmentStart >= pLength) {
                return fSegmentStart >= fLength;
            }
            pSegmentRestart = 0;
        }
        int fSegmentRestart = fSegmentStart;
        while (fSegmentStart < fLength) {
            if (pSegmentStart >= pLength) {
                if (freeTrailingDoubleStar) {
                    return true;
                }
                pSegmentStart = pSegmentRestart;
                pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart);
                if (pSegmentEnd < 0) {
                    pSegmentEnd = pLength;
                }
                if ((fSegmentRestart = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentRestart + 1)) < 0) {
                    fSegmentRestart = fLength;
                }
                fSegmentStart = ++fSegmentRestart;
                fSegmentEnd = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentStart);
                if (fSegmentEnd >= 0) continue;
                fSegmentEnd = fLength;
                continue;
            }
            if (pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*') {
                pSegmentStart = pSegmentEnd + 1;
                if ((pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                    pSegmentEnd = pLength;
                }
                pSegmentRestart = pSegmentStart;
                fSegmentRestart = fSegmentStart;
                if (pSegmentStart < pLength) continue;
                return true;
            }
            if (!CoreModelUtil.match(pattern, pSegmentStart, pSegmentEnd, filepath, fSegmentStart, fSegmentEnd, isCaseSensitive)) {
                pSegmentStart = pSegmentRestart;
                pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart);
                if (pSegmentEnd < 0) {
                    pSegmentEnd = pLength;
                }
                if ((fSegmentRestart = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentRestart + 1)) < 0) {
                    fSegmentRestart = fLength;
                }
                fSegmentStart = ++fSegmentRestart;
                fSegmentEnd = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentStart);
                if (fSegmentEnd >= 0) continue;
                fSegmentEnd = fLength;
                continue;
            }
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CoreModelUtil.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            if ((fSegmentEnd = CoreModelUtil.indexOf(pathSeparator, filepath, fSegmentStart = fSegmentEnd + 1)) >= 0) continue;
            fSegmentEnd = fLength;
        }
        return pSegmentRestart >= pSegmentEnd || fSegmentStart >= fLength && pSegmentStart >= pLength || pSegmentStart == pLength - 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*' || pSegmentStart == pLength && freeTrailingDoubleStar;
    }

    public static final int indexOf(char toBeFound, char[] array) {
        int i = 0;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(char toBeFound, char[] array, int start) {
        int i = start;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ITranslationUnit findTranslationUnitForLocation(IPath location, ICProject preferredProject) throws CModelException {
        IFile[] files = ResourceLookup.findFilesForLocation(location);
        if (files.length > 0) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                ITranslationUnit tu = CoreModelUtil.findTranslationUnit(file);
                if (tu != null) {
                    return tu;
                }
                ++n2;
            }
        } else {
            CoreModel coreModel = CoreModel.getDefault();
            ITranslationUnit tu = null;
            if (preferredProject != null) {
                tu = coreModel.createTranslationUnitFrom(preferredProject, location);
            }
            if (tu == null) {
                ICProject[] projects = coreModel.getCModel().getCProjects();
                int i = 0;
                while (i < projects.length && tu == null) {
                    ICProject project = projects[i];
                    if (!project.equals(preferredProject)) {
                        tu = coreModel.createTranslationUnitFrom(project, location);
                    }
                    ++i;
                }
            }
            return tu;
        }
        return null;
    }

    public static ITranslationUnit findTranslationUnitForLocation(URI locationURI, ICProject preferredProject) throws CModelException {
        IFile[] files = ResourceLookup.findFilesForLocationURI(locationURI);
        if (files.length > 0) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                ITranslationUnit tu = CoreModelUtil.findTranslationUnit(file);
                if (tu != null) {
                    return tu;
                }
                ++n2;
            }
        } else {
            CoreModel coreModel = CoreModel.getDefault();
            ITranslationUnit tu = null;
            if (preferredProject != null) {
                tu = coreModel.createTranslationUnitFrom(preferredProject, locationURI);
            }
            if (tu == null) {
                ICProject[] projects = coreModel.getCModel().getCProjects();
                int i = 0;
                while (i < projects.length && tu == null) {
                    ICProject project = projects[i];
                    if (!project.equals(preferredProject)) {
                        tu = coreModel.createTranslationUnitFrom(project, locationURI);
                    }
                    ++i;
                }
            }
            return tu;
        }
        return null;
    }

    public static ITranslationUnit findTranslationUnitForLocation(IIndexFileLocation ifl, ICProject preferredProject) throws CModelException {
        String fullPath = ifl.getFullPath();
        if (fullPath != null) {
            IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath);
            if (file instanceof IFile) {
                return CoreModelUtil.findTranslationUnit((IFile)file);
            }
            return null;
        }
        IPath location = IndexLocationFactory.getAbsolutePath(ifl);
        if (location != null) {
            CoreModel coreModel = CoreModel.getDefault();
            ITranslationUnit tu = null;
            if (preferredProject != null) {
                tu = coreModel.createTranslationUnitFrom(preferredProject, location);
            }
            if (tu == null) {
                ICProject[] projects = coreModel.getCModel().getCProjects();
                int i = 0;
                while (i < projects.length && tu == null) {
                    ICProject project = projects[i];
                    if (!project.equals(preferredProject)) {
                        tu = coreModel.createTranslationUnitFrom(project, location);
                    }
                    ++i;
                }
            }
            return tu;
        }
        return null;
    }

    public static ITranslationUnit findTranslationUnit(IFile file) {
        ICProject cp;
        if (CoreModel.isTranslationUnit(file) && file.exists() && (cp = CoreModel.getDefault().getCModel().getCProject(file.getProject().getName())) != null) {
            try {
                ICElement tu = cp.findElement(file.getProjectRelativePath());
                if (tu instanceof ITranslationUnit) {
                    return (ITranslationUnit)tu;
                }
            }
            catch (CModelException e) {
                if (e.getStatus().getCode() == 979) {
                    return null;
                }
                CCorePlugin.log((Throwable)((Object)e));
            }
        }
        return null;
    }

    public static ICConfigurationDescription[] getReferencedConfigurationDescriptions(ICConfigurationDescription cfgDes, boolean writable) {
        Map<String, String> map;
        ArrayList<ICConfigurationDescription> result = new ArrayList<ICConfigurationDescription>();
        if (cfgDes != null && (map = cfgDes.getReferenceInfo()).size() != 0) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            CoreModel model = CoreModel.getDefault();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                ICConfigurationDescription refCfgDes;
                ICProjectDescription des;
                String projName = entry.getKey();
                String cfgId = entry.getValue();
                IProject project = root.getProject(projName);
                if (!project.exists() || (des = model.getProjectDescription(project, writable)) == null || (refCfgDes = cfgId != null && cfgId.length() > 0 ? des.getConfigurationById(cfgId) : des.getActiveConfiguration()) == null) continue;
                result.add(refCfgDes);
            }
        }
        return result.toArray(new ICConfigurationDescription[result.size()]);
    }

    public static ICConfigurationDescription[] getReferencingConfigurationDescriptions(ICConfigurationDescription cfgDes, boolean writable) {
        ArrayList<ICConfigurationDescription> result = new ArrayList<ICConfigurationDescription>();
        if (cfgDes != null) {
            IProject[] projects;
            CoreModel core = CoreModel.getDefault();
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject cproject = iProjectArray[n2];
                ICProjectDescription prjDes = core.getProjectDescription(cproject, writable);
                if (prjDes != null) {
                    ICConfigurationDescription[] cfgDscs;
                    ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDscs = prjDes.getConfigurations();
                    int n3 = cfgDscs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICConfigurationDescription[] references;
                        ICConfigurationDescription cfgDsc = iCConfigurationDescriptionArray[n4];
                        ICConfigurationDescription[] iCConfigurationDescriptionArray2 = references = CoreModelUtil.getReferencedConfigurationDescriptions(cfgDsc, false);
                        int n5 = references.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ICConfigurationDescription reference = iCConfigurationDescriptionArray2[n6];
                            if (reference != null && reference.getId().equals(cfgDes.getId())) {
                                result.add(cfgDsc);
                                break;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return result.toArray(new ICConfigurationDescription[result.size()]);
    }

    public static String[] getBinaryParserIds(ICConfigurationDescription[] cfgs) {
        if (cfgs == null || cfgs.length == 0) {
            return null;
        }
        ArrayList<String> pids = new ArrayList<String>();
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            ICTargetPlatformSetting tps = cfg.getTargetPlatformSetting();
            String[] ids = tps.getBinaryParserIds();
            int j = 0;
            while (j < ids.length) {
                if (!pids.contains(ids[j])) {
                    pids.add(ids[j]);
                }
                ++j;
            }
            ++n2;
        }
        return pids.toArray(new String[pids.size()]);
    }

    public static void setBinaryParserIds(ICConfigurationDescription[] cfgs, String[] pids) {
        if (cfgs == null || cfgs.length == 0) {
            return;
        }
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            cfg.getTargetPlatformSetting().setBinaryParserIds(pids);
            ++n2;
        }
    }
}

