/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTBinaryExpression
extends ASTNode
implements IASTBinaryExpression,
IASTAmbiguityParent {
    private int op;
    private IASTExpression operand1;
    private IASTExpression operand2;

    public CASTBinaryExpression() {
    }

    public CASTBinaryExpression(int op, IASTExpression operand1, IASTExpression operand2) {
        this.op = op;
        this.setOperand1(operand1);
        this.setOperand2(operand2);
    }

    public CASTBinaryExpression copy() {
        CASTBinaryExpression copy = new CASTBinaryExpression();
        copy.op = this.op;
        copy.setOperand1(this.operand1 == null ? null : this.operand1.copy());
        copy.setOperand2(this.operand2 == null ? null : this.operand2.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public int getOperator() {
        return this.op;
    }

    public IASTExpression getOperand1() {
        return this.operand1;
    }

    public IASTExpression getOperand2() {
        return this.operand2;
    }

    public void setOperator(int op) {
        this.assertNotFrozen();
        this.op = op;
    }

    public void setOperand1(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand1 = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_ONE);
        }
    }

    public void setOperand2(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand2 = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_TWO);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.operand1 != null && !this.operand1.accept(action)) {
            return false;
        }
        if (this.operand2 != null && !this.operand2.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand1) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand1 = (IASTExpression)other;
        }
        if (child == this.operand2) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand2 = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        int op = this.getOperator();
        try {
            switch (op) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 16: 
                case 28: 
                case 29: {
                    CBasicType basicType = new CBasicType(3, 0);
                    basicType.setValue(this);
                    return basicType;
                }
                case 4: {
                    IType t2 = this.getOperand2().getExpressionType();
                    if (CVisitor.unwrapTypedefs(t2) instanceof IPointerType) {
                        return t2;
                    }
                    break;
                }
                case 5: {
                    IType t2 = this.getOperand2().getExpressionType();
                    if (CVisitor.unwrapTypedefs(t2) instanceof IPointerType) {
                        IType t1 = this.getOperand1().getExpressionType();
                        if (CVisitor.unwrapTypedefs(t1) instanceof IPointerType) {
                            return CVisitor.getPtrDiffType(this);
                        }
                        return t1;
                    }
                    break;
                }
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return this.getOperand1().getExpressionType();
    }
}

