/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayModifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.Assert;

public class CPPASTNewExpression
extends ASTNode
implements ICPPASTNewExpression,
IASTAmbiguityParent {
    private boolean global;
    private IASTExpression placement;
    private IASTExpression initializer;
    private IASTTypeId typeId;
    private boolean isNewTypeId;
    private IASTExpression[] arrayExpressions = null;
    private IASTImplicitName[] implicitNames = null;

    public CPPASTNewExpression() {
    }

    public CPPASTNewExpression(IASTExpression placement, IASTExpression initializer, IASTTypeId typeId) {
        this.setNewPlacement(placement);
        this.setNewInitializer(initializer);
        this.setTypeId(typeId);
    }

    public CPPASTNewExpression copy() {
        CPPASTNewExpression copy = new CPPASTNewExpression();
        copy.setIsGlobal(this.global);
        copy.setIsNewTypeId(this.isNewTypeId);
        copy.setNewPlacement(this.placement == null ? null : this.placement.copy());
        copy.setNewInitializer(this.initializer == null ? null : this.initializer.copy());
        copy.setTypeId(this.typeId == null ? null : this.typeId.copy());
        if (this.arrayExpressions != null) {
            copy.arrayExpressions = new IASTExpression[this.arrayExpressions.length];
            int i = 0;
            while (i < this.arrayExpressions.length) {
                copy.arrayExpressions[i] = this.arrayExpressions[i] == null ? null : this.arrayExpressions[i].copy();
                ++i;
            }
        }
        copy.setOffsetAndLength(this);
        return copy;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setIsGlobal(boolean value) {
        this.assertNotFrozen();
        this.global = value;
    }

    public IASTExpression getNewPlacement() {
        return this.placement;
    }

    public void setNewPlacement(IASTExpression expression) {
        this.assertNotFrozen();
        this.placement = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NEW_PLACEMENT);
        }
    }

    public IASTExpression getNewInitializer() {
        return this.initializer;
    }

    public void setNewInitializer(IASTExpression expression) {
        this.assertNotFrozen();
        this.initializer = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NEW_INITIALIZER);
        }
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    public boolean isNewTypeId() {
        return this.isNewTypeId;
    }

    public void setIsNewTypeId(boolean value) {
        this.assertNotFrozen();
        this.isNewTypeId = value;
    }

    public IASTExpression[] getNewTypeIdArrayExpressions() {
        if (this.arrayExpressions == null) {
            IASTDeclarator dtor;
            if (this.typeId != null && (dtor = ASTQueries.findInnermostDeclarator(this.typeId.getAbstractDeclarator())) instanceof IASTArrayDeclarator) {
                IASTArrayDeclarator ad = (IASTArrayDeclarator)dtor;
                IASTArrayModifier[] ams = ad.getArrayModifiers();
                this.arrayExpressions = new IASTExpression[ams.length];
                int i = 0;
                while (i < ams.length) {
                    IASTArrayModifier am = ams[i];
                    this.arrayExpressions[i] = am.getConstantExpression();
                    ++i;
                }
                return this.arrayExpressions;
            }
            this.arrayExpressions = IASTExpression.EMPTY_EXPRESSION_ARRAY;
        }
        return this.arrayExpressions;
    }

    public void addNewTypeIdArrayExpression(IASTExpression expression) {
        this.assertNotFrozen();
        Assert.isNotNull((Object)this.typeId);
        IASTDeclarator dtor = ASTQueries.findInnermostDeclarator(this.typeId.getAbstractDeclarator());
        if (!(dtor instanceof IASTArrayDeclarator)) {
            IASTPointerOperator[] ptrOps;
            Assert.isNotNull((Object)dtor);
            Assert.isTrue((dtor.getParent() == this.typeId ? 1 : 0) != 0);
            CPPASTArrayDeclarator adtor = new CPPASTArrayDeclarator(dtor.getName());
            IASTPointerOperator[] iASTPointerOperatorArray = ptrOps = dtor.getPointerOperators();
            int n = ptrOps.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator ptr = iASTPointerOperatorArray[n2];
                adtor.addPointerOperator(ptr);
                ++n2;
            }
            this.typeId.setAbstractDeclarator(adtor);
            dtor = adtor;
        }
        CPPASTArrayModifier mod = new CPPASTArrayModifier(expression);
        ((ASTNode)mod).setOffsetAndLength((ASTNode)((Object)expression));
        ((IASTArrayDeclarator)dtor).addArrayModifier(mod);
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction operatorFunction = CPPSemantics.findOverloadedOperator(this);
            if (operatorFunction == null) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                CPPASTImplicitName operatorName = new CPPASTImplicitName(operatorFunction.getNameCharArray(), (IASTNode)this);
                operatorName.setOperator(true);
                operatorName.setBinding(operatorFunction);
                operatorName.setOffsetAndLength(this.getOffset(), 3);
                this.implicitNames = new IASTImplicitName[]{operatorName};
            }
        }
        return this.implicitNames;
    }

    public boolean isArrayAllocation() {
        IType t = CPPVisitor.createType(this.getTypeId());
        return t instanceof IArrayType;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (!name.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.placement != null && !this.placement.accept(action)) {
            return false;
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        if (this.initializer != null && !this.initializer.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.placement) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.placement = (IASTExpression)other;
        }
        if (child == this.initializer) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.initializer = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        IType t = CPPVisitor.createType(this.getTypeId());
        if (t instanceof IArrayType) {
            try {
                t = ((IArrayType)t).getType();
            }
            catch (DOMException e) {
                return e.getProblem();
            }
        }
        return new CPPPointerType(t);
    }
}

