/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;

public class CPPImplicitFunction
extends CPPFunction {
    private IParameter[] parms = null;
    private IScope scope = null;
    private ICPPFunctionType functionType = null;
    private boolean takesVarArgs = false;
    private char[] name = null;

    public CPPImplicitFunction(char[] name, IScope scope, ICPPFunctionType type, IParameter[] parms, boolean takesVarArgs) {
        super(null);
        this.name = name;
        this.scope = scope;
        this.functionType = type;
        this.parms = parms;
        this.takesVarArgs = takesVarArgs;
    }

    public IParameter[] getParameters() {
        return this.parms;
    }

    public ICPPFunctionType getType() {
        return this.functionType;
    }

    public String getName() {
        return String.valueOf(this.name);
    }

    public char[] getNameCharArray() {
        return this.name;
    }

    public IScope getScope() {
        return this.scope;
    }

    public IScope getFunctionScope() {
        return null;
    }

    public IBinding resolveParameter(IASTParameterDeclaration param) {
        IASTName aName = ASTQueries.findInnermostDeclarator(param.getDeclarator()).getName();
        IParameter binding = (IParameter)aName.getBinding();
        if (binding != null) {
            return binding;
        }
        ICPPASTFunctionDeclarator fdtor = (ICPPASTFunctionDeclarator)param.getParent();
        IASTParameterDeclaration[] ps = fdtor.getParameters();
        int i = 0;
        while (i < ps.length) {
            if (param == ps[i]) break;
            ++i;
        }
        binding = this.parms[i];
        IASTParameterDeclaration temp = null;
        if (this.definition != null) {
            temp = this.definition.getParameters()[i];
            IASTName n = ASTQueries.findInnermostDeclarator(temp.getDeclarator()).getName();
            n.setBinding(binding);
            ASTInternal.addDeclaration(binding, n);
        }
        if (this.declarations != null) {
            int j = 0;
            while (j < this.declarations.length && this.declarations[j] != null) {
                temp = this.declarations[j].getParameters()[i];
                IASTName n = ASTQueries.findInnermostDeclarator(temp.getDeclarator()).getName();
                n.setBinding(binding);
                ASTInternal.addDeclaration(binding, n);
                ++j;
            }
        }
        return binding;
    }

    protected void updateParameterBindings(ICPPASTFunctionDeclarator fdtor) {
        if (this.parms != null) {
            IASTParameterDeclaration[] nps = fdtor.getParameters();
            if (nps.length != this.parms.length) {
                return;
            }
            int i = 0;
            while (i < nps.length) {
                IASTName aName = ASTQueries.findInnermostDeclarator(nps[i].getDeclarator()).getName();
                IParameter param = this.parms[i];
                aName.setBinding(param);
                ASTInternal.addDeclaration(param, aName);
                ++i;
            }
        }
    }

    public boolean takesVarArgs() {
        return this.takesVarArgs;
    }

    public IBinding getOwner() {
        return null;
    }
}

