/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroReferenceName;
import org.eclipse.core.runtime.CoreException;

public class MacroExpansionHandler {
    private int lastMacroExpOffset;
    private final Scribe scribe;
    private IASTTranslationUnit tu;
    private Map<String, List<IIndexName>> macroExpansion = new TreeMap<String, List<IIndexName>>();

    public MacroExpansionHandler(Scribe scribe) {
        this.scribe = scribe;
    }

    protected boolean checkisMacroExpansionNode(IASTNode node) {
        return this.checkisMacroExpansionNode(node, true);
    }

    protected boolean isStatementWithMixedLocation(IASTStatement node) {
        if (node.getNodeLocations() != null && node.getNodeLocations().length > 1) {
            IASTNodeLocation[] iASTNodeLocationArray = node.getNodeLocations();
            int n = iASTNodeLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNodeLocation loc = iASTNodeLocationArray[n2];
                if (loc instanceof IASTMacroExpansionLocation) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean macroExpansionAlreadyPrinted(IASTNode node) {
        IASTMacroExpansionLocation macroNode;
        IASTNodeLocation[] locs = node.getNodeLocations();
        return locs.length == 1 && locs[0] instanceof IASTMacroExpansionLocation && (macroNode = (IASTMacroExpansionLocation)locs[0]).asFileLocation().getNodeOffset() == this.lastMacroExpOffset;
    }

    protected boolean checkisMacroExpansionNode(IASTNode node, boolean write) {
        IASTNodeLocation[] locs;
        IASTTranslationUnit unit = node.getTranslationUnit();
        if (this.tu == null || !this.tu.equals(unit)) {
            this.initEmptyMacros(unit);
        }
        if ((locs = node.getNodeLocations()) != null && locs.length == 1 && locs[0] instanceof IASTMacroExpansionLocation) {
            IASTMacroExpansionLocation macroNode = (IASTMacroExpansionLocation)locs[0];
            if (macroNode.asFileLocation().getNodeOffset() == this.lastMacroExpOffset) {
                return true;
            }
            if (write) {
                this.lastMacroExpOffset = macroNode.asFileLocation().getNodeOffset();
                this.scribe.print(node.getRawSignature());
            }
            return true;
        }
        this.handleEmptyMacroExpansion(node);
        return false;
    }

    private void handleEmptyMacroExpansion(IASTNode node) {
        IASTFileLocation fileLocation;
        if (node.getTranslationUnit() == null) {
            return;
        }
        String file = node.getContainingFilename();
        List<IIndexName> exps = this.macroExpansion.get(file);
        if (exps != null && !exps.isEmpty() && (fileLocation = node.getFileLocation()) != null) {
            int nOff = fileLocation.getNodeOffset();
            for (IIndexName iIndexName : exps) {
                if (!(iIndexName instanceof PDOMMacroReferenceName)) continue;
                PDOMMacroReferenceName mName = (PDOMMacroReferenceName)iIndexName;
                int eOff = mName.getFileLocation().getNodeOffset();
                int eLength = mName.getFileLocation().getNodeLength();
                if (eOff >= nOff || Math.abs(eOff + eLength - nOff) >= 3) continue;
                this.scribe.print(String.valueOf(mName.toString()) + " ");
            }
        }
    }

    private void initEmptyMacros(IASTTranslationUnit unit) {
        if (unit != null) {
            this.tu = unit;
            IIndex index = this.tu.getIndex();
            if (index != null) {
                this.macroExpansion = new TreeMap<String, List<IIndexName>>();
                IASTPreprocessorMacroDefinition[] md = this.tu.getMacroDefinitions();
                TreeSet<String> paths = new TreeSet<String>();
                IASTPreprocessorStatement[] iASTPreprocessorStatementArray = this.tu.getIncludeDirectives();
                int n = iASTPreprocessorStatementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTPreprocessorIncludeStatement is = iASTPreprocessorStatementArray[n2];
                    if (!is.isSystemInclude()) {
                        paths.add(is.getContainingFilename());
                    }
                    ++n2;
                }
                paths.add(this.tu.getContainingFilename());
                iASTPreprocessorStatementArray = md;
                n = md.length;
                n2 = 0;
                while (n2 < n) {
                    IASTPreprocessorStatement iastPreprocessorMacroDefinition = iASTPreprocessorStatementArray[n2];
                    if (iastPreprocessorMacroDefinition.getExpansion().length() == 0) {
                        try {
                            IIndexMacro[] macroBinding = index.findMacros(iastPreprocessorMacroDefinition.getName().toCharArray(), IndexFilter.ALL, null);
                            if (macroBinding.length > 0) {
                                IIndexName[] refs;
                                IIndexName[] iIndexNameArray = refs = index.findReferences(macroBinding[0]);
                                int n3 = refs.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IIndexName iIndexName = iIndexNameArray[n4];
                                    String filename2 = iIndexName.getFileLocation().getFileName();
                                    List<IIndexName> fileList = this.macroExpansion.get(filename2);
                                    if (paths.contains(filename2)) {
                                        if (fileList == null) {
                                            fileList = new ArrayList<IIndexName>();
                                            this.macroExpansion.put(filename2, fileList);
                                        }
                                        fileList.add(iIndexName);
                                    }
                                    ++n4;
                                }
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            } else {
                this.macroExpansion = Collections.emptyMap();
            }
        }
    }

    public void reset() {
        this.lastMacroExpOffset = -1;
    }
}

