/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    private final IWorkbenchPart fTargetPart;
    private final IVerticalRulerInfo fRulerInfo;

    public AbstractBreakpointRulerAction(IWorkbenchPart part, IVerticalRulerInfo info) {
        Assert.isTrue((part instanceof ITextEditor || part instanceof DisassemblyView ? 1 : 0) != 0);
        this.fTargetPart = part;
        this.fRulerInfo = info;
    }

    protected IBreakpoint getBreakpoint() {
        IAnnotationModel annotationModel = this.getAnnotationModel();
        IDocument document = this.getDocument();
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    Position position;
                    int line;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != this.fRulerInfo.getLineOfLastMouseButtonActivity() || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return null;
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRulerInfo;
    }

    private IDocument getDocument() {
        DisassemblyView dv;
        DisassemblyDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)targetPart;
            IDocumentProvider provider2 = textEditor.getDocumentProvider();
            if (provider2 != null) {
                return provider2.getDocument((Object)textEditor.getEditorInput());
            }
        } else if (targetPart instanceof DisassemblyView && (provider = (dv = (DisassemblyView)targetPart).getDocumentProvider()) != null) {
            return provider.getDocument(dv.getInput());
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel() {
        DisassemblyView dv;
        DisassemblyDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)targetPart;
            IDocumentProvider provider2 = textEditor.getDocumentProvider();
            if (provider2 != null) {
                return provider2.getAnnotationModel((Object)textEditor.getEditorInput());
            }
        } else if (targetPart instanceof DisassemblyView && (provider = (dv = (DisassemblyView)targetPart).getDocumentProvider()) != null) {
            return provider.getAnnotationModel(dv.getInput());
        }
        return null;
    }
}

