/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointActionDelegate;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointDialog;
import org.eclipse.cdt.debug.internal.ui.actions.BreakpointLocationVerifier;
import org.eclipse.cdt.debug.internal.ui.disassembly.editor.DisassemblyEditor;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualDocument;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentPresentation;
import org.eclipse.cdt.debug.ui.disassembly.IElementToggleBreakpointAdapter;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    /*
     * Enabled aggressive block sorting
     */
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        String errorMessage = null;
        if (part instanceof DisassemblyEditor && selection instanceof ITextSelection) {
            DisassemblyEditor editor = (DisassemblyEditor)part;
            int lineNumber = ((ITextSelection)selection).getStartLine();
            if (lineNumber == -1) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            IEditorInput input = editor.getEditorInput();
            if (input == null) throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            VirtualDocument document = (VirtualDocument)editor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Missing_document_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            IDocumentPresentation presentationContext = document.getPresentationContext();
            Object element = document.getElementAtLine(lineNumber);
            if (element == null) return;
            IElementToggleBreakpointAdapter adapter = this.getToggleBreakpointAdapter(element);
            if (adapter == null) return;
            adapter.toggleLineBreakpoints(presentationContext, element);
            return;
        }
        if (part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            IEditorInput input = textEditor.getEditorInput();
            if (input == null) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Missing_document_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            IResource resource = ToggleBreakpointAdapter.getResource((IWorkbenchPart)textEditor);
            if (resource == null) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Missing_resource_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            BreakpointLocationVerifier bv = new BreakpointLocationVerifier();
            int lineNumber = bv.getValidLineBreakpointLocation(document, ((ITextSelection)selection).getStartLine());
            if (lineNumber == -1) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            String sourceHandle = this.getSourceHandle(input);
            ICLineBreakpoint breakpoint = CDIDebugModel.lineBreakpointExists((String)sourceHandle, (IResource)resource, (int)lineNumber);
            if (breakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                return;
            }
            CDIDebugModel.createLineBreakpoint((String)sourceHandle, (IResource)resource, (int)0, (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
            return;
        }
        if (!(part instanceof DisassemblyView)) {
            errorMessage = ActionMessages.getString("RunToLineAdapter.Operation_is_not_supported_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IEditorInput input = ((DisassemblyView)part).getInput();
        if (!(input instanceof DisassemblyEditorInput)) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Empty_editor_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        BreakpointLocationVerifier bv = new BreakpointLocationVerifier();
        int lineNumber = bv.getValidAddressBreakpointLocation(null, ((ITextSelection)selection).getStartLine());
        if (lineNumber == -1) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IAddress address = ((DisassemblyEditorInput)input).getAddress(lineNumber);
        if (address == null) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        ICLineBreakpoint breakpoint = ((DisassemblyEditorInput)input).breakpointExists(address);
        if (breakpoint != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            return;
        }
        String module = ((DisassemblyEditorInput)input).getModuleFile();
        IResource resource = this.getAddressBreakpointResource(((DisassemblyEditorInput)input).getSourceFile());
        String sourceHandle = this.getSourceHandle(input);
        CDIDebugModel.createAddressBreakpoint((String)module, (String)sourceHandle, (IResource)resource, (int)0, (int)((DisassemblyEditorInput)input).getSourceLine(lineNumber), (IAddress)address, (boolean)true, (int)0, (String)"", (boolean)true);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (part instanceof DisassemblyView) {
            IEditorInput input = ((DisassemblyView)part).getInput();
            if (!(input instanceof DisassemblyEditorInput) || ((DisassemblyEditorInput)input).equals(DisassemblyEditorInput.EMPTY_EDITOR_INPUT)) {
                return false;
            }
        } else if (part instanceof DisassemblyEditor && selection instanceof ITextSelection) {
            VirtualDocument document;
            IEditorInput input;
            DisassemblyEditor editor = (DisassemblyEditor)part;
            int lineNumber = ((ITextSelection)selection).getStartLine();
            if (lineNumber != -1 && (input = editor.getEditorInput()) != null && (document = (VirtualDocument)editor.getDocumentProvider().getDocument((Object)input)) != null) {
                IElementToggleBreakpointAdapter adapter;
                IDocumentPresentation presentationContext = document.getPresentationContext();
                Object element = document.getElementAtLine(lineNumber);
                if (element != null && (adapter = this.getToggleBreakpointAdapter(element)) != null) {
                    return adapter.canToggleLineBreakpoints(presentationContext, element);
                }
            }
        }
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ICElement element = this.getCElementFromSelection(part, selection);
        if (element instanceof IFunction || element instanceof IMethod) {
            this.toggleMethodBreakpoints0((IDeclaration)element);
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        ICElement element = this.getCElementFromSelection(part, selection);
        return element instanceof IFunction || element instanceof IMethod;
    }

    protected ICElement getCElementFromSelection(IWorkbenchPart part, ISelection selection) {
        Object object;
        IStructuredSelection ss;
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            String text = textSelection.getText();
            if (text != null) {
                if (part instanceof ITextEditor) {
                    ICElement editorElement = CDTUITools.getEditorInputCElement((IEditorInput)((ITextEditor)part).getEditorInput());
                    if (editorElement instanceof ITranslationUnit) {
                        ITranslationUnit tu = (ITranslationUnit)editorElement;
                        try {
                            if (tu.isStructureKnown() && tu.isConsistent()) {
                                return tu.getElementAtOffset(textSelection.getOffset());
                            }
                        }
                        catch (CModelException cModelException) {}
                    }
                } else {
                    ITranslationUnit tu;
                    IResource resource = ToggleBreakpointAdapter.getResource(part);
                    if (resource instanceof IFile && (tu = this.getTranslationUnit((IFile)resource)) != null) {
                        try {
                            ICElement element = tu.getElement(text.trim());
                            if (element == null) {
                                element = tu.getElementAtLine(textSelection.getStartLine());
                            }
                            return element;
                        }
                        catch (CModelException cModelException) {}
                    }
                }
            }
        } else if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof ICElement) {
            return (ICElement)object;
        }
        return null;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IVariable variable = this.getVariableFromSelection(part, selection);
        if (variable != null) {
            this.toggleVariableWatchpoint(part, variable);
        }
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return this.getVariableFromSelection(part, selection) != null;
    }

    protected IVariable getVariableFromSelection(IWorkbenchPart part, ISelection selection) {
        ICElement element = this.getCElementFromSelection(part, selection);
        if (element instanceof IVariable) {
            return (IVariable)element;
        }
        return null;
    }

    protected void report(String message, IWorkbenchPart part) {
        IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            if (message != null) {
                statusLine.setMessage(true, message, null);
            } else {
                statusLine.setMessage(true, null, null);
            }
        }
        if (message != null && CDebugUIPlugin.getActiveWorkbenchShell() != null) {
            CDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    protected static IResource getResource(IWorkbenchPart part) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (part instanceof IEditorPart) {
            IFile[] files;
            IPath location;
            IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
            IFile resource = null;
            if (editorInput instanceof IFileEditorInput) {
                resource = ((IFileEditorInput)editorInput).getFile();
            } else if (editorInput instanceof ExternalEditorInput) {
                resource = ((ExternalEditorInput)editorInput).getMarkerResource();
            }
            if (resource != null) {
                return resource;
            }
            ILocationProvider provider = (ILocationProvider)editorInput.getAdapter(ILocationProvider.class);
            if (provider != null && (location = provider.getPath((Object)editorInput)) != null && (files = root.findFilesForLocation(location)).length > 0) {
                return files[0];
            }
        }
        return root;
    }

    private String getSourceHandle(IEditorInput input) throws CoreException {
        return CDebugUIUtils.getEditorFilePath(input);
    }

    private void toggleVariableWatchpoint(IWorkbenchPart part, IVariable variable) throws CoreException {
        String expression;
        IResource resource;
        String sourceHandle = this.getSourceHandle((IDeclaration)variable);
        ICWatchpoint watchpoint = CDIDebugModel.watchpointExists((String)sourceHandle, (IResource)(resource = this.getElementResource((IDeclaration)variable)), (String)(expression = this.getVariableName(variable)));
        if (watchpoint != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)watchpoint, true);
        } else {
            AddWatchpointDialog dlg = new AddWatchpointDialog(part.getSite().getShell(), AddWatchpointActionDelegate.getMemorySpaceManagement());
            dlg.setExpression(expression);
            if (dlg.open() != 0) {
                return;
            }
            expression = dlg.getExpression();
            int lineNumber = -1;
            int charStart = -1;
            int charEnd = -1;
            try {
                ISourceRange sourceRange = variable.getSourceRange();
                if (sourceRange != null) {
                    charStart = sourceRange.getStartPos();
                    charEnd = charStart + sourceRange.getLength();
                    if (charEnd <= 0) {
                        charStart = -1;
                        charEnd = -1;
                    }
                    lineNumber = sourceRange.getStartLine();
                }
            }
            catch (CModelException e) {
                DebugPlugin.log((Throwable)e);
            }
            CDIDebugModel.createWatchpoint((String)sourceHandle, (IResource)resource, (int)charStart, (int)charEnd, (int)lineNumber, (boolean)dlg.getWriteAccess(), (boolean)dlg.getReadAccess(), (String)expression, (String)dlg.getMemorySpace(), (BigInteger)dlg.getRange(), (boolean)true, (int)0, (String)"", (boolean)true);
        }
    }

    private String getSourceHandle(IDeclaration declaration) {
        IPath location;
        ITranslationUnit tu = declaration.getTranslationUnit();
        if (tu != null && (location = tu.getLocation()) != null) {
            return location.toOSString();
        }
        return "";
    }

    private IResource getElementResource(IDeclaration declaration) {
        return declaration.getUnderlyingResource();
    }

    private String getFunctionName(IFunction function) {
        String functionName = function.getElementName();
        StringBuffer name = new StringBuffer(functionName);
        ITranslationUnit tu = function.getTranslationUnit();
        if (tu != null && tu.isCXXLanguage()) {
            this.appendParameters(name, (IFunctionDeclaration)function);
        }
        return name.toString();
    }

    private String getMethodName(IMethod method) {
        StringBuffer name = new StringBuffer();
        String methodName = method.getElementName();
        ICElement parent = method.getParent();
        while (parent != null && (parent.getElementType() == 61 || parent.getElementType() == 65 || parent.getElementType() == 67 || parent.getElementType() == 69)) {
            name.append(parent.getElementName()).append("::");
            parent = parent.getParent();
        }
        name.append(methodName);
        this.appendParameters(name, (IFunctionDeclaration)method);
        return name.toString();
    }

    private void appendParameters(StringBuffer sb, IFunctionDeclaration fd) {
        String[] params = fd.getParameterTypes();
        sb.append('(');
        int i = 0;
        while (i < params.length) {
            sb.append(params[i]);
            if (i != params.length - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append(')');
    }

    private String getVariableName(IVariable variable) {
        return variable.getElementName();
    }

    private ITranslationUnit getTranslationUnit(IFile file) {
        ICElement element = CoreModel.getDefault().create(file);
        if (element instanceof ITranslationUnit) {
            return (ITranslationUnit)element;
        }
        return null;
    }

    private void toggleMethodBreakpoints0(IDeclaration declaration) throws CoreException {
        String functionName;
        IResource resource;
        String sourceHandle = this.getSourceHandle(declaration);
        ICFunctionBreakpoint breakpoint = CDIDebugModel.functionBreakpointExists((String)sourceHandle, (IResource)(resource = this.getElementResource(declaration)), (String)(functionName = declaration instanceof IFunction ? this.getFunctionName((IFunction)declaration) : this.getMethodName((IMethod)declaration)));
        if (breakpoint != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
        } else {
            int lineNumber = -1;
            int charStart = -1;
            int charEnd = -1;
            try {
                ISourceRange sourceRange = declaration.getSourceRange();
                if (sourceRange != null) {
                    charStart = sourceRange.getStartPos();
                    charEnd = charStart + sourceRange.getLength();
                    if (charEnd <= 0) {
                        charStart = -1;
                        charEnd = -1;
                    }
                    lineNumber = sourceRange.getStartLine();
                }
            }
            catch (CModelException e) {
                DebugPlugin.log((Throwable)e);
            }
            CDIDebugModel.createFunctionBreakpoint((String)sourceHandle, (IResource)resource, (int)0, (String)functionName, (int)charStart, (int)charEnd, (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
        }
    }

    private IResource getAddressBreakpointResource(String fileName) {
        IFile[] files;
        Path path;
        if (fileName != null && (path = new Path(fileName)).isValidPath(fileName) && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path)).length > 0) {
            return files[0];
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IElementToggleBreakpointAdapter getToggleBreakpointAdapter(Object element) {
        IElementToggleBreakpointAdapter adapter = null;
        if (element instanceof IElementToggleBreakpointAdapter) {
            adapter = (IElementToggleBreakpointAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapter = (IElementToggleBreakpointAdapter)adaptable.getAdapter(IElementToggleBreakpointAdapter.class);
        }
        return adapter;
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection) || this.canToggleWatchpoints(part, selection) || this.canToggleMethodBreakpoints(part, selection);
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (this.canToggleLineBreakpoints(part, selection)) {
            this.toggleLineBreakpoints(part, selection);
        } else {
            ICElement element = this.getCElementFromSelection(part, selection);
            if (element instanceof IFunction || element instanceof IMethod) {
                this.toggleMethodBreakpoints0((IDeclaration)element);
            } else if (element instanceof IVariable) {
                this.toggleVariableWatchpoint(part, (IVariable)element);
            }
        }
    }
}

