/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.executables;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.CSourceNotFoundEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.executables.BaseViewer;
import org.eclipse.cdt.debug.internal.ui.views.executables.ExecutablesView;
import org.eclipse.cdt.debug.internal.ui.views.executables.ExecutablesViewerComparator;
import org.eclipse.cdt.debug.internal.ui.views.executables.Messages;
import org.eclipse.cdt.debug.internal.ui.views.executables.SourceFilesContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.executables.SourceFilesLabelProvider;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;

public class SourceFilesViewer
extends BaseViewer
implements ISourceLookupParticipant {
    private static final String P_COLUMN_ORDER_KEY_SF = "columnOrderKeySF";
    private static final String P_SORTED_COLUMN_INDEX_KEY_SF = "sortedColumnIndexKeySF";
    private static final String P_COLUMN_SORT_DIRECTION_KEY_SF = "columnSortDirectionKeySF";
    private static final String P_VISIBLE_COLUMNS_KEY_SF = "visibleColumnsKeySF";
    TreeColumn originalLocationColumn;
    private Tree sourceFilesTree;

    public SourceFilesViewer(ExecutablesView view, Composite parent, int style) {
        super(view, parent, style);
        this.setContentProvider((IContentProvider)new SourceFilesContentProvider(this));
        this.setLabelProvider((IBaseLabelProvider)new SourceFilesLabelProvider(this));
        this.sourceFilesTree = this.getTree();
        this.sourceFilesTree.setHeaderVisible(true);
        this.sourceFilesTree.setLinesVisible(true);
        this.createColumns();
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SourceFilesViewer.this.openSourceFile(event);
            }
        });
        CDebugCorePlugin.getDefault().getCommonSourceLookupDirector().addParticipants(new ISourceLookupParticipant[]{this});
        this.sourceFilesTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CDebugCorePlugin.getDefault().getCommonSourceLookupDirector().removeParticipants(new ISourceLookupParticipant[]{SourceFilesViewer.this});
            }
        });
    }

    private void openSourceFile(OpenEvent event) {
        boolean opened = false;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof ICElement) {
            IWorkbenchPage p;
            ITranslationUnit tu;
            IPath path;
            if (element instanceof ITranslationUnit && (path = (tu = (ITranslationUnit)element).getLocation()) != null && !path.toFile().exists() && (p = CUIPlugin.getActivePage()) != null) {
                try {
                    String editorID = ICDebugUIConstants.CSOURCENOTFOUND_EDITOR_ID;
                    p.openEditor((IEditorInput)new CSourceNotFoundEditorInput(tu), editorID, true);
                    opened = true;
                }
                catch (PartInitException partInitException) {}
            }
            if (!opened) {
                try {
                    IEditorPart part = EditorUtility.openInEditor((Object)element);
                    if (part != null) {
                        IWorkbenchPage page = this.getExecutablesView().getSite().getPage();
                        page.bringToTop((IWorkbenchPart)part);
                        if (element instanceof ISourceReference) {
                            EditorUtility.revealInEditor((IEditorPart)part, (ICElement)((ICElement)element));
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void createColumns() {
        this.nameColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.nameColumn.setWidth(100);
        this.nameColumn.setText(Messages.SourceFilesViewer_SourceFileName);
        this.nameColumn.setMoveable(true);
        this.nameColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(0));
        this.locationColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.locationColumn.setWidth(100);
        this.locationColumn.setText(Messages.SourceFilesViewer_Location);
        this.locationColumn.setMoveable(true);
        this.locationColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(2));
        this.originalLocationColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.originalLocationColumn.setWidth(100);
        this.originalLocationColumn.setText(Messages.SourceFilesViewer_Original);
        this.originalLocationColumn.setMoveable(true);
        this.originalLocationColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(6));
        this.sizeColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.sizeColumn.setWidth(100);
        this.sizeColumn.setText(Messages.SourceFilesViewer_Size);
        this.sizeColumn.setMoveable(true);
        this.sizeColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(3));
        this.modifiedColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.modifiedColumn.setWidth(100);
        this.modifiedColumn.setText(Messages.SourceFilesViewer_Modified);
        this.modifiedColumn.setMoveable(true);
        this.modifiedColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(4));
        this.typeColumn = new TreeColumn(this.sourceFilesTree, 0);
        this.typeColumn.setWidth(100);
        this.typeColumn.setText(Messages.SourceFilesViewer_Type);
        this.typeColumn.setMoveable(true);
        this.typeColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(5));
    }

    protected ViewerComparator getViewerComparator(int sortType) {
        if (sortType == 6) {
            return new ExecutablesViewerComparator(sortType, this.column_sort_order[6]){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    if (e1 instanceof ITranslationUnit && e2 instanceof ITranslationUnit) {
                        ITranslationUnit entry1 = (ITranslationUnit)e1;
                        ITranslationUnit entry2 = (ITranslationUnit)e2;
                        Executable exe = (Executable)SourceFilesViewer.this.getInput();
                        String originalLocation1 = exe.getOriginalLocation(entry1);
                        String originalLocation2 = exe.getOriginalLocation(entry2);
                        return this.getComparator().compare(originalLocation1, originalLocation2) * SourceFilesViewer.this.column_sort_order[6];
                    }
                    return super.compare(viewer, e1, e2);
                }
            };
        }
        return new ExecutablesViewerComparator(sortType, this.column_sort_order[sortType]);
    }

    public void dispose() {
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        return new Object[0];
    }

    public String getSourceName(Object object) throws CoreException {
        return "";
    }

    public void init(ISourceLookupDirector director) {
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        UIJob refreshJob = new UIJob(Messages.SourceFilesViewer_RefreshSourceFiles){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object input = SourceFilesViewer.this.getInput();
                if (input != null && input instanceof Executable) {
                    ((Executable)input).setRefreshSourceFiles(true);
                    SourceFilesViewer.this.refresh(true);
                }
                return Status.OK_STATUS;
            }
        };
        refreshJob.schedule();
    }

    protected String getColumnOrderKey() {
        return P_COLUMN_ORDER_KEY_SF;
    }

    protected String getSortedColumnIndexKey() {
        return P_SORTED_COLUMN_INDEX_KEY_SF;
    }

    protected String getSortedColumnDirectionKey() {
        return P_COLUMN_SORT_DIRECTION_KEY_SF;
    }

    protected String getVisibleColumnsKey() {
        return P_VISIBLE_COLUMNS_KEY_SF;
    }

    protected String getDefaultVisibleColumnsValue() {
        return "1,1,0,0,0,0";
    }
}

