/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSteppingModeTarget;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

@Immutable
public abstract class GdbAbstractReverseStepCommand {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final DsfSteppingModeTarget fSteppingMode;

    protected DsfSteppingModeTarget getSteppingMode() {
        return this.fSteppingMode;
    }

    public GdbAbstractReverseStepCommand(DsfSession session, DsfSteppingModeTarget steppingMode) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
        this.fSteppingMode = steppingMode;
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    protected boolean canReverseStep(ISelection debugContext) {
        final IRunControl.IExecutionDMContext dmc = this.getContext(debugContext);
        if (dmc == null) {
            return false;
        }
        final IRunControl.StepType stepType = this.getStepType();
        Query<Boolean> canReverseQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbAbstractReverseStepCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.canReverseStep(dmc, stepType, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canReverseQuery);
            return (Boolean)canReverseQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        return false;
    }

    protected void reverseStep(ISelection debugContext) {
        final IRunControl.IExecutionDMContext dmc = this.getContext(debugContext);
        if (dmc == null) {
            return;
        }
        final IRunControl.StepType stepType = this.getStepType();
        Query<Object> reverseStepQuery = new Query<Object>(){

            public void execute(DataRequestMonitor<Object> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbAbstractReverseStepCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.reverseStep(dmc, stepType, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)reverseStepQuery);
            reverseStepQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    private IRunControl.IExecutionDMContext getContext(ISelection debugContext) {
        Object object;
        IStructuredSelection ss;
        if (debugContext instanceof IStructuredSelection && !(ss = (IStructuredSelection)debugContext).isEmpty() && (object = ss.getFirstElement()) instanceof IDMVMContext) {
            return (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)object).getDMContext(), IRunControl.IExecutionDMContext.class);
        }
        return null;
    }

    abstract IRunControl.StepType getStepType();
}

