/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model;

import java.math.BigInteger;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.Addr2Line;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.SourceDocumentProvider;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.SourceEditorInput;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.SourceReadingJob;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.presentation.ISourcePresentationCreator;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.presentation.SourcePresentationCreatorFactory;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;

public class SourceFileInfo {
    public final String fFileKey;
    public final IStorage fFile;
    public IStorage fEdition;
    public BigInteger[] fLine2Addr;
    public Addr2Line[] fAddr2Line;
    public volatile IDocument fSource;
    public volatile boolean fValid;
    public Object fLinesNode;
    public Throwable fError;
    public volatile SourceReadingJob fReadingJob;
    public volatile Job fEditionJob;
    public ISourcePresentationCreator fPresentationCreator;
    public BigInteger fStartAddress = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    public BigInteger fEndAddress = BigInteger.ZERO;

    public SourceFileInfo(String fileKey, IStorage file) {
        this.fFileKey = fileKey;
        this.fFile = this.fEdition = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSource() throws CoreException {
        SourceDocumentProvider provider = DsfUIPlugin.getSourceDocumentProvider();
        SourceEditorInput input = new SourceEditorInput(this.fEdition);
        SourceDocumentProvider sourceDocumentProvider = provider;
        synchronized (sourceDocumentProvider) {
            provider.connect(input);
        }
        IStatus status = provider.getStatus(input);
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
    }

    public void initPresentationCreator(ITextViewer viewer) {
        SourceEditorInput input;
        SourceDocumentProvider provider = DsfUIPlugin.getSourceDocumentProvider();
        IDocument doc = provider.getDocument(input = new SourceEditorInput(this.fEdition));
        if (doc != null) {
            IContentType contentType = null;
            if (this.fEdition instanceof IFile) {
                IFile file = (IFile)this.fEdition;
                contentType = CCorePlugin.getContentType((IProject)file.getProject(), (String)file.getName());
            } else {
                contentType = CCorePlugin.getContentType((String)this.fEdition.getName());
            }
            ILanguage language = null;
            if (contentType != null) {
                language = LanguageManager.getInstance().getLanguage(contentType);
            }
            if (language != null) {
                this.fPresentationCreator = SourcePresentationCreatorFactory.create(language, this.fEdition, viewer);
            }
            int lines = doc.getNumberOfLines();
            this.fLine2Addr = new BigInteger[lines];
            this.fAddr2Line = new Addr2Line[lines / 10 + 1];
            this.fSource = doc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SourceDocumentProvider provider;
        if (this.fReadingJob != null) {
            if (!this.fReadingJob.cancel()) {
                this.fReadingJob.dispose();
            }
            this.fReadingJob = null;
        }
        if (this.fPresentationCreator != null) {
            this.fPresentationCreator.dispose();
            this.fPresentationCreator = null;
        }
        SourceDocumentProvider sourceDocumentProvider = provider = DsfUIPlugin.getSourceDocumentProvider();
        synchronized (sourceDocumentProvider) {
            provider.disconnect(new SourceEditorInput(this.fEdition));
        }
        this.fSource = null;
        this.fValid = false;
    }

    public String getLine(int lineNr) {
        return this.getLines(lineNr, lineNr);
    }

    public String getLines(int first, int last) {
        try {
            int endOffset;
            int startOffset = this.fSource.getLineOffset(first);
            if (last < this.fSource.getNumberOfLines() - 1) {
                IRegion lastRegion = this.fSource.getLineInformation(last + 1);
                endOffset = lastRegion.getOffset();
            } else {
                IRegion lastRegion = this.fSource.getLineInformation(last);
                endOffset = lastRegion.getOffset() + lastRegion.getLength();
            }
            return this.fSource.get(startOffset, endOffset - startOffset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public IRegion getRegion(int line, int length) {
        try {
            IRegion lineRegion = this.fSource.getLineInformation(line);
            return new Region(lineRegion.getOffset(), length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public TextPresentation getPresentation(IRegion region) {
        if (this.fSource != null && this.fPresentationCreator != null) {
            return this.fPresentationCreator.getPresentation(region, this.fSource);
        }
        return null;
    }

    public int getLineOffset(int line) {
        if (this.fSource != null) {
            try {
                return this.fSource.getLineOffset(line);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }
}

