/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.numberformat.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.detailsupport.DetailPaneMaxLengthAction;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.detailsupport.DetailPaneWordWrapAction;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.detailsupport.MessagesForDetailPane;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.detailsupport.TextViewerAction;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.numberformat.detail.MessagesForNumberFormatDetailPane;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueVMUtil;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.ui.concurrent.SimpleDisplayExecutor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.VMPropertiesUpdate;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.IDetailPane2;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.IUpdate;

public class NumberFormatDetailPane
implements IDetailPane2,
IAdaptable,
IPropertyChangeListener {
    private IWorkbenchPartSite fWorkbenchPartSite;
    private Map<String, IAction> fActionMap = new HashMap<String, IAction>();
    private List<String> fSelectionActions = new ArrayList<String>();
    protected static final String DETAIL_COPY_ACTION = String.valueOf(ActionFactory.COPY.getId()) + ".TextDetailPane";
    protected static final String DETAIL_SELECT_ALL_ACTION = String.valueOf(IDebugView.SELECT_ALL_ACTION) + ".TextDetailPane";
    protected static final String DETAIL_WORD_WRAP_ACTION = "org.eclipse.cdt.dsf.ui.detail_pane_word_wrap";
    protected static final String DETAIL_MAX_LENGTH_ACTION = "MaxLength";
    public static final String ID = "NumberFormatPane";
    public static String FORMAT_SEPARATOR = MessagesForNumberFormatDetailPane.NumberFormatDetailPane_format_separator__label;
    public static String NAME = MessagesForNumberFormatDetailPane.NumberFormatDetailPane_Name_label;
    public static String SPACES = MessagesForNumberFormatDetailPane.NumberFormatDetailPane_Spaces_label;
    public static String CRLF = MessagesForNumberFormatDetailPane.NumberFormatDetailPane_CarriageReturn_label;
    public static String DOTS = MessagesForNumberFormatDetailPane.NumberFormatDetailPane_DotDotDot_label;
    private String fDebugModelIdentifier;
    private TextViewer fTextViewer;
    private IStructuredSelection fLastDisplayed = null;
    private IDocument fDetailDocument;
    private DetailJob fDetailJob = null;

    public void init(IWorkbenchPartSite workbench) {
        this.fWorkbenchPartSite = workbench;
    }

    protected void setAction(String actionID, IAction action) {
        if (action == null) {
            this.fActionMap.remove(actionID);
        } else {
            this.fActionMap.put(actionID, action);
        }
    }

    protected void setGlobalAction(String actionID, IAction action) {
        this.getViewSite().getActionBars().setGlobalActionHandler(actionID, action);
    }

    protected void setSelectionDependantAction(String actionID) {
        if (actionID != null) {
            this.fSelectionActions.add(actionID);
        }
    }

    protected IAction getAction(String actionID) {
        return this.fActionMap.get(actionID);
    }

    protected void updateAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void updateSelectionDependentActions() {
        Iterator<String> iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction(iterator.next());
        }
    }

    protected IViewSite getViewSite() {
        if (this.fWorkbenchPartSite == null) {
            return null;
        }
        return (IViewSite)this.fWorkbenchPartSite.getPart().getSite();
    }

    protected IWorkbenchPartSite getWorkbenchPartSite() {
        return this.fWorkbenchPartSite;
    }

    protected boolean isInView() {
        return this.fWorkbenchPartSite != null;
    }

    public Control createControl(Composite parent) {
        this.createTextViewer(parent);
        if (this.isInView()) {
            this.createViewSpecificComponents();
            this.createActions();
            DsfUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        }
        return this.fTextViewer.getControl();
    }

    private void createTextViewer(Composite parent) {
        this.fTextViewer = new TextViewer(parent, 768);
        this.fTextViewer.setDocument(this.getDetailDocument());
        this.fTextViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        this.fTextViewer.getTextWidget().setWordWrap(DsfUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
        this.fTextViewer.setEditable(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fTextViewer.getTextWidget(), "org.eclipse.debug.ui.detail_pane_context");
        Control control = this.fTextViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
    }

    private void createViewSpecificComponents() {
        this.getDetailDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                NumberFormatDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fTextViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NumberFormatDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fTextViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NumberFormatDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, NumberFormatDetailPane.this.getAction(DETAIL_SELECT_ALL_ACTION));
                NumberFormatDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, NumberFormatDetailPane.this.getAction(DETAIL_COPY_ACTION));
                NumberFormatDetailPane.this.getViewSite().getActionBars().updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                NumberFormatDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, null);
                NumberFormatDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, null);
                NumberFormatDetailPane.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        this.createDetailContextMenu((Control)this.fTextViewer.getTextWidget());
    }

    private void createActions() {
        TextViewerAction textAction = new TextViewerAction((ITextViewer)this.fTextViewer, 7);
        textAction.configureAction(MessagesForDetailPane.DetailPane_Select_All, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_select_all_action_context");
        this.setAction(DETAIL_SELECT_ALL_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.fTextViewer, 4);
        textAction.configureAction(MessagesForDetailPane.DetailPane_Copy, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_copy_action_context");
        this.setAction(DETAIL_COPY_ACTION, (IAction)textAction);
        this.setSelectionDependantAction(DETAIL_COPY_ACTION);
        this.updateSelectionDependentActions();
        Action action = new DetailPaneWordWrapAction((ITextViewer)this.fTextViewer);
        this.setAction(DETAIL_WORD_WRAP_ACTION, (IAction)action);
        action = new DetailPaneMaxLengthAction(this.fTextViewer.getControl().getShell());
        this.setAction(DETAIL_MAX_LENGTH_ACTION, (IAction)action);
    }

    protected void createDetailContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                NumberFormatDetailPane.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getViewSite().registerContextMenu("org.eclipse.debug.ui.VariableView.detail", menuMgr, this.fTextViewer.getSelectionProvider());
    }

    protected void fillDetailContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(DETAIL_COPY_ACTION));
        menu.add(this.getAction(DETAIL_SELECT_ALL_ACTION));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(DETAIL_WORD_WRAP_ACTION));
        menu.add(this.getAction(DETAIL_MAX_LENGTH_ACTION));
        menu.add((IContributionItem)new Separator("additions"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(IStructuredSelection selection) {
        String[] ids;
        IDebugModelProvider debugModelProvider;
        if (selection == null) {
            this.clearTextViewer();
            return;
        }
        this.fLastDisplayed = selection;
        if (selection.isEmpty() || !(selection instanceof ITreeSelection)) {
            this.clearTextViewer();
            return;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IAdaptable && (debugModelProvider = (IDebugModelProvider)((IAdaptable)firstElement).getAdapter(IDebugModelProvider.class)) != null && (ids = debugModelProvider.getModelIdentifiers()) != null && ids.length > 0) {
            this.setDebugModel(ids[0]);
        }
        NumberFormatDetailPane numberFormatDetailPane = this;
        synchronized (numberFormatDetailPane) {
            IVMNode vmNode;
            if (this.fDetailJob != null) {
                this.fDetailJob.cancel();
            }
            if (this.fWorkbenchPartSite != null) {
                Viewer viewer;
                Object input;
                IWorkbenchPart part = this.fWorkbenchPartSite.getPart();
                if (part instanceof IDebugView && (input = (viewer = ((IDebugView)part).getViewer()).getInput()) != null && viewer instanceof TreeModelViewer) {
                    TreeModelViewer treeModelViewer = (TreeModelViewer)viewer;
                    this.fDetailJob = new DetailJob(treeModelViewer.getPresentationContext(), input, (ITreeSelection)selection, null);
                    this.fDetailJob.schedule();
                }
            } else if (firstElement instanceof IDMVMContext && (vmNode = ((IDMVMContext)firstElement).getVMNode()) != null) {
                IVMProvider vmProvider = vmNode.getVMProvider();
                this.fDetailJob = new DetailJob(vmProvider.getPresentationContext(), firstElement, (ITreeSelection)selection, null);
                this.fDetailJob.schedule();
            }
        }
    }

    public boolean setFocus() {
        if (this.fTextViewer != null) {
            this.fTextViewer.getTextWidget().setFocus();
            return true;
        }
        return false;
    }

    public void dispose() {
        this.fActionMap.clear();
        this.fSelectionActions.clear();
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        this.fDebugModelIdentifier = null;
        if (this.fTextViewer != null && this.fTextViewer.getControl() != null) {
            this.fTextViewer.getControl().dispose();
            this.fTextViewer = null;
        }
        if (this.isInView()) {
            DsfUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public String getDescription() {
        return MessagesForDetailPane.NumberFormatDetailPane_Description;
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return MessagesForDetailPane.NumberFormatDetailPane_Name;
    }

    public Object getAdapter(Class required) {
        if (IFindReplaceTarget.class.equals((Object)required)) {
            return this.fTextViewer.getFindReplaceTarget();
        }
        if (ITextViewer.class.equals((Object)required)) {
            return this.fTextViewer;
        }
        return null;
    }

    protected IDocument getDetailDocument() {
        if (this.fDetailDocument == null) {
            this.fDetailDocument = new Document();
        }
        return this.fDetailDocument;
    }

    protected void clearTextViewer() {
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        this.fLastDisplayed = null;
        this.fDetailDocument.set("");
        this.fTextViewer.setEditable(false);
    }

    protected void configureDetailsViewer() {
        this.fTextViewer.setEditable(false);
    }

    protected String getDebugModel() {
        return this.fDebugModelIdentifier;
    }

    protected void setDebugModel(String id) {
        if (id != this.fDebugModelIdentifier) {
            this.fDebugModelIdentifier = id;
            this.configureDetailsViewer();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("org.eclipse.debug.ui.DetailPaneFont")) {
            this.fTextViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        } else if (propertyName.equals("org.eclipse.debug.ui.max_detail_length")) {
            this.display(this.fLastDisplayed);
        } else if (propertyName.equals(DETAIL_WORD_WRAP_ACTION)) {
            this.fTextViewer.getTextWidget().setWordWrap(DsfUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
            this.getAction(DETAIL_WORD_WRAP_ACTION).setChecked(DsfUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
        }
    }

    public ISelectionProvider getSelectionProvider() {
        if (this.fTextViewer != null) {
            return this.fTextViewer.getSelectionProvider();
        }
        return null;
    }

    class DetailJob
    extends Job
    implements IValueDetailListener {
        private IPresentationContext fPresentationContext;
        private Object fViewerInput;
        private ITreeSelection fElements;
        private boolean fFirst;
        private IProgressMonitor fMonitor;

        public DetailJob(IPresentationContext context, Object viewerInput, ITreeSelection elements, IDebugModelPresentation model) {
            super("compute variable details");
            this.fFirst = true;
            this.setSystem(true);
            this.fPresentationContext = context;
            this.fViewerInput = viewerInput;
            this.fElements = elements;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.fMonitor != null && !this.fMonitor.isCanceled()) {
                this.fMonitor.setCanceled(true);
            }
            this.fMonitor = monitor;
            TreePath[] paths = this.fElements.getPaths();
            int i = 0;
            while (i < paths.length) {
                if (monitor.isCanceled()) break;
                final TreePath path = paths[i];
                Object element = paths[i].getLastSegment();
                final IElementPropertiesProvider propertiesProvider = (IElementPropertiesProvider)DebugPlugin.getAdapter((Object)element, IElementPropertiesProvider.class);
                Display display = NumberFormatDetailPane.this.fWorkbenchPartSite != null ? NumberFormatDetailPane.this.fWorkbenchPartSite.getShell().getDisplay() : PlatformUI.getWorkbench().getDisplay();
                final SimpleDisplayExecutor executor = SimpleDisplayExecutor.getSimpleDisplayExecutor(display);
                HashSet<String> properties = new HashSet<String>(1);
                properties.add("formatted_value_available_formats");
                propertiesProvider.update(new IPropertiesUpdate[]{new VMPropertiesUpdate(properties, path, this.fViewerInput, this.fPresentationContext, new DataRequestMonitor<Map<String, Object>>((Executor)executor, null){

                    protected void handleCompleted() {
                        HashSet<String> properties = new HashSet<String>(1);
                        properties.add("name");
                        final String[] formats = (String[])((Map)this.getData()).get("formatted_value_available_formats");
                        if (formats != null) {
                            String[] stringArray = formats;
                            int n = formats.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String format = stringArray[n2];
                                properties.add(FormattedValueVMUtil.getPropertyForFormatId(format));
                                ++n2;
                            }
                        }
                        propertiesProvider.update(new IPropertiesUpdate[]{new VMPropertiesUpdate(properties, path, DetailJob.this.fViewerInput, DetailJob.this.fPresentationContext, new DataRequestMonitor<Map<String, Object>>(executor, null){

                            protected void handleSuccess() {
                                StringBuffer finalResult = new StringBuffer();
                                finalResult.append(NAME).append(((Map)this.getData()).get("name")).append(CRLF);
                                ArrayList<String> formatsList = new ArrayList<String>(Arrays.asList(formats));
                                Collections.sort(formatsList);
                                int i = 0;
                                while (i < formatsList.size()) {
                                    String formatId = (String)formatsList.get(i);
                                    finalResult.append(SPACES);
                                    finalResult.append(FormattedValueVMUtil.getFormatLabel(formatId));
                                    finalResult.append(FORMAT_SEPARATOR);
                                    finalResult.append(((Map)this.getData()).get(FormattedValueVMUtil.getPropertyForFormatId(formatId)));
                                    if (i < formatsList.size() + 1) {
                                        finalResult.append(CRLF);
                                    }
                                    ++i;
                                }
                                DetailJob.this.detailComputed(null, finalResult.toString());
                            }

                            protected void handleErrorOrWarning() {
                                DetailJob.this.detailComputed(null, this.getStatus().getMessage());
                            }
                        })});
                    }
                })});
                ++i;
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void canceling() {
            super.canceling();
            DetailJob detailJob = this;
            synchronized (detailJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void detailComputed(IValue value, final String result) {
            DetailJob detailJob = this;
            // MONITORENTER : detailJob
            // MONITOREXIT : detailJob
            if (!this.fMonitor.isCanceled()) {
                WorkbenchJob append = new WorkbenchJob("append details"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!DetailJob.this.fMonitor.isCanceled()) {
                            String insert = result;
                            int length = 0;
                            if (!DetailJob.this.fFirst) {
                                length = NumberFormatDetailPane.this.getDetailDocument().getLength();
                            }
                            if (length > 0) {
                                insert = String.valueOf(CRLF) + result;
                            }
                            try {
                                int max = DsfUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.debug.ui.max_detail_length");
                                if (max > 0 && insert.length() > max) {
                                    insert = String.valueOf(insert.substring(0, max)) + DOTS;
                                }
                                if (DetailJob.this.fFirst) {
                                    NumberFormatDetailPane.this.getDetailDocument().set(insert);
                                    DetailJob.this.fFirst = false;
                                } else {
                                    NumberFormatDetailPane.this.getDetailDocument().replace(length, 0, insert);
                                }
                            }
                            catch (BadLocationException e) {
                                DsfUIPlugin.log(e);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                append.setSystem(true);
                append.schedule();
            }
            DetailJob detailJob2 = this;
            // MONITORENTER : detailJob2
            ((Object)((Object)this)).notifyAll();
            // MONITOREXIT : detailJob2
            return;
        }
    }
}

