/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel.update;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IElementUpdateTester;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.cdt.dsf.ui.viewmodel.update.UserEditEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ViewModelUpdateMessages;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualUpdatePolicy
implements IVMUpdatePolicy {
    public static String MANUAL_UPDATE_POLICY_ID = "org.eclipse.cdt.dsf.ui.viewmodel.update.manualUpdatePolicy";
    public static Object REFRESH_EVENT = new Object();
    private static IElementUpdateTester fgUpdateTester = new IElementUpdateTester(){

        public int getUpdateFlags(Object viewerInput, TreePath path) {
            return 4;
        }

        public boolean includes(IElementUpdateTester tester) {
            return tester.equals(this);
        }

        public String toString() {
            return "Manual (refresh = false) update tester";
        }
    };
    private static IElementUpdateTester fgRefreshUpdateTester = new IElementUpdateTester(){

        public int getUpdateFlags(Object viewerInput, TreePath path) {
            return 3;
        }

        public boolean includes(IElementUpdateTester tester) {
            return tester.equals(this) || tester.equals(fgUpdateTester) || tester instanceof UserEditEventUpdateTester;
        }

        public String toString() {
            return "Manual (refresh = true) update tester";
        }
    };

    @Override
    public String getID() {
        return MANUAL_UPDATE_POLICY_ID;
    }

    @Override
    public String getName() {
        return ViewModelUpdateMessages.ManualUpdatePolicy_name;
    }

    @Override
    public IElementUpdateTester getElementUpdateTester(Object event) {
        if (event.equals(REFRESH_EVENT)) {
            return fgRefreshUpdateTester;
        }
        if (event instanceof UserEditEvent) {
            return new UserEditEventUpdateTester(((UserEditEvent)event).getElements());
        }
        return fgUpdateTester;
    }

    @Override
    public Object[] getInitialRootElementChildren(Object rootElement) {
        return new Object[]{new BlankDataElement()};
    }

    @Override
    public Map<String, Object> getInitialRootElementProperties(Object rootElement) {
        return Collections.emptyMap();
    }

    private static class BlankDataElement
    implements IElementContentProvider,
    IElementLabelProvider {
        private BlankDataElement() {
        }

        public void update(IHasChildrenUpdate[] updates) {
            IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
                update.setHasChilren(false);
                update.done();
                ++n2;
            }
        }

        public void update(IChildrenCountUpdate[] updates) {
            IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
                update.setChildCount(0);
                update.done();
                ++n2;
            }
        }

        public void update(IChildrenUpdate[] updates) {
            IChildrenUpdate[] iChildrenUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IChildrenUpdate update = iChildrenUpdateArray[n2];
                update.done();
                ++n2;
            }
        }

        public void update(ILabelUpdate[] updates) {
            RGB staleDataForeground = JFaceResources.getColorRegistry().getRGB("org.eclipse.cdt.dsf.ui.staledata.foreground");
            RGB staleDataBackground = JFaceResources.getColorRegistry().getRGB("org.eclipse.cdt.dsf.ui.staledata.background");
            ILabelUpdate[] iLabelUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                ILabelUpdate update = iLabelUpdateArray[n2];
                update.setLabel(ViewModelUpdateMessages.ManualUpdatePolicy_InitialDataElement__label, 0);
                if (update.getColumnIds() != null) {
                    update.setForeground(staleDataForeground, 0);
                } else {
                    update.setBackground(staleDataBackground, 0);
                }
                update.done();
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserEditEventUpdateTester
    implements IElementUpdateTester {
        private final Set<Object> fElements;

        public UserEditEventUpdateTester(Set<Object> elements) {
            this.fElements = elements;
        }

        @Override
        public int getUpdateFlags(Object viewerInput, TreePath path) {
            if (this.fElements.contains(viewerInput)) {
                return 1;
            }
            int i = 0;
            while (i < path.getSegmentCount()) {
                if (this.fElements.contains(path.getSegment(i))) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }

        @Override
        public boolean includes(IElementUpdateTester tester) {
            return tester instanceof UserEditEventUpdateTester && this.fElements.equals(((UserEditEventUpdateTester)tester).fElements);
        }

        public String toString() {
            return "Edit (" + this.fElements + ") update tester";
        }
    }
}

