/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui.propertypages;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.internal.ui.propertypages.PropertyMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

public class OptionsPropertyPage
extends PropertyPage {
    private Button fRefreshSolibsButton;

    public OptionsPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite comp = ControlFactory.createComposite((Composite)parent, (int)1);
        this.fRefreshSolibsButton = this.createCheckButton(comp, PropertyMessages.getString("OptionsPropertyPage.1"));
        this.initialize();
        return comp;
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private void initialize() {
        boolean solibUpdate = true;
        ICDISession session = (ICDISession)this.getElement().getAdapter(ICDISession.class);
        if (session instanceof Session) {
            solibUpdate = ((Session)session).getSharedLibraryManager().isAutoUpdate();
        }
        this.fRefreshSolibsButton.setSelection(solibUpdate);
    }

    protected void performApply() {
        this.storeValues();
        super.performApply();
    }

    public boolean performOk() {
        this.storeValues();
        return super.performOk();
    }

    private void storeValues() {
        ICDISession session = (ICDISession)this.getElement().getAdapter(ICDISession.class);
        final ICDITarget target = (ICDITarget)this.getElement().getAdapter(ICDITarget.class);
        if (session instanceof Session) {
            final boolean solibUpdate = this.fRefreshSolibsButton.getSelection();
            final Session miSession = (Session)session;
            miSession.getSharedLibraryManager().setAutoUpdate(solibUpdate);
            if (target.isSuspended() && solibUpdate) {
                DebugPlugin.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (target.isSuspended() && solibUpdate) {
                            try {
                                miSession.getSharedLibraryManager().update();
                            }
                            catch (CDIException cDIException) {}
                        }
                    }
                });
            }
        }
    }
}

