/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICOwner;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;

public class MakeProject
implements ICOwner {
    public void configure(ICDescriptor cDescriptor) throws CoreException {
        cDescriptor.remove("org.eclipse.cdt.core.ScannerInfoProvider");
        cDescriptor.remove("org.eclipse.cdt.core.CBuildModel");
        this.updateBinaryParsers(cDescriptor);
        this.updateIndexers(cDescriptor);
    }

    public void update(ICDescriptor cDescriptor, String extensionID) throws CoreException {
        if (extensionID.equals("org.eclipse.cdt.core.BinaryParser")) {
            this.updateBinaryParsers(cDescriptor);
        }
        if (extensionID.equals("org.eclipse.cdt.core.CIndexer")) {
            this.updateIndexers(cDescriptor);
        }
    }

    private void updateBinaryParsers(ICDescriptor cDescriptor) throws CoreException {
        cDescriptor.remove("org.eclipse.cdt.core.BinaryParser");
        Preferences makePrefs = MakeCorePlugin.getDefault().getPluginPreferences();
        String ids = makePrefs.getString("binaryparser");
        if (ids != null && ids.length() != 0) {
            String[] stringArray = this.parseStringToArray(ids);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                cDescriptor.create("org.eclipse.cdt.core.BinaryParser", id);
                ++n2;
            }
        }
    }

    private void updateIndexers(ICDescriptor cDescriptor) throws CoreException {
        cDescriptor.remove("org.eclipse.cdt.core.CIndexer");
        Preferences corePrefs = CCorePlugin.getDefault().getPluginPreferences();
        String ids = corePrefs.getString("indexer");
        if (ids != null && ids.length() != 0) {
            String[] stringArray = this.parseStringToArray(ids);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                cDescriptor.create("org.eclipse.cdt.core.CIndexer", id);
                ++n2;
            }
        }
    }

    private String[] parseStringToArray(String syms) {
        if (syms != null && syms.length() > 0) {
            StringTokenizer tok = new StringTokenizer(syms, ";");
            ArrayList<String> list = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreElements()) {
                list.add(tok.nextToken());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }
}

