/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.DebugCoreMessages;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpointType;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint2;
import org.eclipse.cdt.debug.internal.core.model.CFloatingPointValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.w3c.dom.Document;

public class CDebugUtils {
    private static CharsetDecoder fDecoder;

    public static boolean question(IStatus status, Object source) {
        Boolean result = Boolean.FALSE;
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                result = (Boolean)handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    public static void info(IStatus status, Object source) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {}
        }
    }

    public static void error(IStatus status, Object source) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {}
        }
    }

    public static char[] getByteText(byte b) {
        return new char[]{CDebugUtils.charFromByte((byte)(b >>> 4 & 0xF)), CDebugUtils.charFromByte((byte)(b & 0xF))};
    }

    public static byte textToByte(char[] text) {
        byte result = 0;
        if (text.length == 2) {
            byte[] bytes = new byte[]{CDebugUtils.charToByte(text[0]), CDebugUtils.charToByte(text[1])};
            result = (byte)((bytes[0] << 4) + bytes[1]);
        }
        return result;
    }

    public static char charFromByte(byte value) {
        if (value >= 0 && value <= 9) {
            return (char)(value + 48);
        }
        if (value >= 10 && value <= 15) {
            return (char)(value - 10 + 97);
        }
        return '0';
    }

    public static byte charToByte(char ch) {
        if (Character.isDigit(ch)) {
            return (byte)(ch - 48);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (byte)(10 + ch - 97);
        }
        if (ch >= 'A' && ch <= 'F') {
            return (byte)(10 + ch - 65);
        }
        return 0;
    }

    public static char bytesToChar(byte[] bytes) {
        try {
            return (char)Short.parseShort(new String(bytes), 16);
        }
        catch (RuntimeException runtimeException) {
            return '\u0000';
        }
    }

    public static byte toByte(char[] bytes, boolean le) {
        if (bytes.length != 2) {
            return 0;
        }
        return (byte)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static short toUnsignedByte(char[] bytes, boolean le) {
        if (bytes.length != 2) {
            return 0;
        }
        return (short)Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    public static short toShort(char[] bytes, boolean le) {
        if (bytes.length != 4) {
            return 0;
        }
        return (short)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static int toUnsignedShort(char[] bytes, boolean le) {
        if (bytes.length != 4) {
            return 0;
        }
        return (int)Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    public static int toInt(char[] bytes, boolean le) {
        if (bytes.length != 8) {
            return 0;
        }
        return (int)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static long toUnsignedInt(char[] bytes, boolean le) {
        if (bytes.length != 8) {
            return 0L;
        }
        return Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    private static String bytesToString(char[] bytes, boolean le, boolean signed) {
        char[] copy = new char[bytes.length];
        if (le) {
            int i = 0;
            while (i < bytes.length / 2) {
                copy[2 * i] = bytes[bytes.length - 2 * i - 2];
                copy[2 * i + 1] = bytes[bytes.length - 2 * i - 1];
                ++i;
            }
        } else {
            System.arraycopy(bytes, 0, copy, 0, copy.length);
        }
        return new String(copy);
    }

    public static String prependString(String text, int length, char ch) {
        StringBuffer sb = new StringBuffer(length);
        if (text.length() > length) {
            sb.append(text.substring(0, length));
        } else {
            char[] prefix = new char[length - text.length()];
            Arrays.fill(prefix, ch);
            sb.append(prefix);
            sb.append(text);
        }
        return sb.toString();
    }

    public static boolean isReferencedProject(IProject parent, IProject project) {
        if (parent != null && parent.exists()) {
            List projects = CDebugUtils.getReferencedProjects(project);
            for (IProject prj : projects) {
                if (!prj.exists() || !prj.equals((Object)project)) continue;
                return true;
            }
        }
        return false;
    }

    public static String serializeDocument(Document doc, boolean indent) throws IOException, TransformerException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", indent ? "yes" : "no");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public static String serializeDocument(Document doc) throws IOException, TransformerException {
        return CDebugUtils.serializeDocument(doc, true);
    }

    public static Number getFloatingPointValue(ICValue value) {
        if (value instanceof CFloatingPointValue) {
            try {
                return ((CFloatingPointValue)value).getFloatingPointValue();
            }
            catch (CDIException cDIException) {}
        }
        return null;
    }

    public static boolean isNaN(Number value) {
        if (value instanceof Double) {
            return ((Double)value).isNaN();
        }
        if (value instanceof Float) {
            return ((Float)value).isNaN();
        }
        return false;
    }

    public static boolean isPositiveInfinity(Number value) {
        if (value instanceof Double) {
            return ((Double)value).isInfinite() && value.doubleValue() == Double.POSITIVE_INFINITY;
        }
        if (value instanceof Float) {
            return ((Float)value).isInfinite() && value.floatValue() == Float.POSITIVE_INFINITY;
        }
        return false;
    }

    public static boolean isNegativeInfinity(Number value) {
        if (value instanceof Double) {
            return ((Double)value).isInfinite() && value.doubleValue() == Double.NEGATIVE_INFINITY;
        }
        if (value instanceof Float) {
            return ((Float)value).isInfinite() && value.floatValue() == Float.NEGATIVE_INFINITY;
        }
        return false;
    }

    public static List getReferencedProjects(IProject project) {
        ArrayList<IProject> list = new ArrayList<IProject>(10);
        if (project != null && project.exists() && project.isOpen()) {
            IProject[] refs = new IProject[]{};
            try {
                refs = project.getReferencedProjects();
            }
            catch (CoreException coreException) {}
            int i = 0;
            while (i < refs.length) {
                if (!project.equals((Object)refs[i]) && refs[i] != null && refs[i].exists() && refs[i].isOpen()) {
                    list.add(refs[i]);
                    CDebugUtils.getReferencedProjects(project, refs[i], list);
                }
                ++i;
            }
        }
        return list;
    }

    private static void getReferencedProjects(IProject root, IProject project, List list) {
        if (project != null && project.exists() && project.isOpen()) {
            IProject[] refs = new IProject[]{};
            try {
                refs = project.getReferencedProjects();
            }
            catch (CoreException coreException) {}
            int i = 0;
            while (i < refs.length) {
                if (!list.contains(refs[i]) && refs[i] != null && !refs[i].equals((Object)root) && refs[i].exists() && refs[i].isOpen()) {
                    list.add(refs[i]);
                    CDebugUtils.getReferencedProjects(root, refs[i], list);
                }
                ++i;
            }
        }
    }

    public static String getBreakpointText(IBreakpoint breakpoint, boolean qualified) throws CoreException {
        if (breakpoint instanceof ICAddressBreakpoint) {
            return CDebugUtils.getAddressBreakpointText((ICAddressBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICFunctionBreakpoint) {
            return CDebugUtils.getFunctionBreakpointText((ICFunctionBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICLineBreakpoint) {
            return CDebugUtils.getLineBreakpointText((ICLineBreakpoint)breakpoint, qualified);
        }
        if (breakpoint instanceof ICWatchpoint) {
            return CDebugUtils.getWatchpointText((ICWatchpoint)breakpoint, qualified);
        }
        Object message = breakpoint.getMarker().getAttribute("message");
        if (message != null) {
            return message.toString();
        }
        return "";
    }

    protected static String getLineBreakpointText(ICLineBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        CDebugUtils.appendSourceName(breakpoint, label, qualified);
        CDebugUtils.appendLineNumber(breakpoint, label);
        CDebugUtils.appendBreakpointType(breakpoint, label);
        CDebugUtils.appendIgnoreCount(breakpoint, label);
        CDebugUtils.appendCondition(breakpoint, label);
        return label.toString();
    }

    protected static String getWatchpointText(ICWatchpoint watchpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        CDebugUtils.appendSourceName(watchpoint, label, qualified);
        CDebugUtils.appendWatchExpression(watchpoint, label);
        if (watchpoint instanceof ICWatchpoint2) {
            ICWatchpoint2 wp2 = (ICWatchpoint2)watchpoint;
            CDebugUtils.appendWatchMemorySpace(wp2, label);
            CDebugUtils.appendWatchRange(wp2, label);
        }
        CDebugUtils.appendIgnoreCount(watchpoint, label);
        CDebugUtils.appendCondition(watchpoint, label);
        return label.toString();
    }

    protected static String getAddressBreakpointText(ICAddressBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        CDebugUtils.appendSourceName(breakpoint, label, qualified);
        CDebugUtils.appendAddress(breakpoint, label);
        CDebugUtils.appendBreakpointType(breakpoint, label);
        CDebugUtils.appendIgnoreCount(breakpoint, label);
        CDebugUtils.appendCondition(breakpoint, label);
        return label.toString();
    }

    protected static String getFunctionBreakpointText(ICFunctionBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        CDebugUtils.appendSourceName(breakpoint, label, qualified);
        CDebugUtils.appendFunction(breakpoint, label);
        CDebugUtils.appendBreakpointType(breakpoint, label);
        CDebugUtils.appendIgnoreCount(breakpoint, label);
        CDebugUtils.appendCondition(breakpoint, label);
        return label.toString();
    }

    protected static StringBuffer appendSourceName(ICBreakpoint breakpoint, StringBuffer label, boolean qualified) throws CoreException {
        Path path;
        String handle = breakpoint.getSourceHandle();
        if (!CDebugUtils.isEmpty(handle) && (path = new Path(handle)).isValidPath(handle)) {
            label.append(qualified ? path.toOSString() : path.lastSegment());
        }
        return label;
    }

    protected static StringBuffer appendLineNumber(ICLineBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int lineNumber = breakpoint.getLineNumber();
        if (lineNumber > 0) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.0"), (Object[])new String[]{Integer.toString(lineNumber)}));
        }
        return label;
    }

    protected static StringBuffer appendAddress(ICAddressBreakpoint breakpoint, StringBuffer label) throws CoreException {
        try {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.1"), (Object[])new String[]{breakpoint.getAddress()}));
        }
        catch (NumberFormatException numberFormatException) {}
        return label;
    }

    protected static StringBuffer appendFunction(ICFunctionBreakpoint breakpoint, StringBuffer label) throws CoreException {
        String function = breakpoint.getFunction();
        if (function != null && function.trim().length() > 0) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.2"), (Object[])new String[]{function.trim()}));
        }
        return label;
    }

    protected static StringBuffer appendIgnoreCount(ICBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int ignoreCount = breakpoint.getIgnoreCount();
        if (ignoreCount > 0) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.3"), (Object[])new String[]{Integer.toString(ignoreCount)}));
        }
        return label;
    }

    protected static void appendCondition(ICBreakpoint breakpoint, StringBuffer buffer) throws CoreException {
        String condition = breakpoint.getCondition();
        if (condition != null && condition.length() > 0) {
            buffer.append(' ');
            buffer.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.4"), (Object[])new String[]{condition}));
        }
    }

    private static void appendWatchExpression(ICWatchpoint watchpoint, StringBuffer label) throws CoreException {
        String expression = watchpoint.getExpression();
        if (expression != null && expression.length() > 0) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.5"), (Object[])new String[]{expression}));
        }
    }

    private static void appendWatchMemorySpace(ICWatchpoint2 watchpoint, StringBuffer label) throws CoreException {
        String memorySpace = watchpoint.getMemorySpace();
        if (memorySpace != null && memorySpace.length() > 0) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.6"), (Object[])new String[]{memorySpace}));
        }
    }

    private static void appendWatchRange(ICWatchpoint2 watchpoint, StringBuffer label) throws CoreException {
        String range = watchpoint.getRange().toString();
        if (range.length() > 0 && !range.equals("0")) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.7"), (Object[])new String[]{range}));
        }
    }

    protected static StringBuffer appendBreakpointType(ICBreakpoint breakpoint, StringBuffer label) throws CoreException {
        if (breakpoint instanceof ICBreakpointType) {
            String typeString = "";
            int type = ((ICBreakpointType)((Object)breakpoint)).getType();
            switch (type & 0xFFFFFFFE) {
                case 2: {
                    typeString = DebugCoreMessages.getString("CDebugUtils.Hardware");
                    break;
                }
                case 4: {
                    typeString = DebugCoreMessages.getString("CDebugUtils.Software");
                }
            }
            if ((type & 1) != 0) {
                if (typeString.length() > 0) {
                    typeString = String.valueOf(typeString) + "/";
                }
                typeString = String.valueOf(typeString) + DebugCoreMessages.getString("CDebugUtils.Temporary");
            }
            if (typeString.length() > 0) {
                label.append(' ');
                label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.8"), (Object[])new String[]{typeString}));
            }
        }
        return label;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static CharsetDecoder getCharsetDecoder() {
        String charsetName = CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_CHARSET);
        if (fDecoder == null || !fDecoder.charset().name().equals(charsetName)) {
            Charset charset = Charset.forName(charsetName);
            fDecoder = charset.newDecoder();
        }
        return fDecoder;
    }

    public static ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = CDebugUtils.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                return cProject;
            }
        }
        return null;
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }

    public static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
    }

    public static IPath getProgramPath(ILaunchConfiguration configuration) throws CoreException {
        String path = CDebugUtils.getProgramName(configuration);
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        return new Path(path);
    }
}

