/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import org.eclipse.cdt.dsf.debug.service.AbstractDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.service.GDBBackend;
import org.eclipse.cdt.dsf.gdb.service.GDBMemory_7_0;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_0;
import org.eclipse.cdt.dsf.gdb.service.GDBRunControl;
import org.eclipse.cdt.dsf.gdb.service.GDBRunControl_7_0;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl_7_0;
import org.eclipse.cdt.dsf.mi.service.CSourceLookup;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.MIDisassembly;
import org.eclipse.cdt.dsf.mi.service.MIExpressions;
import org.eclipse.cdt.dsf.mi.service.MIMemory;
import org.eclipse.cdt.dsf.mi.service.MIModules;
import org.eclipse.cdt.dsf.mi.service.MIRegisters;
import org.eclipse.cdt.dsf.mi.service.MIStack;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunchConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbDebugServicesFactory
extends AbstractDsfDebugServicesFactory {
    private static final String GDB_7_0_VERSION = "6.8.50.20090218";
    private final String fVersion;

    public GdbDebugServicesFactory(String version) {
        this.fVersion = version;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public <V> V createService(Class<V> clazz, DsfSession session, Object ... optionalArguments) {
        block6: {
            block5: {
                if (MIBreakpointsManager.class.isAssignableFrom(clazz)) {
                    return (V)((Object)this.createBreakpointManagerService(session));
                }
                if (!ICommandControl.class.isAssignableFrom(clazz)) break block5;
                Object[] objectArray = optionalArguments;
                int n = optionalArguments.length;
                int n2 = 0;
                while (n2 < n) {
                    Object arg = objectArray[n2];
                    if (arg instanceof ILaunchConfiguration) {
                        return (V)this.createCommandControl(session, (ILaunchConfiguration)arg);
                    }
                    ++n2;
                }
                break block6;
            }
            if (!IMIBackend.class.isAssignableFrom(clazz)) break block6;
            Object[] objectArray = optionalArguments;
            int n = optionalArguments.length;
            int n3 = 0;
            while (n3 < n) {
                Object arg = objectArray[n3];
                if (arg instanceof ILaunchConfiguration) {
                    return (V)this.createBackendGDBService(session, (ILaunchConfiguration)arg);
                }
                ++n3;
            }
        }
        return (V)super.createService(clazz, session, new Object[0]);
    }

    protected MIBreakpointsManager createBreakpointManagerService(DsfSession session) {
        return new MIBreakpointsManager(session, "org.eclipse.cdt.debug.core");
    }

    protected IBreakpoints createBreakpointService(DsfSession session) {
        return new MIBreakpoints(session);
    }

    protected ICommandControl createCommandControl(DsfSession session, ILaunchConfiguration config) {
        if (GDB_7_0_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBControl_7_0(session, config);
        }
        return new GDBControl(session, config);
    }

    protected IMIBackend createBackendGDBService(DsfSession session, ILaunchConfiguration lc) {
        return new GDBBackend(session, lc);
    }

    protected IDisassembly createDisassemblyService(DsfSession session) {
        return new MIDisassembly(session);
    }

    protected IExpressions createExpressionService(DsfSession session) {
        return new MIExpressions(session);
    }

    protected IMemory createMemoryService(DsfSession session) {
        if (GDB_7_0_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBMemory_7_0(session);
        }
        return new MIMemory(session);
    }

    protected IModules createModulesService(DsfSession session) {
        return new MIModules(session);
    }

    protected IProcesses createProcessesService(DsfSession session) {
        if (GDB_7_0_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBProcesses_7_0(session);
        }
        return new GDBProcesses(session);
    }

    protected IRegisters createRegistersService(DsfSession session) {
        return new MIRegisters(session);
    }

    protected IRunControl createRunControlService(DsfSession session) {
        if (GDB_7_0_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBRunControl_7_0(session);
        }
        return new GDBRunControl(session);
    }

    protected ISourceLookup createSourceLookupService(DsfSession session) {
        return new CSourceLookup(session);
    }

    protected IStack createStackService(DsfSession session) {
        return new MIStack(session);
    }
}

