/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThreadInfoInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIListThreadGroupsInfo
extends MIInfo {
    private IThreadGroupInfo[] fGroupList;
    private MIThreadInfoInfo fThreadInfo;

    public MIListThreadGroupsInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public IThreadGroupInfo[] getGroupList() {
        return this.fGroupList;
    }

    public MIThreadInfoInfo getThreadInfo() {
        return this.fThreadInfo;
    }

    private void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                if (var.equals("groups")) {
                    MIValue val = results[i].getMIValue();
                    if (val instanceof MIList) {
                        this.parseGroups((MIList)val);
                    }
                } else if (var.equals("threads")) {
                    this.fThreadInfo = new MIThreadInfoInfo(out);
                }
                ++i;
            }
        }
        if (this.fGroupList == null) {
            this.fGroupList = new IThreadGroupInfo[0];
        }
        if (this.fThreadInfo == null) {
            this.fThreadInfo = new MIThreadInfoInfo(null);
        }
    }

    private void parseGroups(MIList list) {
        MIValue[] values = list.getMIValues();
        this.fGroupList = new IThreadGroupInfo[values.length];
        int i = 0;
        while (i < values.length) {
            MIResult[] results = ((MITuple)values[i]).getMIResults();
            String id = "";
            String desc = "";
            MIResult[] mIResultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String str;
                MIValue value;
                MIResult result = mIResultArray[n2];
                String var = result.getVariable();
                if (var.equals("id")) {
                    value = result.getMIValue();
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getCString();
                        id = str.trim();
                    }
                } else if (var.equals("description") && (value = result.getMIValue()) instanceof MIConst) {
                    str = ((MIConst)value).getCString();
                    desc = str.trim();
                }
                ++n2;
            }
            this.fGroupList[i] = new ThreadGroupInfo(id, desc);
            ++i;
        }
    }

    public static interface IThreadGroupInfo {
        public String getGroupId();

        public String getPid();

        public String getName();

        public String getDesciption();
    }

    @Immutable
    private static class ThreadGroupInfo
    implements IThreadGroupInfo {
        final String fGroupId;
        final String fDescription;
        final String fName;

        public ThreadGroupInfo(String id, String description) {
            this.fGroupId = id;
            this.fDescription = description;
            this.fName = ThreadGroupInfo.parseName(this.fDescription);
        }

        private static String parseName(String desc) {
            String name = "";
            Pattern pattern = Pattern.compile("name: (.*?)(, |$)", 8);
            Matcher matcher = pattern.matcher(desc);
            name = matcher.find() ? matcher.group(1) : desc.split("\\s", 2)[0];
            return name;
        }

        public String getGroupId() {
            return this.fGroupId;
        }

        public String getPid() {
            return this.fGroupId;
        }

        public String getName() {
            return this.fName;
        }

        public String getDesciption() {
            return this.fDescription;
        }
    }
}

