/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.codemanipulation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.template.c.CodeTemplateContext;
import org.eclipse.cdt.internal.corext.template.c.FileTemplateContext;
import org.eclipse.cdt.internal.corext.template.c.FileTemplateContextType;
import org.eclipse.cdt.internal.corext.util.Strings;
import org.eclipse.cdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StubUtility {
    private static final String[] EMPTY = new String[0];

    private StubUtility() {
    }

    public static String getHeaderFileContent(ITranslationUnit tu, String fileComment, String typeComment, String declarations, String lineDelimiter) throws CoreException {
        return StubUtility.getHeaderFileContent(StubUtility.getDefaultFileTemplate(tu), tu, fileComment, typeComment, declarations, lineDelimiter);
    }

    public static String getHeaderFileContent(Template template, ITranslationUnit tu, String fileComment, String typeComment, String declarations, String lineDelimiter) throws CoreException {
        if (template == null) {
            return null;
        }
        ICProject project = tu.getCProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setTranslationUnitVariables(tu);
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        context.setVariable("declarations", declarations != null ? declarations : "");
        context.setVariable("type_name", new Path(tu.getElementName()).removeFileExtension().toString());
        String includeGuardSymbol = StubUtility.generateIncludeGuardSymbol(tu.getElementName(), project);
        context.setVariable("include_guard_symbol", includeGuardSymbol != null ? includeGuardSymbol : "");
        String[] fullLine = new String[]{"filecomment", "typecomment", "declarations"};
        return StubUtility.evaluateTemplate(context, template, fullLine);
    }

    public static String getBodyFileContent(ITranslationUnit tu, String fileComment, String typeComment, String declarations, String lineDelimiter) throws CoreException {
        return StubUtility.getBodyFileContent(StubUtility.getDefaultFileTemplate(tu), tu, fileComment, typeComment, declarations, lineDelimiter);
    }

    public static String getBodyFileContent(Template template, ITranslationUnit tu, String fileComment, String typeComment, String declarations, String lineDelimiter) throws CoreException {
        if (template == null) {
            return null;
        }
        ICProject project = tu.getCProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setTranslationUnitVariables(tu);
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        context.setVariable("declarations", declarations != null ? declarations : "");
        String[] fullLine = new String[]{"filecomment", "typecomment", "declarations"};
        return StubUtility.evaluateTemplate(context, template, fullLine);
    }

    public static String getFileContent(Template template, IFile file, String lineDelimiter) throws CoreException {
        FileTemplateContext context = new FileTemplateContext(template.getContextTypeId(), lineDelimiter);
        String fileComment = StubUtility.getFileComment(file, lineDelimiter);
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        ICProject cproject = CoreModel.getDefault().create(file.getProject());
        String includeGuardSymbol = StubUtility.generateIncludeGuardSymbol(file.getName(), cproject);
        context.setVariable("include_guard_symbol", includeGuardSymbol != null ? includeGuardSymbol : "");
        context.setResourceVariables(file);
        String[] fullLine = new String[]{"filecomment"};
        return StubUtility.evaluateTemplate(context, template, fullLine);
    }

    public static String getMethodBodyContent(ICProject project, String typeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.methodbody";
        return StubUtility.getMethodBodyContent(templateId, project, typeName, methodName, bodyStatement, lineDelimiter);
    }

    public static String getConstructorBodyContent(ICProject project, String typeName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.constructorbody";
        return StubUtility.getMethodBodyContent(templateId, project, typeName, typeName, bodyStatement, lineDelimiter);
    }

    public static String getDestructorBodyContent(ICProject project, String typeName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.destructorbody";
        return StubUtility.getMethodBodyContent(templateId, project, typeName, "~" + typeName, bodyStatement, lineDelimiter);
    }

    public static String getMethodBodyContent(String templateId, ICProject project, String typeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate(templateId, project);
        if (template == null) {
            return bodyStatement;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("body_statement", bodyStatement != null ? bodyStatement : "");
        String str = StubUtility.evaluateTemplate(context, template, new String[]{"body_statement"});
        if (str == null && !Strings.containsOnlyWhitespaces(bodyStatement)) {
            return bodyStatement;
        }
        return str;
    }

    public static String getFileComment(ITranslationUnit tu, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.cdt.ui.text.codetemplates.filecomment", tu.getCProject());
        if (template == null) {
            return null;
        }
        ICProject project = tu.getCProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setTranslationUnitVariables(tu);
        return StubUtility.evaluateTemplate(context, template);
    }

    private static String getFileComment(IFile file, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.cdt.ui.text.codetemplates.filecomment", file.getProject());
        if (template == null) {
            return null;
        }
        FileTemplateContext context = new FileTemplateContext(template.getContextTypeId(), lineDelimiter);
        context.setResourceVariables(file);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getClassComment(ITranslationUnit tu, String typeQualifiedName, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.cdt.ui.text.codetemplates.typecomment", tu.getCProject());
        if (template == null) {
            return null;
        }
        ICProject project = tu.getCProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setTranslationUnitVariables(tu);
        context.setVariable("type_name", typeQualifiedName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getMethodComment(ITranslationUnit tu, String typeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.methodcomment";
        return StubUtility.getMethodComment(templateId, tu, typeName, methodName, paramNames, excTypeSig, retTypeSig, lineDelimiter);
    }

    public static String getConstructorComment(ITranslationUnit tu, String typeName, String[] paramNames, String[] excTypeSig, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.constructorcomment";
        return StubUtility.getMethodComment(templateId, tu, typeName, typeName, paramNames, excTypeSig, null, lineDelimiter);
    }

    public static String getDestructorComment(ITranslationUnit tu, String typeName, String[] excTypeSig, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.destructorcomment";
        return StubUtility.getMethodComment(templateId, tu, typeName, "~" + typeName, EMPTY, excTypeSig, null, lineDelimiter);
    }

    public static String getMethodComment(String templateId, ITranslationUnit tu, String typeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        Template template = StubUtility.getCodeTemplate(templateId, tu.getCProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), tu.getCProject(), lineDelimiter);
        context.setTranslationUnitVariables(tu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        if (retTypeSig != null) {
            context.setVariable("return_type", retTypeSig);
        }
        context.setTranslationUnitVariables(tu);
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        return str;
    }

    private static String fixFullLineVariables(TemplateBuffer buffer, String[] variables) throws MalformedTreeException, BadLocationException {
        Document doc = new Document(buffer.getString());
        int nLines = doc.getNumberOfLines();
        MultiTextEdit edit = new MultiTextEdit();
        HashSet<Integer> removedLines = new HashSet<Integer>();
        int i = 0;
        while (i < variables.length) {
            TemplateVariable position = StubUtility.findVariable(buffer, variables[i]);
            if (position != null) {
                int[] offsets;
                if (position.getLength() > 0) {
                    offsets = position.getOffsets();
                    int j = 0;
                    while (j < offsets.length) {
                        block10: {
                            int offset = offsets[j];
                            try {
                                int startLine = doc.getLineOfOffset(offset);
                                int startOffset = doc.getLineOffset(startLine);
                                int endLine = doc.getLineOfOffset(offset + position.getLength());
                                String prefix = doc.get(startOffset, offset - startOffset);
                                if (prefix.length() <= 0 || startLine >= endLine) break block10;
                                int line = startLine + 1;
                                while (line <= endLine) {
                                    int lineOffset = doc.getLineOffset(line);
                                    edit.addChild((TextEdit)new InsertEdit(lineOffset, prefix));
                                    ++line;
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                break;
                            }
                        }
                        ++j;
                    }
                } else {
                    offsets = position.getOffsets();
                    int k = 0;
                    while (k < offsets.length) {
                        int line = doc.getLineOfOffset(offsets[k]);
                        IRegion lineInfo = doc.getLineInformation(line);
                        int offset = lineInfo.getOffset();
                        String str = doc.get(offset, lineInfo.getLength());
                        if (Strings.containsOnlyWhitespaces(str) && nLines > line + 1 && removedLines.add(new Integer(line))) {
                            int nextStart = doc.getLineOffset(line + 1);
                            int length = nextStart - offset;
                            edit.addChild((TextEdit)new DeleteEdit(offset, length));
                        }
                        ++k;
                    }
                }
            }
            ++i;
        }
        edit.apply((IDocument)doc, 0);
        return doc.get();
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static String evaluateTemplate(TemplateContext context, Template template) throws CoreException {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        return str;
    }

    private static String evaluateTemplate(TemplateContext context, Template template, String[] fullLineVariables) throws CoreException {
        String str;
        block6: {
            TemplateBuffer buffer;
            block5: {
                buffer = context.evaluate(template);
                if (buffer != null) break block5;
                return null;
            }
            str = StubUtility.fixFullLineVariables(buffer, fullLineVariables);
            if (!Strings.containsOnlyWhitespaces(str)) break block6;
            return null;
        }
        try {
            return str;
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public static String getLineDelimiterUsed(ICProject project) {
        return StubUtility.getProjectLineDelimiter(project);
    }

    private static String getProjectLineDelimiter(ICProject cProject) {
        String lineDelimiter;
        IProject project = null;
        if (cProject != null) {
            project = cProject.getProject();
        }
        if ((lineDelimiter = StubUtility.getLineDelimiterPreference(project)) != null) {
            return lineDelimiter;
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterPreference(IProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    public static String getLineDelimiterUsed(ICElement elem) throws CModelException {
        if (elem == null) {
            return "";
        }
        ITranslationUnit cu = (ITranslationUnit)elem.getAncestor(60);
        if (cu != null && cu.exists()) {
            IBuffer buf = cu.getBuffer();
            int length = buf.getLength();
            int i = 0;
            while (i < length) {
                char ch = buf.getChar(i);
                if (ch == '\r') {
                    if (i + 1 < length && buf.getChar(i + 1) == '\n') {
                        return "\r\n";
                    }
                    return "\r";
                }
                if (ch == '\n') {
                    return "\n";
                }
                ++i;
            }
        }
        return StubUtility.getProjectLineDelimiter(elem.getCProject());
    }

    public static String getTodoTaskTag(ICProject project) {
        String markers = null;
        markers = project == null ? CCorePlugin.getOption((String)"org.eclipse.cdt.core.taskTags") : project.getOption("org.eclipse.cdt.core.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return "TODO";
    }

    public static boolean doAddComments(ICProject project) {
        return PreferenceConstants.getPreference("org.eclipse.cdt.ui.add_comments", project, false);
    }

    private static Template getDefaultFileTemplate(ITranslationUnit tu) {
        String templateId = null;
        if (tu.isASMLanguage()) {
            templateId = "org.eclipse.cdt.ui.text.codetemplates.asmsourcefile";
        } else if (tu.isCXXLanguage()) {
            templateId = tu.isHeaderUnit() ? "org.eclipse.cdt.ui.text.codetemplates.cppheaderfile" : "org.eclipse.cdt.ui.text.codetemplates.cppsourcefile";
        } else if (tu.isCLanguage()) {
            templateId = tu.isHeaderUnit() ? "org.eclipse.cdt.ui.text.codetemplates.cheaderfile" : "org.eclipse.cdt.ui.text.codetemplates.csourcefile";
        }
        return StubUtility.getCodeTemplate(templateId, tu.getCProject());
    }

    private static Template getCodeTemplate(String id, ICProject cProject) {
        return StubUtility.getCodeTemplate(id, cProject != null ? cProject.getProject() : null);
    }

    private static Template getCodeTemplate(String id, IProject project) {
        if (project == null) {
            return CUIPlugin.getDefault().getCodeTemplateStore().findTemplateById(id);
        }
        ProjectTemplateStore projectStore = new ProjectTemplateStore(project);
        try {
            projectStore.load();
        }
        catch (IOException e) {
            CUIPlugin.log(e);
        }
        return projectStore.findTemplateById(id);
    }

    private static int getIncludeGuardScheme(ICProject cproject) {
        return PreferenceConstants.getPreference("codetemplates.includeGuardGenerationScheme", cproject, 0);
    }

    private static String generateIncludeGuardSymbol(String fileName, ICProject cproject) {
        int preferenceValue = StubUtility.getIncludeGuardScheme(cproject);
        switch (preferenceValue) {
            case 0: {
                if (fileName != null) {
                    return StubUtility.generateIncludeGuardSymbolFromFileName(fileName);
                }
                return null;
            }
            case 1: {
                return StubUtility.generateIncludeGuardSymbolFromUUID();
            }
        }
        CUIPlugin.log("Unknown preference value " + preferenceValue + "for include guard scheme", null);
        return null;
    }

    private static String generateIncludeGuardSymbolFromFileName(String fileName) {
        String name = fileName;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                buf.append(Character.toUpperCase(ch));
            } else if (ch == '.' || ch == '_') {
                buf.append('_');
            }
            ++i;
        }
        buf.append('_');
        return buf.toString();
    }

    private static String generateIncludeGuardSymbolFromUUID() {
        String uuid = UUID.randomUUID().toString();
        StringBuffer buf = new StringBuffer();
        buf.append('H');
        int i = 0;
        while (i < uuid.length()) {
            char ch = uuid.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                buf.append(Character.toUpperCase(ch));
            } else {
                buf.append('_');
            }
            ++i;
        }
        return buf.toString();
    }

    public static Template[] getFileTemplatesForContentTypes(String[] contentTypes, IProject project) {
        TemplatePersistenceData[] templateDatas;
        if (contentTypes == null || contentTypes.length == 0) {
            return new Template[0];
        }
        if (project == null) {
            templateDatas = CUIPlugin.getDefault().getCodeTemplateStore().getTemplateData(true);
        } else {
            ProjectTemplateStore projectStore = new ProjectTemplateStore(project.getProject());
            try {
                projectStore.load();
            }
            catch (IOException e) {
                CUIPlugin.log(e);
            }
            templateDatas = projectStore.getTemplateData();
        }
        ArrayList<Template> result = new ArrayList<Template>();
        int j = 0;
        while (j < contentTypes.length) {
            int i = 0;
            while (i < templateDatas.length) {
                Template template = templateDatas[i].getTemplate();
                String contextTypeId = template.getContextTypeId();
                if (FileTemplateContextType.isContextTypeForContentType(contextTypeId, contentTypes[j])) {
                    result.add(template);
                }
                ++i;
            }
            ++j;
        }
        return result.toArray(new Template[result.size()]);
    }
}

