/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.help;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.internal.ui.help.CHelpEntry;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.help.IHelpResource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CHelpBook
implements ICHelpBook {
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_BTYPE = "type";
    private static final String NODE_ENTRY = "entry";
    private static final String TYPE_C = "HELP_TYPE_C";
    private static final String TYPE_CPP = "HELP_TYPE_CPP";
    private static final String TYPE_ASM = "HELP_TYPE_ASM";
    private static final int DEFAULT_VAL = 1;
    private int type;
    private String title;
    private TreeMap<String, CHelpEntry> entries = new TreeMap();

    public CHelpBook(Element e) {
        if (e.hasAttribute(ATTR_TITLE)) {
            this.title = e.getAttribute(ATTR_TITLE).trim();
        }
        if (e.hasAttribute(ATTR_BTYPE)) {
            String s = e.getAttribute(ATTR_BTYPE);
            try {
                this.type = Integer.parseInt(s);
                if (this.type < 1 || this.type > 3) {
                    this.type = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.type = TYPE_C.equalsIgnoreCase(s) ? 1 : (TYPE_CPP.equalsIgnoreCase(s) ? 2 : (TYPE_ASM.equalsIgnoreCase(s) ? 3 : 1));
            }
        }
        NodeList list = e.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            CHelpEntry he;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && NODE_ENTRY.equals(node.getNodeName()) && (he = new CHelpEntry((Element)node)).isValid()) {
                this.entries.put(he.getKeyword(), he);
            }
            ++i;
        }
    }

    @Override
    public int getCHelpType() {
        return this.type;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public IFunctionSummary getFunctionInfo(ICHelpInvocationContext context, String name) {
        CHelpEntry he;
        IFunctionSummary[] fs;
        if (this.entries.containsKey(name) && (fs = (he = this.entries.get(name)).getFunctionSummary()) != null && fs.length > 0) {
            return fs[0];
        }
        return null;
    }

    public List<IFunctionSummary> getMatchingFunctions(ICHelpInvocationContext context, String prefix) {
        Collection<CHelpEntry> col = null;
        if (prefix == null || prefix.trim().length() == 0) {
            col = this.entries.values();
        } else {
            String pr1 = prefix.trim();
            byte[] bs = pr1.getBytes();
            int i = bs.length - 1;
            while (i >= 0) {
                byte b = bs[i];
                if ((b = (byte)(b + 1)) > bs[i]) {
                    bs[i] = b;
                    break;
                }
                --i;
            }
            SortedMap<String, CHelpEntry> sm = i > -1 ? this.entries.subMap(pr1, new String(bs)) : this.entries.tailMap(pr1);
            col = sm.values();
        }
        if (col.size() > 0) {
            ArrayList<IFunctionSummary> out = new ArrayList<IFunctionSummary>(col.size());
            for (CHelpEntry he : col) {
                IFunctionSummary[] iFunctionSummaryArray = he.getFunctionSummary();
                int n = iFunctionSummaryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFunctionSummary fs = iFunctionSummaryArray[n2];
                    out.add(fs);
                    ++n2;
                }
            }
            return out;
        }
        return null;
    }

    public ICHelpResourceDescriptor getHelpResources(ICHelpInvocationContext context, String name) {
        CHelpEntry he;
        IHelpResource[] hr;
        if (this.entries.containsKey(name) && (hr = (he = this.entries.get(name)).getHelpResource()) != null && hr.length > 0) {
            return new HRDescriptor(this, hr);
        }
        return null;
    }

    public String toString() {
        return "<helpBook title=\"" + this.title + "\" type=\"" + this.type + "\">";
    }

    private class HRDescriptor
    implements ICHelpResourceDescriptor {
        private ICHelpBook book;
        private IHelpResource[] res;

        HRDescriptor(ICHelpBook _book, IHelpResource[] _res) {
            this.book = _book;
            this.res = _res;
        }

        public ICHelpBook getCHelpBook() {
            return this.book;
        }

        public IHelpResource[] getHelpResources() {
            return this.res;
        }
    }
}

