/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.template.c.CContextType;
import org.eclipse.cdt.internal.corext.template.c.TranslationUnitContext;
import org.eclipse.cdt.internal.corext.template.c.TranslationUnitContextType;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.text.c.hover.SourceViewerInformationControl;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEngine {
    private static final String $_LINE_SELECTION = "${line_selection}";
    private static final String $_WORD_SELECTION = "${word_selection}";
    private TemplateContextType fContextType;
    private ArrayList<ICompletionProposal> fProposals = new ArrayList();
    private final Map<IDocument, Position> fPositions = new HashMap<IDocument, Position>();
    private final Pattern fStartOfLineContentPattern = Pattern.compile("[^ \t]");

    public TemplateEngine(TemplateContextType contextType) {
        Assert.isNotNull((Object)contextType);
        this.fContextType = contextType;
    }

    public TemplateEngine() {
        this.fContextType = CUIPlugin.getDefault().getTemplateContextRegistry().getContextType("org.eclipse.cdt.ui.text.templates.c");
        if (this.fContextType == null) {
            this.fContextType = new CContextType();
            CUIPlugin.getDefault().getTemplateContextRegistry().addContextType(this.fContextType);
        }
    }

    public void reset() {
        this.fProposals.clear();
        Iterator<Map.Entry<IDocument, Position>> iterator = this.fPositions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IDocument, Position> entry2;
            Map.Entry<IDocument, Position> entry = entry2 = iterator.next();
            IDocument doc = entry.getKey();
            Position position = entry.getValue();
            doc.removePosition(position);
        }
        this.fPositions.clear();
    }

    public List<ICompletionProposal> getResults() {
        return this.fProposals;
    }

    public void complete(ITextViewer viewer, int completionPosition, ITranslationUnit translationUnit) {
        if (!(this.fContextType instanceof TranslationUnitContextType)) {
            return;
        }
        IDocument document = viewer.getDocument();
        Point selection = viewer.getSelectedRange();
        boolean multipleLinesSelected = this.areMultipleLinesSelected(viewer);
        if (multipleLinesSelected) {
            try {
                IRegion startLine = document.getLineInformationOfOffset(selection.x);
                IRegion endLine = document.getLineInformationOfOffset(selection.x + selection.y - 1);
                completionPosition = selection.x = startLine.getOffset();
                selection.y = endLine.getOffset() + endLine.getLength() - startLine.getOffset();
            }
            catch (BadLocationException badLocationException) {}
        }
        Position position = new Position(completionPosition, selection.y);
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
                document.addPosition(position);
                this.fPositions.put(document, position);
            }
            catch (BadLocationException badLocationException) {}
        }
        TranslationUnitContext context = ((TranslationUnitContextType)this.fContextType).createContext(document, position, translationUnit);
        context.setVariable("selection", selectedText);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        Template[] templates = CUIPlugin.getDefault().getTemplateStore().getTemplates();
        Image image = CPluginImages.get("org.eclipse.cdt.ui.template_obj.gif");
        if (selection.y == 0) {
            int i = 0;
            while (i != templates.length) {
                if (context.canEvaluate(templates[i])) {
                    this.fProposals.add(new CTemplateProposal(templates[i], (TemplateContext)context, (IRegion)region, image));
                }
                ++i;
            }
        } else {
            if (multipleLinesSelected || context.getKey().length() == 0) {
                context.setForceEvaluation(true);
            }
            int i = 0;
            while (i != templates.length) {
                Template template = templates[i];
                if (context.canEvaluate(template) && template.getContextTypeId().equals(context.getContextType().getId()) && (!multipleLinesSelected && template.getPattern().indexOf($_WORD_SELECTION) != -1 || multipleLinesSelected && template.getPattern().indexOf($_LINE_SELECTION) != -1)) {
                    this.fProposals.add(new CTemplateProposal(templates[i], (TemplateContext)context, (IRegion)region, image));
                }
                ++i;
            }
        }
    }

    private boolean areMultipleLinesSelected(ITextViewer viewer) {
        if (viewer == null) {
            return false;
        }
        Point s = viewer.getSelectedRange();
        if (s.y == 0) {
            return false;
        }
        try {
            IDocument document = viewer.getDocument();
            int startLine = document.getLineOfOffset(s.x);
            IRegion line = document.getLineInformation(startLine);
            String lineContent = document.get(line.getOffset(), line.getLength());
            Matcher m = this.fStartOfLineContentPattern.matcher(lineContent);
            int lineContentStart = 0;
            if (m.find()) {
                lineContentStart = m.start() + line.getOffset();
            }
            int lineContentLength = lineContent.trim().length();
            return s.x <= lineContentStart && s.x + s.y >= lineContentStart + lineContentLength;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public class CTemplateProposal
    extends TemplateProposal
    implements ICCompletionProposal {
        public IInformationControlCreator getInformationControlCreator() {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    int orientation = 0x2000000;
                    return new SourceViewerInformationControl(parent, false, orientation, null);
                }
            };
        }

        public CTemplateProposal(Template template, TemplateContext context, IRegion region, Image image) {
            super(template, context, region, image, 1005);
        }

        public String getIdString() {
            return this.getDisplayString();
        }
    }
}

