/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.core.jtagdevice;

import java.util.Collection;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;

public class DefaultGDBJtagDeviceImpl
implements IGDBJtagDevice {
    public void doDelay(int delay, Collection commands) {
        String cmd = "monitor delay " + String.valueOf(delay * 1000);
        this.addCmd(commands, cmd);
    }

    public void doReset(Collection commands) {
        String cmd = "monitor reset run";
        this.addCmd(commands, cmd);
    }

    public int getDefaultDelay() {
        return 0;
    }

    public void doRemote(String ip, int port, Collection commands) {
        String cmd = "target remote " + ip + ":" + String.valueOf(port);
        this.addCmd(commands, cmd);
    }

    public void doHalt(Collection commands) {
        String cmd = "monitor halt";
        this.addCmd(commands, cmd);
    }

    public void doContinue(Collection commands) {
        String cmd = "continue";
        this.addCmd(commands, cmd);
    }

    public void doLoadImage(String imageFileName, String imageOffset, Collection commands) {
        String file = this.escapeScpaces(imageFileName);
        String cmd = "restore " + file + " " + imageOffset;
        this.addCmd(commands, cmd);
    }

    public void doLoadSymbol(String symbolFileName, String symbolOffset, Collection commands) {
        String file = this.escapeScpaces(symbolFileName);
        String cmd = "add-sym " + file + " " + symbolOffset;
        this.addCmd(commands, cmd);
    }

    protected String escapeScpaces(String file) {
        if (file.indexOf(32) >= 0) {
            return String.valueOf('\"') + file + '\"';
        }
        return file;
    }

    public void doSetPC(String pc, Collection commands) {
        String cmd = "set $pc=0x" + pc;
        this.addCmd(commands, cmd);
    }

    public void doStopAt(String stopAt, Collection commands) {
        String cmd = "tbreak " + stopAt;
        this.addCmd(commands, cmd);
    }

    protected void addCmd(Collection commands, String cmd) {
        commands.add(String.valueOf(cmd) + System.getProperty("line.separator"));
    }

    public String getDefaultIpAddress() {
        return "localhost";
    }

    public String getDefaultPortNumber() {
        return "10000";
    }
}

