/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.internal.ui.wizards.ICDTCommonProjectWizard;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIImages;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSWizardHandler;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CDTConfigWizardPage
extends WizardPage {
    public static final String PAGE_ID = "org.eclipse.cdt.managedbuilder.ui.wizard.CConfigWizardPage";
    private static final Image IMG = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_BUILD_CONFIG);
    private static final String TITLE = UIMessages.getString((String)"CConfigWizardPage.0");
    private static final String MESSAGE = UIMessages.getString((String)"CConfigWizardPage.1");
    private static final String COMMENT = UIMessages.getString((String)"CConfigWizardPage.12");
    private static final String EMPTY_STR = "";
    private Table table;
    private CheckboxTableViewer tv;
    private Label l_projtype;
    private Label l_chains;
    private Composite parent;
    private String propertyId;
    private String errorMessage = null;
    private String message = MESSAGE;
    public boolean isVisible = false;
    private MBSWizardHandler handler;
    public boolean pagesLoaded = false;
    private IToolChain[] visitedTCs = null;
    IWizardPage[] customPages = null;

    public CDTConfigWizardPage(MBSWizardHandler h) {
        super(UIMessages.getString((String)"CDTConfigWizardPage.0"));
        this.setPageComplete(false);
        this.handler = h;
        this.setWizard(h.getWizard());
    }

    public CfgHolder[] getCfgItems(boolean getDefault) {
        CfgHolder[] its;
        if (getDefault || this.table == null || !this.isVisited()) {
            its = CDTConfigWizardPage.getDefaultCfgs(this.handler);
        } else {
            ArrayList<CfgHolder> out = new ArrayList<CfgHolder>(this.table.getItemCount());
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem ti = tableItemArray[n2];
                if (ti.getChecked()) {
                    out.add((CfgHolder)ti.getData());
                }
                ++n2;
            }
            its = out.toArray(new CfgHolder[out.size()]);
        }
        return its;
    }

    public void createControl(Composite p) {
        this.parent = new Composite(p, 0);
        this.parent.setFont(this.parent.getFont());
        this.parent.setLayout((Layout)new GridLayout());
        this.parent.setLayoutData((Object)new GridData(1808));
        Composite c1 = new Composite(this.parent, 0);
        c1.setLayout((Layout)new GridLayout(2, false));
        c1.setLayoutData((Object)new GridData(768));
        this.setupLabel(c1, UIMessages.getString((String)"CConfigWizardPage.4"), 1);
        this.l_projtype = this.setupLabel(c1, EMPTY_STR, 768);
        this.setupLabel(c1, UIMessages.getString((String)"CConfigWizardPage.5"), 1);
        this.l_chains = this.setupLabel(c1, EMPTY_STR, 768);
        this.setupLabel(c1, UIMessages.getString((String)"CConfigWizardPage.6"), 1);
        this.setupLabel(c1, EMPTY_STR, 1);
        Composite c2 = new Composite(this.parent, 0);
        c2.setLayout((Layout)new GridLayout(2, false));
        c2.setLayoutData((Object)new GridData(1808));
        this.table = new Table(c2, 2592);
        GridData gd = new GridData(1808);
        this.table.setLayoutData((Object)gd);
        this.tv = new CheckboxTableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == null ? CDTConfigWizardPage.EMPTY_STR : ((CfgHolder)element).getName();
            }

            public Image getImage(Object element) {
                return IMG;
            }
        });
        this.tv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CDTConfigWizardPage.this.setPageComplete(CDTConfigWizardPage.this.isCustomPageComplete());
                CDTConfigWizardPage.this.update();
            }
        });
        Composite c = new Composite(c2, 0);
        c.setLayoutData((Object)new GridData(1040));
        c.setLayout((Layout)new GridLayout());
        Button b1 = new Button(c, 8);
        b1.setText(UIMessages.getString((String)"CConfigWizardPage.7"));
        b1.setLayoutData((Object)new GridData(768));
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDTConfigWizardPage.this.tv.setAllChecked(true);
                CDTConfigWizardPage.this.setPageComplete(CDTConfigWizardPage.this.isCustomPageComplete());
                CDTConfigWizardPage.this.update();
            }
        });
        Button b2 = new Button(c, 8);
        b2.setText(UIMessages.getString((String)"CConfigWizardPage.8"));
        b2.setLayoutData((Object)new GridData(768));
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDTConfigWizardPage.this.tv.setAllChecked(false);
                CDTConfigWizardPage.this.setPageComplete(CDTConfigWizardPage.this.isCustomPageComplete());
                CDTConfigWizardPage.this.update();
            }
        });
        new Label(c, 0).setLayoutData((Object)new GridData(1808));
        Button b3 = new Button(c, 8);
        b3.setText(UIMessages.getString((String)"CConfigWizardPage.13"));
        b3.setLayoutData((Object)new GridData(768));
        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDTConfigWizardPage.this.advancedDialog();
            }
        });
        Group gr = new Group(this.parent, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gr.setLayoutData((Object)gd);
        gr.setLayout((Layout)new FillLayout());
        Label lb = new Label((Composite)gr, 0);
        lb.setText(COMMENT);
        this.setControl((Control)this.parent);
    }

    public static CfgHolder[] getDefaultCfgs(MBSWizardHandler handler) {
        String id = handler.getPropertyId();
        IProjectType pt = handler.getProjectType();
        ArrayList<CfgHolder> out = new ArrayList<CfgHolder>();
        IToolChain[] iToolChainArray = handler.getSelectedToolChains();
        int n = iToolChainArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolChain tc = iToolChainArray[n2];
            CfgHolder[] cfgs = null;
            cfgs = id != null ? CfgHolder.cfgs2items(ManagedBuildManager.getExtensionConfigurations((IToolChain)tc, (String)"org.eclipse.cdt.build.core.buildArtefactType", (String)id)) : (pt != null ? CfgHolder.cfgs2items(ManagedBuildManager.getExtensionConfigurations((IToolChain)tc, (IProjectType)pt)) : new CfgHolder[]{new CfgHolder(tc, null)});
            if (cfgs == null) {
                return null;
            }
            int j = 0;
            while (j < cfgs.length) {
                if (!(cfgs[j].isSystem() || handler.supportedOnly() && !cfgs[j].isSupported())) {
                    out.add(cfgs[j]);
                }
                ++j;
            }
            ++n2;
        }
        return out.toArray(new CfgHolder[out.size()]);
    }

    private boolean isVisited() {
        if (this.table == null || this.handler == null) {
            return false;
        }
        return Arrays.equals(this.handler.getSelectedToolChains(), this.visitedTCs);
    }

    public boolean isCustomPageComplete() {
        if (!this.isVisited()) {
            return true;
        }
        if (this.table.getItemCount() == 0) {
            this.message = this.errorMessage = UIMessages.getString((String)"CConfigWizardPage.10");
            return false;
        }
        if (this.tv.getCheckedElements().length == 0) {
            this.message = this.errorMessage = UIMessages.getString((String)"CConfigWizardPage.11");
            return false;
        }
        this.errorMessage = null;
        this.message = MESSAGE;
        return true;
    }

    public void setVisible(boolean visible) {
        this.parent.setVisible(visible);
        this.isVisible = visible;
        if (visible && this.handler != null && !this.isVisited()) {
            this.tv.setInput((Object)CfgHolder.unique(CDTConfigWizardPage.getDefaultCfgs(this.handler)));
            this.tv.setAllChecked(true);
            String s = EMPTY_STR;
            this.visitedTCs = this.handler.getSelectedToolChains();
            int i = 0;
            while (i < this.visitedTCs.length) {
                s = String.valueOf(s) + (this.visitedTCs[i] == null ? EMPTY_STR : this.visitedTCs[i].getUniqueRealName());
                if (i < this.visitedTCs.length - 1) {
                    s = String.valueOf(s) + "\n";
                }
                ++i;
            }
            this.l_chains.setText(s);
            this.l_projtype.setText(this.handler.getName());
            this.setPageComplete(this.isCustomPageComplete());
            this.l_chains.getParent().pack();
        }
        if (visible) {
            this.parent.getParent().layout(true, true);
            this.update();
        }
    }

    private Label setupLabel(Composite c, String name, int mode) {
        Label l = new Label(c, 64);
        l.setText(name);
        GridData gd = new GridData(mode);
        gd.verticalAlignment = 128;
        l.setLayoutData((Object)gd);
        Composite p = l.getParent();
        l.setFont(p.getFont());
        return l;
    }

    public String getName() {
        return TITLE;
    }

    public Control getControl() {
        return this.parent;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return TITLE;
    }

    protected void update() {
        this.getWizard().getContainer().updateButtons();
        this.getWizard().getContainer().updateMessage();
        this.getWizard().getContainer().updateTitleBar();
    }

    private void advancedDialog() {
        ICDTCommonProjectWizard nmWizard;
        IProject newProject;
        if (this.getWizard() instanceof ICDTCommonProjectWizard && (newProject = (nmWizard = (ICDTCommonProjectWizard)this.getWizard()).getProject(true, false)) != null) {
            boolean oldManage = CDTPrefUtil.getBool((String)"properties.manage.config.disable");
            CDTPrefUtil.setBool((String)"properties.manage.config.disable", (boolean)true);
            try {
                int res = PreferencesUtil.createPropertyDialogOn((Shell)this.getWizard().getContainer().getShell(), (IAdaptable)newProject, (String)this.propertyId, null, null).open();
                if (res != 0) {
                    nmWizard.performCancel();
                }
            }
            finally {
                CDTPrefUtil.setBool((String)"properties.manage.config.disable", (boolean)oldManage);
            }
        }
    }

    public IWizardPage getNextPage() {
        this.pagesLoaded = true;
        return MBSCustomPageManager.getNextPage(PAGE_ID);
    }
}

