/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ISettingsChangeListener;
import org.eclipse.cdt.managedbuilder.internal.core.SettingsChangeEvent;

public class NotificationManager {
    private static NotificationManager fInstance;
    private List fListeners = new ArrayList();

    private NotificationManager() {
    }

    public static NotificationManager getInstance() {
        if (fInstance == null) {
            fInstance = new NotificationManager();
        }
        return fInstance;
    }

    public void optionRemoved(IResourceInfo rcInfo, IHoldsOptions holder, IOption option) {
        SettingsChangeEvent event = NotificationManager.createOptionRemovedEvent(rcInfo, holder, option);
        this.notifyListeners(event);
    }

    public void optionChanged(IResourceInfo rcInfo, IHoldsOptions holder, IOption option, Object oldValue) {
        SettingsChangeEvent event = NotificationManager.createOptionChangedEvent(rcInfo, holder, option, oldValue);
        this.notifyListeners(event);
    }

    private void notifyListeners(SettingsChangeEvent event) {
        ISettingsChangeListener[] listeners = this.fListeners.toArray(new ISettingsChangeListener[this.fListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].settingsChanged(event);
            ++i;
        }
    }

    private static SettingsChangeEvent createOptionChangedEvent(IResourceInfo rcInfo, IHoldsOptions holder, IOption option, Object oldValue) {
        return new SettingsChangeEvent(1, rcInfo, holder, option, oldValue);
    }

    private static SettingsChangeEvent createOptionRemovedEvent(IResourceInfo rcInfo, IHoldsOptions holder, IOption option) {
        return new SettingsChangeEvent(4, rcInfo, holder, option, null);
    }

    public void subscribe(ISettingsChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void unsubscribe(ISettingsChangeListener listener) {
        this.fListeners.remove(listener);
    }
}

