/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.macros.IConfigurationBuildMacroSupplier;
import org.eclipse.cdt.managedbuilder.macros.IProjectBuildMacroSupplier;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableManager;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;

public class ExternalExtensionMacroSupplier
implements ICdtVariableSupplier {
    private static final String[] fNonOverloadableMacros = new String[]{"CWD", "PWD"};
    private ICdtVariableManager fMngr;
    private ICConfigurationDescription fCfgDes;

    public ExternalExtensionMacroSupplier(ICdtVariableManager mngr, ICConfigurationDescription cfgDes) {
        this.fMngr = mngr;
        this.fCfgDes = cfgDes;
    }

    public ICdtVariable getVariable(String macroName, IVariableContextInfo context) {
        if ((macroName = this.getValidName(macroName)) == null) {
            return null;
        }
        IMacroContextInfo info = (IMacroContextInfo)context;
        int contextType = info.getContextType();
        Object contextData = info.getContextData();
        switch (contextType) {
            case 3: {
                IConfiguration cfg = null;
                IBuilder builder = null;
                if (contextData instanceof IBuilder) {
                    builder = (IBuilder)contextData;
                    cfg = builder.getParent().getParent();
                } else if (contextData instanceof IConfiguration) {
                    cfg = (IConfiguration)contextData;
                    builder = cfg.getBuilder();
                }
                if (cfg != null) {
                    IConfigurationBuildMacroSupplier supplier = cfg.getBuildMacroSupplier();
                    if (supplier == null) {
                        return null;
                    }
                    return supplier.getMacro(macroName, cfg, new ExtensionMacroProvider(contextType, contextData));
                }
            }
            case 4: {
                IProjectBuildMacroSupplier supplier;
                if (!(contextData instanceof IManagedProject)) break;
                IManagedProject project = (IManagedProject)contextData;
                IProjectBuildMacroSupplier iProjectBuildMacroSupplier = supplier = project.getProjectType() != null ? project.getProjectType().getBuildMacroSupplier() : null;
                if (supplier == null) {
                    return null;
                }
                return supplier.getMacro(macroName, project, new ExtensionMacroProvider(contextType, contextData));
            }
        }
        return null;
    }

    public ICdtVariable[] getVariables(IVariableContextInfo context) {
        ICdtVariable[] macros = null;
        IMacroContextInfo info = (IMacroContextInfo)context;
        int contextType = info.getContextType();
        Object contextData = info.getContextData();
        switch (contextType) {
            case 3: {
                IConfigurationBuildMacroSupplier supplier;
                IConfiguration cfg = null;
                IBuilder builder = null;
                if (contextData instanceof IBuilder) {
                    builder = (IBuilder)contextData;
                    cfg = builder.getParent().getParent();
                } else if (contextData instanceof IConfiguration) {
                    cfg = (IConfiguration)contextData;
                    builder = cfg.getBuilder();
                }
                if (cfg == null || (supplier = cfg.getBuildMacroSupplier()) == null) break;
                macros = supplier.getMacros(cfg, new ExtensionMacroProvider(contextType, contextData));
                break;
            }
            case 4: {
                IProjectBuildMacroSupplier supplier;
                if (!(contextData instanceof IManagedProject)) break;
                IManagedProject project = (IManagedProject)contextData;
                IProjectBuildMacroSupplier iProjectBuildMacroSupplier = supplier = project.getProjectType() != null ? project.getProjectType().getBuildMacroSupplier() : null;
                if (supplier == null) break;
                macros = supplier.getMacros(project, new ExtensionMacroProvider(contextType, contextData));
            }
        }
        return this.filterVariables(macros);
    }

    protected String getValidName(String name) {
        if (name == null || (name = name.trim()).length() == 0) {
            return null;
        }
        if (fNonOverloadableMacros != null) {
            int i = 0;
            while (i < fNonOverloadableMacros.length) {
                if (fNonOverloadableMacros[i].equals(EnvVarOperationProcessor.normalizeName((String)name))) {
                    return null;
                }
                ++i;
            }
        }
        return name;
    }

    protected ICdtVariable[] filterVariables(ICdtVariable[] macros) {
        return this.filterVariables(macros, fNonOverloadableMacros);
    }

    private ICdtVariable[] filterVariables(ICdtVariable[] macros, String[] remove) {
        if (macros == null || macros.length == 0) {
            return macros;
        }
        ICdtVariable[] filtered = new ICdtVariable[macros.length];
        int filteredNum = 0;
        int i = 0;
        while (i < macros.length) {
            ICdtVariable var = macros[i];
            String name = null;
            if (var != null && (name = var.getName().trim()).length() != 0) {
                boolean skip = false;
                if (remove != null && remove.length > 0) {
                    int j = 0;
                    while (j < remove.length) {
                        if (remove[j] != null && remove[j].equals(name)) {
                            skip = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!skip) {
                    filtered[filteredNum++] = var;
                }
            }
            ++i;
        }
        if (filteredNum != filtered.length) {
            ICdtVariable[] m = new ICdtVariable[filteredNum];
            int i2 = 0;
            while (i2 < filteredNum) {
                m[i2] = filtered[i2];
                ++i2;
            }
            filtered = m;
        }
        return filtered;
    }

    protected ICdtVariableSupplier[] filterValidSuppliers(ICdtVariableSupplier[] suppliers) {
        if (suppliers == null) {
            return null;
        }
        int i = 0;
        int j = 0;
        i = 0;
        while (i < suppliers.length) {
            if (suppliers[i] == this) break;
            ++i;
        }
        if (i >= suppliers.length) {
            return null;
        }
        int startNum = i + 1;
        ICdtVariableSupplier[] validSuppliers = new ICdtVariableSupplier[suppliers.length - startNum];
        i = startNum;
        j = 0;
        while (i < suppliers.length) {
            validSuppliers[j] = suppliers[i];
            ++i;
            ++j;
        }
        return validSuppliers;
    }

    private class ExtensionMacroProvider
    extends BuildMacroProvider {
        private IMacroContextInfo fStartInfo;
        private int fContextType;
        private Object fContextData;
        private boolean fStartInitialized;

        public ExtensionMacroProvider(int contextType, Object contextData) {
            this.fContextType = contextType;
            this.fContextData = contextData;
        }

        public ICdtVariable getVariable(String macroName, int contextType, Object contextData, boolean includeParent) {
            if (ExternalExtensionMacroSupplier.this.getValidName(macroName) == null) {
                return null;
            }
            return ExternalExtensionMacroSupplier.this.fMngr.getVariable(macroName, ExternalExtensionMacroSupplier.this.fCfgDes);
        }

        public ICdtVariable[] getVariables(int contextType, Object contextData, boolean includeParent) {
            return ExternalExtensionMacroSupplier.this.filterVariables(ExternalExtensionMacroSupplier.this.fMngr.getVariables(ExternalExtensionMacroSupplier.this.fCfgDes));
        }

        public IMacroContextInfo getMacroContextInfo(int contextType, Object contextData) {
            IMacroContextInfo startInfo = this.getStartInfo();
            if (contextType == this.fContextType && contextData == this.fContextData) {
                return startInfo;
            }
            IMacroContextInfo info = super.getMacroContextInfo(contextType, contextData);
            if (info == null) {
                return null;
            }
            if (SupplierBasedCdtVariableManager.checkParentContextRelation((IVariableContextInfo)startInfo, (IVariableContextInfo)info)) {
                return info;
            }
            return null;
        }

        protected IMacroContextInfo getStartInfo() {
            if (this.fStartInfo == null && !this.fStartInitialized) {
                IMacroContextInfo info = super.getMacroContextInfo(this.fContextType, this.fContextData);
                if (info != null) {
                    ICdtVariableSupplier[] suppliers = info.getSuppliers();
                    this.fStartInfo = (suppliers = ExternalExtensionMacroSupplier.this.filterValidSuppliers(suppliers)) != null ? new DefaultMacroContextInfo(this.fContextType, this.fContextData, suppliers) : (IMacroContextInfo)info.getNext();
                    this.fStartInitialized = true;
                }
                this.fStartInitialized = true;
            }
            return this.fStartInfo;
        }
    }
}

