/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.macros.IOptionContextData;

public class OptionContextData
implements IOptionContextData {
    private IOption fOption;
    private IBuildObject fParent;

    public OptionContextData(IOption option, IBuildObject parent) {
        this.fOption = option;
        this.fParent = parent;
    }

    public IOption getOption() {
        return this.fOption;
    }

    public IBuildObject getParent() {
        return this.fParent;
    }

    public static IHoldsOptions getHolder(IOptionContextData data) {
        IBuildObject buildObj = data.getParent();
        IToolChain tCh = null;
        IHoldsOptions ho = null;
        IResourceInfo rcInfo = null;
        IFileInfo fileInfo = null;
        IFolderInfo folderInfo = null;
        if (buildObj instanceof ITool) {
            ho = (ITool)buildObj;
        } else if (buildObj instanceof IToolChain) {
            tCh = (IToolChain)buildObj;
        } else if (buildObj instanceof IFileInfo) {
            fileInfo = (IFileInfo)buildObj;
            rcInfo = fileInfo;
        } else if (buildObj instanceof IConfiguration) {
            tCh = ((IConfiguration)buildObj).getToolChain();
        } else if (buildObj instanceof IFolderInfo) {
            folderInfo = (IFolderInfo)buildObj;
            rcInfo = folderInfo;
            tCh = folderInfo.getToolChain();
        }
        if (ho == null) {
            IOption option = data.getOption();
            if (option == null) {
                return null;
            }
            IHoldsOptions tmp = option.getOptionHolder();
            ITool[] tools = null;
            if (tCh != null) {
                IToolChain cur = tCh;
                while (cur != null) {
                    if (cur == tmp) {
                        return tCh;
                    }
                    cur = cur.getSuperClass();
                }
                tools = tCh.getTools();
            } else if (rcInfo != null) {
                tools = rcInfo.getTools();
            }
            if (tools != null) {
                int i = 0;
                while (i < tools.length) {
                    ITool cur = tools[i];
                    while (cur != null) {
                        ITool tool;
                        if (cur == tmp && !(tool = tools[i]).isExtensionElement() && tool.getParent() != null) {
                            ho = tools[i];
                            break;
                        }
                        cur = cur.getSuperClass();
                    }
                    ++i;
                }
            }
            if (ho == null && tmp != null) {
                IToolChain tChain;
                if (tmp instanceof ITool) {
                    ITool tool = (ITool)tmp;
                    if (!tool.isExtensionElement() && tool.getParent() != null) {
                        ho = tmp;
                    }
                } else if (tmp instanceof IToolChain && !(tChain = (IToolChain)tmp).isExtensionElement() && tChain.getParent() != null) {
                    ho = tmp;
                }
            }
        }
        return ho;
    }
}

