/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.DbgTcmUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ObjectTypeBasedStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PathComparator;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeSetStorage;
import org.eclipse.core.runtime.IPath;

public class TcModificationUtil {
    private static void processFolderInfoChildren(FolderInfo foInfo, PerTypeMapStorage storage, IToolChain rtc, Map tcMap, Map toolMap, boolean addSkipInfo) {
        IResourceInfo[] rcInfos = foInfo.getDirectChildResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            IResourceInfo rc = rcInfos[i];
            if (rc instanceof ResourceConfiguration) {
                ResourceConfiguration fi = (ResourceConfiguration)rc;
                IPath p = fi.getPath();
                ITool[] tools = fi.getTools();
                TcModificationUtil.processTools(storage.getMap(8, true), p, tools, toolMap, addSkipInfo);
            } else {
                FolderInfo childFoInfo = (FolderInfo)rc;
                IToolChain tc = foInfo.getToolChain();
                if ((tc = ManagedBuildManager.getRealToolChain(tc)) == rtc) {
                    if (addSkipInfo && tcMap != null) {
                        TreeSet set = TcModificationUtil.getPathTreeSet(tcMap, tc);
                        set.add(childFoInfo.getPath());
                    }
                    TcModificationUtil.processFolderInfoChildren(childFoInfo, storage, tc, tcMap, toolMap, addSkipInfo);
                } else {
                    TcModificationUtil.processFolderInfo(storage, childFoInfo, null, false);
                }
            }
            ++i;
        }
    }

    public static PerTypeMapStorage createChildObjectsRealToolToPathSet(FolderInfo foInfo, Map toolChainMap, Map toolsMap, boolean addSkipPaths) {
        PerTypeMapStorage storage = new PerTypeMapStorage();
        IToolChain tc = foInfo.getToolChain();
        IToolChain rTc = ManagedBuildManager.getRealToolChain(tc);
        ITool[] tools = rTc.getTools();
        toolsMap.clear();
        if (toolChainMap != null) {
            toolChainMap.clear();
        }
        int i = 0;
        while (i < tools.length) {
            toolsMap.put(ManagedBuildManager.getRealTool(tools[i]), null);
            ++i;
        }
        TcModificationUtil.processFolderInfoChildren(foInfo, storage, rTc, toolChainMap, toolsMap, addSkipPaths);
        return storage;
    }

    public static PerTypeMapStorage createParentObjectsRealToolToPathSet(FolderInfo foInfo) {
        PerTypeMapStorage storage = new PerTypeMapStorage();
        IConfiguration cfg = foInfo.getParent();
        FolderInfo rf = (FolderInfo)cfg.getRootFolderInfo();
        IPath p = rf.getPath();
        IBuilder realBuilder = ManagedBuildManager.getRealBuilder(cfg.getBuilder());
        Map map = storage.getMap(4, true);
        TreeSet<IPath> pathSet = new TreeSet<IPath>(PathComparator.INSTANCE);
        pathSet.add(p);
        map.put(realBuilder, pathSet);
        IRealBuildObjectAssociation realCfg = ((Configuration)cfg).getRealBuildObject();
        map = storage.getMap(32, true);
        pathSet = new TreeSet(PathComparator.INSTANCE);
        pathSet.add(p);
        map.put(realCfg, pathSet);
        if (!foInfo.isRoot()) {
            HashSet<IResourceInfo> allRcInfos = new HashSet<IResourceInfo>(Arrays.asList(cfg.getResourceInfos()));
            allRcInfos.removeAll(foInfo.getChildResourceInfoList(true));
            for (Object e : allRcInfos) {
                if (e instanceof ResourceConfiguration) {
                    TcModificationUtil.processFileInfo(storage, (ResourceConfiguration)e, null, false);
                    continue;
                }
                TcModificationUtil.processFolderInfo(storage, (FolderInfo)e, null, false);
            }
        }
        return storage;
    }

    public static PerTypeMapStorage cloneRealToolToPathSet(PerTypeMapStorage storage) {
        storage = (PerTypeMapStorage)storage.clone();
        int[] types = ObjectTypeBasedStorage.getSupportedObjectTypes();
        int i = 0;
        while (i < types.length) {
            Map map = storage.getMap(types[i], false);
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    entry.setValue(((TreeSet)entry.getValue()).clone());
                }
            }
            ++i;
        }
        return storage;
    }

    public static PerTypeMapStorage createRealToolToPathSet(IConfiguration cfg, PerTypeMapStorage skipMapStorage, boolean addSkipPaths) {
        PerTypeMapStorage storage = new PerTypeMapStorage();
        FolderInfo rf = (FolderInfo)cfg.getRootFolderInfo();
        IPath p = rf.getPath();
        Map skipMap = skipMapStorage != null ? skipMapStorage.getMap(4, false) : null;
        IBuilder realBuilder = ManagedBuildManager.getRealBuilder(cfg.getBuilder());
        if (skipMap != null && skipMap.containsKey(realBuilder)) {
            if (addSkipPaths) {
                TreeSet set = TcModificationUtil.getPathTreeSet(skipMap, realBuilder);
                set.add(p);
            }
        } else {
            Map map = storage.getMap(4, true);
            TreeSet<IPath> pathSet = new TreeSet<IPath>(PathComparator.INSTANCE);
            pathSet.add(p);
            map.put(realBuilder, pathSet);
        }
        skipMap = skipMapStorage != null ? skipMapStorage.getMap(32, false) : null;
        IRealBuildObjectAssociation realCfg = ((Configuration)cfg).getRealBuildObject();
        if (skipMap != null && skipMap.containsKey(realCfg)) {
            if (addSkipPaths) {
                TreeSet set = TcModificationUtil.getPathTreeSet(skipMap, realCfg);
                set.add(p);
            }
        } else {
            Map map = storage.getMap(32, true);
            TreeSet<IPath> pathSet = new TreeSet<IPath>(PathComparator.INSTANCE);
            pathSet.add(p);
            map.put(realCfg, pathSet);
        }
        TcModificationUtil.processFolderInfo(storage, rf, skipMapStorage, addSkipPaths);
        IResourceInfo[] rcInfos = rf.getChildResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            IResourceInfo rc = rcInfos[i];
            if (rc instanceof ResourceConfiguration) {
                TcModificationUtil.processFileInfo(storage, (ResourceConfiguration)rc, skipMapStorage, addSkipPaths);
            } else {
                TcModificationUtil.processFolderInfo(storage, (FolderInfo)rc, skipMapStorage, addSkipPaths);
            }
            ++i;
        }
        return storage;
    }

    public static TreeMap createResultingChangesMap(TreeMap resultingMap, TreeMap initialMap) {
        Object oPath;
        int[] types = new int[]{1, 4, 2};
        TreeMap result = new TreeMap(PathComparator.INSTANCE);
        initialMap = (TreeMap)initialMap.clone();
        for (Map.Entry entry : resultingMap.entrySet()) {
            PerTypeSetStorage storage;
            oPath = entry.getKey();
            PerTypeSetStorage resStorage = (PerTypeSetStorage)entry.getValue();
            PerTypeSetStorage initStorage = (PerTypeSetStorage)initialMap.remove(oPath);
            if (initStorage == null || initStorage.isEmpty(true)) {
                storage = resStorage != null && !resStorage.isEmpty(true) ? (PerTypeSetStorage)resStorage.clone() : new PerTypeSetStorage();
            } else if (resStorage == null || resStorage.isEmpty(true)) {
                storage = new PerTypeSetStorage();
                int i = 0;
                while (i < types.length) {
                    Set set = initStorage.getSet(types[i], false);
                    if (set != null && set.size() != 0) {
                        storage.getSet(types[i], true);
                    }
                    ++i;
                }
            } else {
                LinkedHashSet<IBuilder> bInitSet = null;
                LinkedHashSet tInitSet = null;
                storage = new PerTypeSetStorage();
                Set tcInitSet = initStorage.getSet(1, false);
                Set resSet = resStorage.getSet(1, false);
                Set setToStore = TcModificationUtil.compareSets(resSet, tcInitSet);
                if (setToStore != null) {
                    storage.getSet(1, true).addAll(setToStore);
                    ToolChain tc = setToStore.size() != 0 ? (ToolChain)setToStore.iterator().next() : null;
                    IPath path = (IPath)oPath;
                    if (tc != null) {
                        tInitSet = new LinkedHashSet();
                        TcModificationUtil.getRealObjectsSet((Tool[])tc.getTools(), tInitSet);
                        if (path.segmentCount() == 0) {
                            bInitSet = new LinkedHashSet<IBuilder>();
                            IBuilder builder = tc.getBuilder();
                            if (builder != null) {
                                bInitSet.add(ManagedBuildManager.getRealBuilder(builder));
                            }
                        }
                    } else {
                        tcInitSet = Collections.EMPTY_SET;
                        if (path.segmentCount() == 0) {
                            bInitSet = Collections.EMPTY_SET;
                        }
                    }
                }
                if (bInitSet == null) {
                    bInitSet = initStorage.getSet(4, false);
                }
                if ((setToStore = TcModificationUtil.compareSets(resSet = resStorage.getSet(4, false), bInitSet)) != null) {
                    storage.getSet(4, true).addAll(setToStore);
                }
                if (tInitSet == null) {
                    tInitSet = initStorage.getSet(2, false);
                }
                if ((setToStore = TcModificationUtil.compareSets(resSet = resStorage.getSet(2, false), tInitSet)) != null) {
                    storage.getSet(2, true).addAll(setToStore);
                }
            }
            if (storage.isEmpty(false)) continue;
            result.put(oPath, storage);
        }
        if (initialMap.size() != 0) {
            for (Map.Entry entry : initialMap.entrySet()) {
                oPath = entry.getKey();
                PerTypeSetStorage initStorage = (PerTypeSetStorage)entry.getValue();
                if (initStorage.isEmpty(true)) continue;
                PerTypeSetStorage storage = new PerTypeSetStorage();
                int i = 0;
                while (i < types.length) {
                    Set set = initStorage.getSet(types[i], false);
                    if (set != null && set.size() != 0) {
                        storage.getSet(types[i], true).addAll(set);
                    }
                    ++i;
                }
                if (storage.isEmpty(false)) continue;
                result.put(oPath, storage);
            }
        }
        return result;
    }

    private static Set compareSets(Set resSet, Set initSet) {
        Set result = null;
        if (initSet == null || initSet.isEmpty()) {
            if (resSet != null && !resSet.isEmpty()) {
                result = resSet;
            }
        } else if (resSet == null || resSet.isEmpty()) {
            result = Collections.EMPTY_SET;
        } else if (!initSet.equals(resSet)) {
            result = resSet;
        }
        return result;
    }

    private static void processFolderInfo(PerTypeMapStorage storage, FolderInfo info, PerTypeMapStorage skipMapStorage, boolean addSkipPaths) {
        Map skipMap;
        IPath p = info.getPath();
        IToolChain rtc = ManagedBuildManager.getRealToolChain(info.getToolChain());
        Map map = skipMap = skipMapStorage != null ? skipMapStorage.getMap(1, false) : null;
        if (skipMap != null && skipMap.containsKey(rtc)) {
            if (addSkipPaths) {
                TreeSet set = TcModificationUtil.getPathTreeSet(skipMap, rtc);
                set.add(p);
            }
        } else {
            Map map2 = storage.getMap(1, true);
            TreeSet set = TcModificationUtil.getPathTreeSet(map2, rtc);
            set.add(p);
        }
        ITool[] tools = info.getTools();
        TcModificationUtil.processTools(storage, p, tools, skipMapStorage, addSkipPaths);
    }

    public static IRealBuildObjectAssociation[] getRealObjects(IRealBuildObjectAssociation[] objs, Class clazz) {
        LinkedHashSet<IRealBuildObjectAssociation> set = new LinkedHashSet<IRealBuildObjectAssociation>();
        int i = 0;
        while (i < objs.length) {
            set.add(objs[i].getRealBuildObject());
            ++i;
        }
        Object[] array = (Object[])Array.newInstance(clazz, set.size());
        return (IRealBuildObjectAssociation[])set.toArray(array);
    }

    public static Set getRealObjectsSet(IRealBuildObjectAssociation[] objs, Set set) {
        if (set == null) {
            set = new LinkedHashSet<IRealBuildObjectAssociation>();
        }
        int i = 0;
        while (i < objs.length) {
            set.add(objs[i].getRealBuildObject());
            ++i;
        }
        return set;
    }

    public static Map getRealToObjectsMap(IRealBuildObjectAssociation[] objs, Map map) {
        if (map == null) {
            map = new LinkedHashMap<IRealBuildObjectAssociation, IRealBuildObjectAssociation>();
        }
        int i = 0;
        while (i < objs.length) {
            map.put(objs[i].getRealBuildObject(), objs[i]);
            ++i;
        }
        return map;
    }

    private static void processFileInfo(PerTypeMapStorage storage, ResourceConfiguration info, PerTypeMapStorage skipMapStorage, boolean addSkipPaths) {
        IPath p = info.getPath();
        ITool[] tools = info.getTools();
        TcModificationUtil.processTools(storage, p, tools, skipMapStorage, addSkipPaths);
    }

    private static void processTools(PerTypeMapStorage storage, IPath path, ITool[] tools, PerTypeMapStorage skipMapStorage, boolean addSkipPaths) {
        Map map = storage.getMap(2, true);
        Map skipMap = skipMapStorage != null ? skipMapStorage.getMap(2, false) : null;
        TcModificationUtil.processTools(map, path, tools, skipMap, addSkipPaths);
    }

    private static void processTools(Map storageMap, IPath path, ITool[] tools, Map skipMap, boolean addSkipPaths) {
        int i = 0;
        while (i < tools.length) {
            TreeSet set;
            ITool rt = ManagedBuildManager.getRealTool(tools[i]);
            if (skipMap != null && skipMap.containsKey(rt)) {
                if (addSkipPaths) {
                    set = TcModificationUtil.getPathTreeSet(skipMap, rt);
                    set.add(path);
                }
            } else {
                set = TcModificationUtil.getPathTreeSet(storageMap, rt);
                set.add(path);
            }
            ++i;
        }
    }

    public static TreeSet getPathTreeSet(Map map, Object obj) {
        TreeSet set = (TreeSet)map.get(obj);
        if (set == null) {
            set = new TreeSet(PathComparator.INSTANCE);
            map.put(obj, set);
        }
        return set;
    }

    public static ArrayList getArrayList(Map map, Object obj) {
        ArrayList list = (ArrayList)map.get(obj);
        if (list == null) {
            list = new ArrayList();
            map.put(obj, list);
        }
        return list;
    }

    public static Object removeBuilderInfo(PerTypeMapStorage storage, IBuilder builder) {
        return storage.getMap(4, true).remove(builder);
    }

    public static void restoreBuilderInfo(PerTypeMapStorage storage, IBuilder builder, Object obj) {
        storage.getMap(4, true).put(builder, obj);
    }

    public static void removePaths(Map map, IRealBuildObjectAssociation obj, Set paths) {
        Set objPaths = (Set)map.get(obj);
        if (objPaths == null) {
            return;
        }
        objPaths.removeAll(paths);
        if (objPaths.size() == 0) {
            map.remove(obj);
        }
    }

    public static void addPaths(Map map, IRealBuildObjectAssociation obj, Set paths) {
        if (paths.size() == 0) {
            return;
        }
        TreeSet objPaths = (TreeSet)map.get(obj);
        if (objPaths == null) {
            objPaths = new TreeSet(PathComparator.INSTANCE);
            map.put(obj, objPaths);
        }
        objPaths.addAll(paths);
    }

    public static void addPath(Map map, IRealBuildObjectAssociation obj, IPath path) {
        TreeSet<IPath> objPaths = (TreeSet<IPath>)map.get(obj);
        if (objPaths == null) {
            objPaths = new TreeSet<IPath>(PathComparator.INSTANCE);
            map.put(obj, objPaths);
        }
        objPaths.add(path);
    }

    public static void applyBuilder(PerTypeMapStorage storage, IPath path, IBuilder builder) {
        Map bMap = storage.getMap(4, true);
        bMap.clear();
        IBuilder realBuilder = ManagedBuildManager.getRealBuilder(builder);
        TreeSet set = TcModificationUtil.getPathTreeSet(bMap, realBuilder);
        set.add(path);
    }

    public static void applyBuilder(TreeMap pathMap, IPath path, IBuilder builder) {
        IBuilder realBuilder = ManagedBuildManager.getRealBuilder(builder);
        PerTypeSetStorage storage = (PerTypeSetStorage)pathMap.get(path);
        Set set = storage.getSet(4, true);
        set.clear();
        set.add(realBuilder);
    }

    public static TreeMap createPathMap(IConfiguration cfg) {
        PerTypeMapStorage storage = TcModificationUtil.createRealToolToPathSet(cfg, null, false);
        return TcModificationUtil.createPathMap(storage);
    }

    public static TreeMap createPathMap(PerTypeMapStorage storage) {
        int[] types = ObjectTypeBasedStorage.getSupportedObjectTypes();
        TreeMap result = new TreeMap(PathComparator.INSTANCE);
        int i = 0;
        while (i < types.length) {
            int type = types[i];
            Map map = storage.getMap(type, false);
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    SortedSet pathSet = (SortedSet)entry.getValue();
                    for (Object path : pathSet) {
                        PerTypeSetStorage oset = (PerTypeSetStorage)result.get(path);
                        if (oset == null) {
                            oset = new PerTypeSetStorage();
                            result.put(path, oset);
                        }
                        oset.getSet(type, true).add(entry.getKey());
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static TreeMap clonePathMap(TreeMap map) {
        map = (TreeMap)map.clone();
        for (Map.Entry entry : map.entrySet()) {
            entry.setValue(((PerTypeSetStorage)entry.getValue()).clone());
        }
        return map;
    }

    private static boolean pathContainsObjects(PerTypeMapStorage storage, IPath path, int type) {
        Map map = storage.getMap(type, false);
        if (map == null) {
            return false;
        }
        for (SortedSet set : map.values()) {
            if (!set.contains(path)) continue;
            return true;
        }
        return false;
    }

    public static SortedSet getDirectChildUsagePaths(PerTypeMapStorage storage, IPath path, IRealBuildObjectAssociation obj, SortedSet inclusionPaths) {
        Map objMap = storage.getMap(obj.getType(), false);
        SortedSet objPaths = (SortedSet)objMap.get(obj);
        if (DbgTcmUtil.DEBUG && !objPaths.contains(path)) {
            DbgTcmUtil.fail();
        }
        SortedSet objChildPaths = PathComparator.getChildPathSet(objPaths, path, false, true);
        if (inclusionPaths != null) {
            objChildPaths.retainAll(inclusionPaths);
        }
        Iterator iter = objMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object cur = entry.getKey();
            if (obj == cur) continue;
            SortedSet curPaths = (SortedSet)entry.getValue();
            curPaths = PathComparator.getChildPathSet(curPaths, path, false, false);
            Iterator pathIter = objChildPaths.iterator();
            while (pathIter.hasNext()) {
                SortedSet sub = curPaths.tailSet(pathIter.next());
                if (sub.size() == 0) continue;
                iter.remove();
            }
        }
        objChildPaths.add(path);
        return objChildPaths;
    }

    public static boolean containCommonEntries(Set set, Object[] objs) {
        int i = 0;
        while (i < objs.length) {
            if (set.contains(objs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IRealBuildObjectAssociation[] getRealObjects(int type) {
        switch (type) {
            case 2: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getRealTools();
            }
            case 1: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getRealToolChains();
            }
            case 4: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getRealBuilders();
            }
            case 32: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getExtensionConfigurations();
            }
        }
        throw new IllegalArgumentException();
    }

    public static IRealBuildObjectAssociation[] getExtensionObjects(int type) {
        switch (type) {
            case 2: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getExtensionTools();
            }
            case 1: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getExtensionToolChains();
            }
            case 4: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getExtensionBuilders();
            }
            case 32: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getExtensionConfigurations();
            }
        }
        throw new IllegalArgumentException();
    }

    public static IRealBuildObjectAssociation getObjectById(int type, String id) {
        switch (type) {
            case 2: {
                return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getExtensionTool(id));
            }
            case 1: {
                return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getExtensionToolChain(id));
            }
            case 4: {
                return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getExtensionBuilder(id));
            }
            case 32: {
                return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getExtensionConfiguration(id));
            }
        }
        throw new IllegalArgumentException();
    }
}

