/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.dnd.AbstractContainerAreaDropAdapter;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetDndUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class LocalTransferDropTargetListener
extends AbstractContainerAreaDropAdapter {
    Viewer fViewer;

    public LocalTransferDropTargetListener(Viewer viewer) {
        this.fViewer = viewer;
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    private IStructuredSelection getSelection() {
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public int dragEnterOperation(int operation) {
        int bestOperation = this.determineBestOperation(this.getSelection(), null);
        if (bestOperation > operation) {
            bestOperation = operation;
        }
        return bestOperation;
    }

    public int dragOverOperation(int operation, IContainer dropContainer, Object dropTarget) {
        int bestOperation = 0;
        IStructuredSelection selection = this.getSelection();
        if (dropContainer != null && selection != null && !selection.toList().contains(dropTarget) && (bestOperation = this.determineBestOperation(selection, dropContainer)) > operation) {
            bestOperation = operation;
        }
        return bestOperation;
    }

    public void dropToContainer(Object dropObject, IContainer dropContainer, int operation) {
        if (dropObject instanceof IStructuredSelection && dropContainer != null) {
            IMakeTarget[] makeTargets = LocalTransferDropTargetListener.prepareMakeTargetsFromSelection((IStructuredSelection)dropObject, dropContainer);
            MakeTargetDndUtil.copyTargets(makeTargets, dropContainer, operation, this.fViewer.getControl().getShell());
        }
    }

    private static boolean isConvertibleToFile(Object element) {
        IAdaptable a;
        return element instanceof IAdaptable && (a = (IAdaptable)element).getAdapter(IFile.class) != null;
    }

    private int determineBestOperation(IStructuredSelection selection, IContainer dropContainer) {
        int bestOperation = 0;
        if (selection != null) {
            List items = selection.toList();
            for (Object item : items) {
                if (item instanceof IMakeTarget) {
                    IContainer container = ((IMakeTarget)item).getContainer();
                    if (dropContainer == null || !dropContainer.equals((Object)container)) {
                        if (bestOperation >= 2) continue;
                        bestOperation = 2;
                        continue;
                    }
                    if (!dropContainer.equals((Object)container) || bestOperation >= 1) continue;
                    bestOperation = 1;
                    continue;
                }
                if (LocalTransferDropTargetListener.isConvertibleToFile(item)) {
                    if (bestOperation >= 1) continue;
                    bestOperation = 1;
                    continue;
                }
                bestOperation = 0;
                break;
            }
        }
        return bestOperation;
    }

    private static IMakeTarget[] prepareMakeTargetsFromSelection(IStructuredSelection selection, IContainer dropContainer) {
        List elements = selection.toList();
        ArrayList<IMakeTarget> makeTargetsList = new ArrayList<IMakeTarget>(elements.size());
        for (Object element : elements) {
            if (element instanceof IMakeTarget) {
                makeTargetsList.add((IMakeTarget)element);
                continue;
            }
            if (!LocalTransferDropTargetListener.isConvertibleToFile(element)) continue;
            IAdaptable a = (IAdaptable)element;
            IFile file = (IFile)a.getAdapter(IFile.class);
            String fileName = file.getName();
            String fileLocation = file.getLocation().toString();
            if (fileName == null) continue;
            try {
                String buildCommand = MakeTargetDndUtil.getProjectBuildCommand(dropContainer.getProject());
                IMakeTarget makeTarget = MakeTargetDndUtil.createMakeTarget(fileName, fileLocation, buildCommand, dropContainer);
                makeTargetsList.add(makeTarget);
            }
            catch (CoreException e) {
                MakeUIPlugin.log(e);
            }
        }
        if (makeTargetsList.size() > 0) {
            return makeTargetsList.toArray(new IMakeTarget[makeTargetsList.size()]);
        }
        return null;
    }
}

