/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildDescription;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildIOType;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildResource;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStep;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDescriptionModelTests
extends TestCase {
    private static final String PREFIX = "BuildDescription_";
    private static final String PROJ_PATH = "testBuildDescriptionProjects";
    private CompositeCleaner fCompositeCleaner = new CompositeCleaner();
    private Runnable fCleaner = this.fCompositeCleaner;

    public static Test suite() {
        return new TestSuite(BuildDescriptionModelTests.class);
    }

    public void testDes_Model() {
        IProject project = this.createProject("BuildDescription_1", "test30_2.tar");
        IFile aAsm = ManagedBuildTestHelper.createFile(project, "a.asm");
        ManagedBuildTestHelper.createFile(project, "b.asm");
        ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        cfg.setArtifactExtension("tmp");
        cfg.getName();
        BuildDescription des = new BuildDescription(cfg);
        BuildResource aAsmRc = des.createResource("a.asm");
        BuildDescriptionModelTests.assertNotNull((String)"failed to create resource a.asm", (Object)aAsmRc);
        if (aAsmRc != des.createResource((IResource)aAsm)) {
            BuildDescriptionModelTests.fail((String)"new build resource created for the same resource");
        }
        if (aAsmRc != des.createResource("a.asm")) {
            BuildDescriptionModelTests.fail((String)"new build resource created for the same resource");
        }
        if (aAsmRc != des.createResource(aAsm.getLocation(), aAsm.getLocationURI())) {
            BuildDescriptionModelTests.fail((String)"new build resource created for the same resource");
        }
        BuildDescriptionModelTests.assertEquals((Object)aAsmRc.getProducerIOType(), null);
        BuildDescriptionModelTests.assertEquals((int)aAsmRc.getDependentIOTypes().length, (int)0);
        BuildStep inStep = (BuildStep)des.getInputStep();
        BuildDescriptionModelTests.assertEquals((String)"input step has inputs", (int)inStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((String)"initial input step has outputs", (int)inStep.getOutputIOTypes().length, (int)0);
        BuildIOType type = inStep.createIOType(false, true, null);
        if (type == null) {
            BuildDescriptionModelTests.fail((String)"failed to create output type");
        }
        BuildDescriptionModelTests.assertNotNull((Object)type);
        BuildDescriptionModelTests.assertEquals((Object)type.getStep(), (Object)inStep);
        type.addResource(aAsmRc);
        BuildDescriptionModelTests.assertEquals((Object)aAsmRc.getProducerIOType(), (Object)type);
        BuildDescriptionModelTests.assertEquals((int)aAsmRc.getDependentIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((String)"input step has inputs", (int)inStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((int)inStep.getOutputIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)inStep.getOutputIOTypes()[0], (Object)type);
        BuildDescriptionModelTests.assertEquals((int)type.getResources().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)type.getResources()[0], (Object)aAsmRc);
        BuildResource bAsmRc = des.createResource("b.asm");
        BuildDescriptionModelTests.assertEquals((Object)bAsmRc.getProducerIOType(), null);
        BuildDescriptionModelTests.assertEquals((int)bAsmRc.getDependentIOTypes().length, (int)0);
        type.addResource(bAsmRc);
        BuildDescriptionModelTests.assertEquals((Object)bAsmRc.getProducerIOType(), (Object)type);
        BuildDescriptionModelTests.assertEquals((int)bAsmRc.getDependentIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((String)"input step has inputs", (int)inStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((int)inStep.getOutputIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)inStep.getOutputIOTypes()[0], (Object)type);
        BuildDescriptionModelTests.assertEquals((int)type.getResources().length, (int)2);
        BuildStep step = des.createStep(null, null);
        BuildDescriptionModelTests.assertEquals((String)"new step has inputs", (int)inStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((String)"new step has outputs", (int)inStep.getOutputIOTypes().length, (int)1);
        BuildIOType iType = step.createIOType(true, true, null);
        if (iType == null) {
            BuildDescriptionModelTests.fail((String)"failed to create in type");
        }
        BuildDescriptionModelTests.assertEquals((Object)iType.getStep(), (Object)step);
        BuildDescriptionModelTests.assertEquals((Object)aAsmRc.getProducerIOType(), (Object)type);
        BuildDescriptionModelTests.assertEquals((int)aAsmRc.getDependentIOTypes().length, (int)0);
        iType.addResource(aAsmRc);
        BuildDescriptionModelTests.assertEquals((Object)aAsmRc.getProducerIOType(), (Object)type);
        BuildDescriptionModelTests.assertEquals((int)aAsmRc.getDependentIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)aAsmRc.getDependentIOTypes()[0], (Object)iType);
        BuildDescriptionModelTests.assertEquals((String)"input step has inputs", (int)inStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((int)inStep.getOutputIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)inStep.getOutputIOTypes()[0], (Object)type);
        BuildDescriptionModelTests.assertEquals((int)iType.getResources().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)iType.getResources()[0], (Object)aAsmRc);
        BuildDescriptionModelTests.assertEquals((Object)bAsmRc.getProducerIOType(), (Object)type);
        BuildDescriptionModelTests.assertEquals((int)bAsmRc.getDependentIOTypes().length, (int)0);
        iType.addResource(bAsmRc);
        BuildDescriptionModelTests.assertEquals((Object)bAsmRc.getProducerIOType(), (Object)type);
        BuildDescriptionModelTests.assertEquals((int)bAsmRc.getDependentIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)bAsmRc.getDependentIOTypes()[0], (Object)iType);
        BuildDescriptionModelTests.assertEquals((String)"input step has inputs", (int)inStep.getInputIOTypes().length, (int)0);
        BuildDescriptionModelTests.assertEquals((int)inStep.getOutputIOTypes().length, (int)1);
        BuildDescriptionModelTests.assertEquals((Object)inStep.getOutputIOTypes()[0], (Object)type);
        BuildDescriptionModelTests.assertEquals((int)type.getResources().length, (int)2);
    }

    public void testDesTest30_2_asm_only() {
        IProject project = this.createProject("BuildDescription_1", "test30_2.tar");
        ManagedBuildTestHelper.createFile(project, "a.asm");
        ManagedBuildTestHelper.createFile(project, "b.asm");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        cfg.setArtifactExtension("tmp");
        cfg.getName();
        BuildDescription tDes = new BuildDescription(cfg);
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDesTest30_2_empty() {
        IProject project = this.createProject("BuildDescription_1", "test30_2.tar");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        cfg.setArtifactExtension("tmp");
        cfg.getName();
        BuildDescription tDes = new BuildDescription(cfg);
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDesDesTest30_2_cpp_only() {
        IProject project = this.createProject("BuildDescription_1", "test30_2.tar");
        ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        cfg.setArtifactExtension("tmp");
        String cName = cfg.getName();
        BuildDescription tDes = new BuildDescription(cfg);
        BuildStep step = (BuildStep)tDes.getInputStep();
        BuildIOType type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/new.tar"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/new.tar"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/new.log"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/new.log"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + cfg.getArtifactName() + ".tmp"));
        step = (BuildStep)tDes.getOutputStep();
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + cfg.getArtifactName() + ".tmp"));
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDesTest30_1() {
        IProject project = this.loadProject("test30_1");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration cfg = info.getDefaultConfiguration();
        String out = String.valueOf(cfg.getName()) + "/";
        BuildDescription tDes = new BuildDescription(cfg);
        BuildStep step = (BuildStep)tDes.getOutputStep();
        BuildIOType type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "Test30_1.so.4.5.6"));
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "CDT.jpeg"));
        step = tDes.createStep(null, null);
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "CDT.jpeg"));
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "CDT.bmp"));
        step = tDes.createStep(null, null);
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "f1.c"));
        type.addResource(tDes.createResource(String.valueOf(out) + "f2.c"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "test_ar.h"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "CDT.bmp"));
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("test.tar"));
        step = tDes.createStep(null, null);
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "Test30_1.so.4.5.6"));
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "test30_1.so.1.2.3"));
        step = tDes.createStep(null, null);
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "test30_1.so.1.2.3"));
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "f1.o"));
        type.addResource(tDes.createResource(String.valueOf(out) + "f2.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "f1.o"));
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "f1.oprestripped"));
        step = tDes.createStep(null, null);
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "f2.o"));
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "f2.oprestripped"));
        step = tDes.createStep(null, null);
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "f1.oprestripped"));
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "f1.c"));
        step = tDes.createStep(null, null);
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "f2.oprestripped"));
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "f2.c"));
        step = (BuildStep)tDes.getInputStep();
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource("test.tar"));
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDesTest30_2() {
        IProject project = this.createProject("BuildDescription_1", "test30_2.tar");
        ManagedBuildTestHelper.createFile(project, "a.asm");
        ManagedBuildTestHelper.createFile(project, "b.asm");
        ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        cfg.setArtifactExtension("tmp");
        String cName = cfg.getName();
        BuildDescription tDes = new BuildDescription(cfg);
        BuildStep step = (BuildStep)tDes.getInputStep();
        BuildIOType type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("a.asm"));
        type.addResource(tDes.createResource("b.asm"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("a.asm"));
        type.addResource(tDes.createResource("b.asm"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/new.tar"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/new.tar"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/new.log"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/new.log"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + cfg.getArtifactName() + ".tmp"));
        step = (BuildStep)tDes.getOutputStep();
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + cfg.getArtifactName() + ".tmp"));
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    private void doTestStep(IBuildStep step, IBuildStep oStep, boolean up) {
        HashMap<IBuildIOType, IBuildIOType> inMap = new HashMap<IBuildIOType, IBuildIOType>();
        HashMap<IBuildIOType, IBuildIOType> outMap = new HashMap<IBuildIOType, IBuildIOType>();
        this.stepsMatch(step, oStep, inMap, outMap, true);
        HashMap<IBuildIOType, IBuildIOType> map = up ? outMap : inMap;
        for (Map.Entry entry : map.entrySet()) {
            this.doTestType((IBuildIOType)entry.getKey(), (IBuildIOType)entry.getValue());
        }
    }

    private void doTestType(IBuildIOType type, IBuildIOType oType) {
        HashMap<IBuildResource, IBuildResource> map = new HashMap<IBuildResource, IBuildResource>();
        this.typesMatch(type, oType, map, true);
        for (Map.Entry entry : map.entrySet()) {
            this.doTestResource((IBuildResource)entry.getKey(), (IBuildResource)entry.getValue(), !type.isInput());
        }
    }

    private void doTestResource(IBuildResource rc, IBuildResource oRc, boolean up) {
        HashMap<IBuildIOType, IBuildIOType> outMap = new HashMap<IBuildIOType, IBuildIOType>();
        this.doTestResourceMatch(rc, oRc, outMap);
        if (!up) {
            this.typesMatch(rc.getProducerIOType(), oRc.getProducerIOType(), null, true);
            this.doTestStep(rc.getProducerIOType().getStep(), oRc.getProducerIOType().getStep(), up);
        } else {
            HashSet<IBuildStep> stepSet = new HashSet<IBuildStep>();
            for (Map.Entry entry : outMap.entrySet()) {
                IBuildIOType type = (IBuildIOType)entry.getKey();
                IBuildStep step = type.getStep();
                if (!stepSet.add(step)) continue;
                IBuildIOType oType = (IBuildIOType)entry.getValue();
                this.typesMatch(type, oType, null, true);
                this.doTestStep(step, oType.getStep(), up);
            }
        }
    }

    private void doTestResourceMatch(IBuildResource rc, IBuildResource oRc, Map<IBuildIOType, IBuildIOType> outTypeMap) {
        this.doTrace("matching resource " + DbgUtil.resourceName((IBuildResource)rc));
        if (!rc.getLocation().equals((Object)oRc.getLocation())) {
            this.doFail("different resource locsations", rc, oRc);
        }
        IBuildIOType inType = rc.getProducerIOType();
        IBuildIOType oInType = oRc.getProducerIOType();
        this.typesMatch(inType, oInType, null, true);
        IBuildIOType[] outTypes = rc.getDependentIOTypes();
        IBuildIOType[] oOutTypes = oRc.getDependentIOTypes();
        if (outTypes.length != oOutTypes.length) {
            this.doFail("resources do not match: different number of output types", rc, oRc);
        }
        int i = 0;
        while (i < outTypes.length) {
            IBuildIOType obj;
            IBuildIOType oType = this.getCorType(outTypes[i], oOutTypes);
            if (oType == null) {
                this.doFail("resources not match: no cor dep type found", rc, oRc);
            }
            if ((obj = outTypeMap.put(outTypes[i], oType)) != null) {
                this.doFail("there was corresponding type", rc, oRc);
            }
            ++i;
        }
        this.doTrace("end matching resource");
    }

    private boolean stepsMatch(IBuildStep step, IBuildStep oStep, Map<IBuildIOType, IBuildIOType> inTypeMap, Map<IBuildIOType, IBuildIOType> outTypeMap, boolean failOnErr) {
        return this.stepsMatch(step, oStep, inTypeMap, outTypeMap, true, failOnErr);
    }

    private boolean stepsMatch(IBuildStep step, IBuildStep oStep, Map<IBuildIOType, IBuildIOType> inTypeMap, Map<IBuildIOType, IBuildIOType> outTypeMap, boolean checkSteps, boolean failOnErr) {
        IBuildIOType[] oOutTypes;
        IBuildIOType[] inTypes = step.getInputIOTypes();
        IBuildIOType[] oInTypes = oStep.getInputIOTypes();
        this.doTrace("matching step " + DbgUtil.stepName((IBuildStep)step));
        if (inTypes.length != oInTypes.length) {
            if (failOnErr) {
                this.doFail("steps do not match: different number of input types", step, oStep);
            }
            return false;
        }
        int i = 0;
        while (i < inTypes.length) {
            IBuildIOType oType = this.getCorType(inTypes[i], oInTypes, null, checkSteps);
            if (oType == null) {
                if (failOnErr) {
                    this.doFail("steps not match, no corresponding input type found", step, oStep);
                }
                return false;
            }
            IBuildIOType obj = inTypeMap.put(inTypes[i], oType);
            if (obj != null) {
                if (failOnErr) {
                    this.doFail("there was already corresponding input type", step, oStep);
                }
                return false;
            }
            ++i;
        }
        IBuildIOType[] outTypes = step.getOutputIOTypes();
        if (outTypes.length != (oOutTypes = oStep.getOutputIOTypes()).length) {
            if (failOnErr) {
                this.doFail("steps do not match: different number of output types", step, oStep);
            }
            return false;
        }
        int i2 = 0;
        while (i2 < outTypes.length) {
            IBuildIOType oType = this.getCorType(outTypes[i2], oOutTypes, null, checkSteps);
            if (oType == null) {
                if (failOnErr) {
                    this.doFail("steps not match, no corresponding output type found", step, oStep);
                }
                return false;
            }
            IBuildIOType obj = outTypeMap.put(outTypes[i2], oType);
            if (obj != null) {
                if (failOnErr) {
                    this.doFail("there was already corresponding output type", step, oStep);
                }
                return false;
            }
            ++i2;
        }
        this.doTrace("end matching step");
        return true;
    }

    private IBuildIOType getCorType(IBuildIOType type, IBuildIOType[] oTypes) {
        return this.getCorType(type, oTypes, null, true);
    }

    private IBuildIOType getCorType(IBuildIOType type, IBuildIOType[] oTypes, Map<IBuildResource, IBuildResource> rcMap, boolean checkSteps) {
        int i = 0;
        while (i < oTypes.length) {
            if (this.typesMatch(type, oTypes[i], rcMap, checkSteps, false)) {
                return oTypes[i];
            }
            if (rcMap != null) {
                rcMap.clear();
            }
            ++i;
        }
        return null;
    }

    private boolean typesMatch(IBuildIOType type, IBuildIOType oType, Map<IBuildResource, IBuildResource> rcMap, boolean failOnError) {
        return this.typesMatch(type, oType, rcMap, true, failOnError);
    }

    private boolean typesMatch(IBuildIOType type, IBuildIOType oType, Map<IBuildResource, IBuildResource> rcMap, boolean checkStep, boolean failOnError) {
        IBuildResource[] oRcs;
        if (type.isInput() != oType.isInput()) {
            if (failOnError) {
                this.doFail("types have different I/O property", type, oType);
            }
            return false;
        }
        IBuildResource[] rcs = type.getResources();
        if (rcs.length != (oRcs = oType.getResources()).length) {
            return false;
        }
        if (this.resourcesMatch(rcs, oRcs, rcMap)) {
            HashMap<IBuildIOType, IBuildIOType> inMap = new HashMap<IBuildIOType, IBuildIOType>();
            HashMap<IBuildIOType, IBuildIOType> outMap = new HashMap<IBuildIOType, IBuildIOType>();
            if (!checkStep) {
                return true;
            }
            return this.stepsMatch(type.getStep(), oType.getStep(), inMap, outMap, false, failOnError);
        }
        if (failOnError) {
            this.doFail("resources not match", type, oType);
        }
        return false;
    }

    private boolean resourcesMatch(IBuildResource[] rcs, IBuildResource[] oRcs, Map<IBuildResource, IBuildResource> rcMap) {
        if (rcs.length != oRcs.length) {
            return false;
        }
        int j = 0;
        while (j < rcs.length) {
            IPath location = rcs[j].getLocation();
            int k = 0;
            while (k < oRcs.length) {
                if (oRcs[k].getLocation().equals((Object)location)) {
                    if (rcMap == null) break;
                    rcMap.put(rcs[j], oRcs[k]);
                    break;
                }
                ++k;
            }
            if (k == oRcs.length) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private void doFail(String dump, IBuildIOType type, IBuildIOType oType) {
        this.doFail(String.valueOf(dump) + "\nType:\n" + DbgUtil.dumpType((IBuildIOType)type) + "\noType:\n" + DbgUtil.dumpType((IBuildIOType)oType));
    }

    private void doFail(String dump, IBuildResource rc, IBuildResource oRc) {
        this.doFail(String.valueOf(dump) + "\nRc:\n" + DbgUtil.dumpResource((IBuildResource)rc) + "\noRc:\n" + DbgUtil.dumpResource((IBuildResource)oRc));
    }

    private void doFail(String dump, IBuildStep step, IBuildStep oStep) {
        this.doFail(String.valueOf(dump) + "\nStep:\n" + DbgUtil.dumpStep((IBuildStep)step) + "\noStep:\n" + DbgUtil.dumpStep((IBuildStep)oStep));
    }

    private void doFail(String dump) {
        this.doTrace(dump);
        BuildDescriptionModelTests.fail((String)dump);
    }

    private void doTrace(String str) {
        if (DbgUtil.DEBUG) {
            DbgUtil.trace((String)str);
        }
    }

    private void doTestBuildDescription(IBuildDescription des, IBuildDescription tDes) {
        BuildDescriptionModelTests.assertEquals((Object)des.getConfiguration(), (Object)tDes.getConfiguration());
        BuildDescriptionModelTests.assertNotNull((Object)des.getConfiguration());
        des.getConfiguration().getOwner().getProject();
        IBuildStep inStep = des.getInputStep();
        IBuildStep outStep = des.getOutputStep();
        if (inStep.getInputIOTypes().length != 0) {
            this.doFail("input step contains inputs, " + DbgUtil.dumpStep((IBuildStep)inStep));
        }
        if (outStep.getOutputIOTypes().length != 0) {
            this.doFail("output step contains outputs, " + DbgUtil.dumpStep((IBuildStep)outStep));
        }
        IBuildStep tInStep = tDes.getInputStep();
        IBuildStep tOutStep = tDes.getOutputStep();
        this.doTrace("*****testing down to up..");
        this.doTestStep(inStep, tInStep, true);
        this.doTrace("*****down to up passed");
        this.doTrace("*****testing up to down..");
        this.doTestStep(outStep, tOutStep, false);
        this.doTrace("*****up to down passed");
    }

    protected void tearDown() throws Exception {
        this.fCleaner.run();
        if (DbgUtil.DEBUG) {
            DbgUtil.flush();
        }
    }

    private IProject createProject(String name, String id) {
        IProject proj = ManagedBuildTestHelper.createProject(name, id);
        if (proj != null) {
            this.fCompositeCleaner.addRunnable(new ProjectCleaner(proj));
        }
        return proj;
    }

    private IProject loadProject(String name) {
        IProject proj = ManagedBuildTestHelper.loadProject(name, PROJ_PATH);
        if (proj != null) {
            this.fCompositeCleaner.addRunnable(new ProjectCleaner(proj));
        }
        return proj;
    }

    public void testDes_gnu30_exe() {
        IProject project = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)project, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(project, "a.c");
        ManagedBuildTestHelper.createFile(project, "b.c");
        ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        String art = cfg.getArtifactName();
        String ext = cfg.getArtifactExtension();
        if (ext != null && ext.length() > 0) {
            art = String.valueOf(art) + "." + ext;
        }
        String cName = cfg.getName();
        BuildDescription tDes = new BuildDescription(cfg);
        BuildStep step = (BuildStep)tDes.getInputStep();
        BuildIOType type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("a.c"));
        type.addResource(tDes.createResource("b.c"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("a.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        step = (BuildStep)tDes.getOutputStep();
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDes_gnu30_exe_deps() {
        IProject project = this.createProject("BuildDescription_gnu30_exe_deps", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)project, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(project, "a.c", "\n#include \"a.h\"\n#include \"d.h\"\n");
        ManagedBuildTestHelper.createFile(project, "b.c");
        ManagedBuildTestHelper.createFile(project, "c.cpp", "\n#include \"b.h\"\n#include \"e.h\"\n");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        ManagedBuildTestHelper.createFile(project, "a.h", "\n#include \"b.h\"\n");
        ManagedBuildTestHelper.createFile(project, "b.h", "\n#include \"c.h\"\n");
        ManagedBuildTestHelper.createFile(project, "c.h", "\n");
        ManagedBuildTestHelper.createFile(project, "d.h", "\n");
        ManagedBuildTestHelper.createFile(project, "e.h", "\n");
        ManagedBuildTestHelper.createFile(project, "f.h", "\n");
        ICProject cProject = CoreModel.getDefault().create(project);
        CCorePlugin.getIndexManager().setIndexerId(cProject, "org.eclipse.cdt.core.fastIndexer");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        String art = cfg.getArtifactName();
        String ext = cfg.getArtifactExtension();
        if (ext != null && ext.length() > 0) {
            art = String.valueOf(art) + "." + ext;
        }
        String cName = cfg.getName();
        BuildDescription tDes = new BuildDescription(cfg);
        BuildStep step = (BuildStep)tDes.getInputStep();
        BuildIOType type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("a.c"));
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("a.h"));
        type.addResource(tDes.createResource("b.h"));
        type.addResource(tDes.createResource("c.h"));
        type.addResource(tDes.createResource("d.h"));
        type.addResource(tDes.createResource("e.h"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("a.c"));
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("a.h"));
        type.addResource(tDes.createResource("b.h"));
        type.addResource(tDes.createResource("c.h"));
        type.addResource(tDes.createResource("d.h"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("b.h"));
        type.addResource(tDes.createResource("c.h"));
        type.addResource(tDes.createResource("e.h"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        step = (BuildStep)tDes.getOutputStep();
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {}
        CCorePlugin.getIndexManager().joinIndexer(-1, (IProgressMonitor)new NullProgressMonitor());
        CCorePlugin.getIndexManager().reindex(cProject);
        CCorePlugin.getIndexManager().joinIndexer(-1, (IProgressMonitor)new NullProgressMonitor());
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDesTestgnu21_exe() {
        IProject project = this.createProject("BuildDescription_1", "cdt.managedbuild.target.testgnu21.exe");
        try {
            CCProjectNature.addCCNature((IProject)project, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(project, "a.c");
        ManagedBuildTestHelper.createFile(project, "b.c");
        ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        String art = cfg.getArtifactName();
        String ext = cfg.getArtifactExtension();
        if (ext != null && ext.length() > 0) {
            art = String.valueOf(art) + "." + ext;
        }
        String cName = cfg.getName();
        BuildDescription tDes = new BuildDescription(cfg);
        BuildStep step = (BuildStep)tDes.getInputStep();
        BuildIOType type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("a.c"));
        type.addResource(tDes.createResource("b.c"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("a.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        step = (BuildStep)tDes.getOutputStep();
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDesRcCfg() {
        IProject project = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)project, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        IFile ac = ManagedBuildTestHelper.createFile(project, "a.c");
        ManagedBuildTestHelper.createFile(project, "b.c");
        IFile ccpp = ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        String art = cfg.getArtifactName();
        String ext = cfg.getArtifactExtension();
        if (ext != null && ext.length() > 0) {
            art = String.valueOf(art) + "." + ext;
        }
        String cName = cfg.getName();
        IResourceConfiguration rcCfg = cfg.createResourceConfiguration(ac);
        BuildDescriptionModelTests.assertNotNull((Object)rcCfg);
        rcCfg = cfg.createResourceConfiguration(ccpp);
        BuildDescriptionModelTests.assertNotNull((Object)rcCfg);
        BuildDescription tDes = new BuildDescription(cfg);
        BuildStep step = (BuildStep)tDes.getInputStep();
        BuildIOType type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("a.c"));
        type.addResource(tDes.createResource("b.c"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("a.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        step = (BuildStep)tDes.getOutputStep();
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDesRcbs() {
        IProject project = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)project, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(project, "a.c");
        ManagedBuildTestHelper.createFile(project, "b.c");
        IFile ccpp = ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        IFile er = ManagedBuildTestHelper.createFile(project, "e.r");
        ManagedBuildTestHelper.createFile(project, "f.r");
        ManagedBuildTestHelper.createFile(project, "dir1/g.r");
        ManagedBuildTestHelper.createFile(project, "dir2/h.r");
        ManagedBuildTestHelper.createFile(project, "dir2/i.r");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        String art = cfg.getArtifactName();
        String ext = cfg.getArtifactExtension();
        if (ext != null && ext.length() > 0) {
            art = String.valueOf(art) + "." + ext;
        }
        String cName = cfg.getName();
        String out = String.valueOf(cName) + "/";
        ManagedBuildTestHelper.createRcbsTool(cfg, ccpp, "f.r;dir1/g.r;dir2/h.r", "q.o;w.o;e.o", "a;b;c");
        ManagedBuildTestHelper.createRcbsTool(cfg, er, "f.r;dir1/g.r;dir2/h.r;dir2/i.r", "z.cpp;x.c", "d;e;f");
        BuildDescription tDes = new BuildDescription(cfg);
        BuildStep step = (BuildStep)tDes.getInputStep();
        BuildIOType type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("a.c"));
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("e.r"));
        type.addResource(tDes.createResource("f.r"));
        type.addResource(tDes.createResource("dir1/g.r"));
        type.addResource(tDes.createResource("dir2/h.r"));
        type.addResource(tDes.createResource("dir2/i.r"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("a.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("f.r"));
        type.addResource(tDes.createResource("dir1/g.r"));
        type.addResource(tDes.createResource("dir2/h.r"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/q.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/w.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/e.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("e.r"));
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("f.r"));
        type.addResource(tDes.createResource("dir1/g.r"));
        type.addResource(tDes.createResource("dir2/h.r"));
        type.addResource(tDes.createResource("dir2/i.r"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "z.cpp"));
        type.addResource(tDes.createResource(String.valueOf(out) + "x.c"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "z.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/z.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "x.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/x.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/q.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/w.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/e.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/z.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/x.o"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        step = (BuildStep)tDes.getOutputStep();
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDesAddlInVarUserObjs() {
        IProject project = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)project, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(project, "a.c");
        ManagedBuildTestHelper.createFile(project, "b.c");
        IFile ccpp = ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        IFile er = ManagedBuildTestHelper.createFile(project, "e.r");
        ManagedBuildTestHelper.createFile(project, "f.r");
        ManagedBuildTestHelper.createFile(project, "dir1/g.r");
        ManagedBuildTestHelper.createFile(project, "dir2/h.r");
        ManagedBuildTestHelper.createFile(project, "dir2/i.r");
        ManagedBuildTestHelper.createFile(project, "o1.o");
        ManagedBuildTestHelper.createFile(project, "dir3/o2.o");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        String art = cfg.getArtifactName();
        String ext = cfg.getArtifactExtension();
        if (ext != null && ext.length() > 0) {
            art = String.valueOf(art) + "." + ext;
        }
        String cName = cfg.getName();
        String out = String.valueOf(cName) + "/";
        ManagedBuildTestHelper.setObjs(cfg, new String[]{"o1.o", "dir3/o2.o", "dir4/d/o3.o"});
        ManagedBuildTestHelper.createRcbsTool(cfg, ccpp, "f.r;dir1/g.r;dir2/h.r", "q.o;w.o;e.o", "a;b;c");
        ManagedBuildTestHelper.createRcbsTool(cfg, er, "f.r;dir1/g.r;dir2/h.r;dir2/i.r", "z.cpp;x.c", "d;e;f");
        BuildDescription tDes = new BuildDescription(cfg);
        BuildStep step = (BuildStep)tDes.getInputStep();
        BuildIOType type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("a.c"));
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("e.r"));
        type.addResource(tDes.createResource("f.r"));
        type.addResource(tDes.createResource("dir1/g.r"));
        type.addResource(tDes.createResource("dir2/h.r"));
        type.addResource(tDes.createResource("dir2/i.r"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("o1.o"));
        type.addResource(tDes.createResource("dir3/o2.o"));
        type.addResource(tDes.createResource("dir4/d/o3.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("a.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("f.r"));
        type.addResource(tDes.createResource("dir1/g.r"));
        type.addResource(tDes.createResource("dir2/h.r"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/q.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/w.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/e.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("e.r"));
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("f.r"));
        type.addResource(tDes.createResource("dir1/g.r"));
        type.addResource(tDes.createResource("dir2/h.r"));
        type.addResource(tDes.createResource("dir2/i.r"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "z.cpp"));
        type.addResource(tDes.createResource(String.valueOf(out) + "x.c"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "z.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/z.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "x.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/x.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/q.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/w.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/e.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/z.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/x.o"));
        type.addResource(tDes.createResource("o1.o"));
        type.addResource(tDes.createResource("dir3/o2.o"));
        type.addResource(tDes.createResource("dir4/d/o3.o"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        step = (BuildStep)tDes.getOutputStep();
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDesAddlInVar() {
        IProject project = this.createProject("BuildDescription_1", "cdt.managedbuild.target.bdm.exe");
        try {
            CCProjectNature.addCCNature((IProject)project, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(project, "a.c");
        ManagedBuildTestHelper.createFile(project, "b.c");
        ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        ManagedBuildTestHelper.createFile(project, "e.s1");
        ManagedBuildTestHelper.createFile(project, "dir/f.s1");
        ManagedBuildTestHelper.createFile(project, "g.s2");
        ManagedBuildTestHelper.createFile(project, "dir/h.s2");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        String art = cfg.getArtifactName();
        String ext = cfg.getArtifactExtension();
        if (ext != null && ext.length() > 0) {
            art = String.valueOf(art) + "." + ext;
        }
        String cName = cfg.getName();
        String out = String.valueOf(cName) + "/";
        BuildDescription tDes = new BuildDescription(cfg);
        BuildStep step = (BuildStep)tDes.getInputStep();
        BuildIOType type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("a.c"));
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("e.s1"));
        type.addResource(tDes.createResource("dir/f.s1"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("g.s2"));
        type.addResource(tDes.createResource("dir/h.s2"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("e.s1"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "e.o1"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("dir/f.s1"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "dir/f.o1"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("g.s2"));
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "e.o1"));
        type.addResource(tDes.createResource(String.valueOf(out) + "dir/f.o1"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "g.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("dir/h.s2"));
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "e.o1"));
        type.addResource(tDes.createResource(String.valueOf(out) + "dir/f.o1"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(out) + "dir/h.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("a.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        type.addResource(tDes.createResource(String.valueOf(out) + "g.o"));
        type.addResource(tDes.createResource(String.valueOf(out) + "dir/h.o"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        step = (BuildStep)tDes.getOutputStep();
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDes_gnu30_exe_objsInProj() {
        IProject project = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)project, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(project, "a.c");
        ManagedBuildTestHelper.createFile(project, "b.c");
        ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        ManagedBuildTestHelper.createFile(project, "e.o");
        ManagedBuildTestHelper.createFile(project, "dir/f.o");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        String art = cfg.getArtifactName();
        String ext = cfg.getArtifactExtension();
        if (ext != null && ext.length() > 0) {
            art = String.valueOf(art) + "." + ext;
        }
        String cName = cfg.getName();
        BuildDescription tDes = new BuildDescription(cfg);
        BuildStep step = (BuildStep)tDes.getInputStep();
        BuildIOType type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource("a.c"));
        type.addResource(tDes.createResource("b.c"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("a.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("b.c"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("c.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, false, null);
        type.addResource(tDes.createResource("d.cpp"));
        type = step.createIOType(false, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        step = tDes.createStep(null, null);
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/a.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/b.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/c.o"));
        type.addResource(tDes.createResource(String.valueOf(cName) + "/d.o"));
        type = step.createIOType(false, false, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        step = (BuildStep)tDes.getOutputStep();
        type = step.createIOType(true, true, null);
        type.addResource(tDes.createResource(String.valueOf(cName) + "/" + art));
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        this.doTestBuildDescription(des, (IBuildDescription)tDes);
    }

    public void testDesRebuildState() {
        IOption o;
        IHoldsOptions ho;
        IProject project = this.createProject("BuildDescription_1", "cdt.managedbuild.target.gnu30.exe");
        try {
            CCProjectNature.addCCNature((IProject)project, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(project, "a.c");
        ManagedBuildTestHelper.createFile(project, "b.c");
        ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d.cpp");
        ManagedBuildTestHelper.createFile(project, "e.o");
        ManagedBuildTestHelper.createFile(project, "dir/f.o");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        IConfiguration cfg = mProj.getConfigurations()[0];
        cfg.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        ITool targetTool = ((Configuration)cfg).calculateTargetTool();
        cfg.setArtifactName("asdafasdfasdfasdfasdf");
        BuildDescriptionModelTests.assertTrue((boolean)targetTool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
        targetTool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)targetTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        cfg.setBuildArguments("-fgsdfg -sdfg -sdfg -sfdg");
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        cfg.setBuildCommand("fdgsdfbvvcbsdfvcx");
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        cfg.setCleanCommand("sadgvfcxvsdfgvxc");
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        cfg.setDescription("sfgsdfgsdfcxbvxcbxcvb");
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        cfg.setErrorParserIds("fgdsfgsdfgsdfgsdfgsdfgdfs;sdfg;sdfg;sdg;g;sdg");
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        cfg.setName("sdfgsdfgsdfgsdfgsdfgdsfgsdf");
        BuildDescriptionModelTests.assertFalse((boolean)targetTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        cfg.setPostannouncebuildStep("sdfasdfasdfsdfadfasf");
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        cfg.setPostbuildStep("asdf;asdf;asdf;asdf;asdf");
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        cfg.setPreannouncebuildStep("sdfgsdgsdhnbvxcvbxcv");
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        cfg.setPrebuildStep("sdfg;sdfg;sdfg;sdfgvnbcvbn");
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        ITool[] tools = cfg.getFilteredTools();
        ITool tool = null;
        int i = 0;
        while (i < tools.length) {
            tool = tools[i];
            if (tool != targetTool) break;
            ++i;
        }
        cfg.setToolCommand(tool, "sdgsdcxvzcxvzxc");
        BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
        tool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        cfg.setArtifactExtension("adsfasdfasdfasdfasdf");
        BuildDescriptionModelTests.assertTrue((boolean)targetTool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
        targetTool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)targetTool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        IBuildObject[] obj = ManagedBuildTestHelper.getOption(cfg, 0);
        if (obj != null) {
            ho = (IHoldsOptions)obj[0];
            o = (IOption)obj[1];
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            try {
                cfg.setOption(ho, o, !o.getBooleanValue());
            }
            catch (BuildException e) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + e.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            ho.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        }
        if ((obj = ManagedBuildTestHelper.getOption(cfg, 1)) != null) {
            ho = (IHoldsOptions)obj[0];
            o = (IOption)obj[1];
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            try {
                cfg.setOption(ho, o, "sdfgsdfcvsdfgvxcsdf");
            }
            catch (BuildException e) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + e.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            ho.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        }
        if ((obj = ManagedBuildTestHelper.getOption(cfg, 2)) != null) {
            ho = (IHoldsOptions)obj[0];
            o = (IOption)obj[1];
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            try {
                cfg.setOption(ho, o, "sdfgsdfcvsdfgvxcfdgvsdf");
            }
            catch (BuildException e) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + e.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            ho.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        }
        if ((obj = ManagedBuildTestHelper.getOption(cfg, 3)) != null) {
            ho = (IHoldsOptions)obj[0];
            o = (IOption)obj[1];
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            try {
                cfg.setOption(ho, o, new String[]{"sdfgsd", "fcvsdfgvxcfdgvsdf"});
            }
            catch (BuildException e) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + e.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            ho.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        }
        if ((obj = ManagedBuildTestHelper.getOption(cfg, 4)) != null) {
            ho = (IHoldsOptions)obj[0];
            o = (IOption)obj[1];
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            try {
                cfg.setOption(ho, o, new String[]{"sdfgsd", "fcvsdfgvxcfdgvsdf"});
            }
            catch (BuildException e) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + e.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            ho.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        }
        if ((obj = ManagedBuildTestHelper.getOption(cfg, 5)) != null) {
            ho = (IHoldsOptions)obj[0];
            o = (IOption)obj[1];
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            try {
                cfg.setOption(ho, o, new String[]{"sdfgsd", "fcvsdfgvxcfdgvsdf"});
            }
            catch (BuildException e) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + e.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            ho.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        }
        if ((obj = ManagedBuildTestHelper.getOption(cfg, 6)) != null) {
            ho = (IHoldsOptions)obj[0];
            o = (IOption)obj[1];
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            try {
                cfg.setOption(ho, o, new String[]{"sdfgsd", "fcvsdfgvxcfdgvsdf"});
            }
            catch (BuildException e) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + e.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            ho.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        }
        if ((obj = ManagedBuildTestHelper.getOption(cfg, 7)) != null) {
            ho = (IHoldsOptions)obj[0];
            o = (IOption)obj[1];
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            try {
                cfg.setOption(ho, o, new String[]{"sdfgsd", "fcvsdfgvxcfdgvsdf"});
            }
            catch (BuildException e) {
                BuildDescriptionModelTests.fail((String)("failed to set the option: " + e.getLocalizedMessage()));
            }
            BuildDescriptionModelTests.assertTrue((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            ho.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)ho.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        }
        IToolChain tch = cfg.getToolChain();
        tch.setRebuildState(true);
        BuildDescriptionModelTests.assertTrue((boolean)tch.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
        tch.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)tch.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        int i2 = 0;
        while (i2 < tools.length) {
            this.doTestTool(tools[i2]);
            ++i2;
        }
        IResourceConfiguration[] rcCfgs = cfg.getResourceConfigurations();
        int i3 = 0;
        while (i3 < rcCfgs.length) {
            IResourceConfiguration rcCfg = rcCfgs[i3];
            BuildDescriptionModelTests.assertFalse((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            rcCfg.setRebuildState(true);
            BuildDescriptionModelTests.assertTrue((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            rcCfg.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            rcCfg.setExclude(!rcCfg.isExcluded());
            BuildDescriptionModelTests.assertTrue((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            rcCfg.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            rcCfg.setExclude(rcCfg.isExcluded());
            BuildDescriptionModelTests.assertFalse((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            int appl = rcCfg.getRcbsApplicability() + 1;
            if (appl > 4) {
                appl = 1;
            }
            rcCfg.setRcbsApplicability(appl);
            BuildDescriptionModelTests.assertTrue((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            rcCfg.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            rcCfg.setRcbsApplicability(rcCfg.getRcbsApplicability());
            BuildDescriptionModelTests.assertFalse((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            ITool t = rcCfg.getToolsToInvoke()[0];
            BuildDescriptionModelTests.assertFalse((boolean)t.needsRebuild());
            rcCfg.setToolCommand(t, "sdsdcdsffewffdvcx");
            BuildDescriptionModelTests.assertTrue((boolean)t.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
            t.setRebuildState(false);
            BuildDescriptionModelTests.assertFalse((boolean)t.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            rcCfg.setToolCommand(t, t.getToolCommand());
            BuildDescriptionModelTests.assertFalse((boolean)t.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)rcCfg.needsRebuild());
            BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            ++i3;
        }
    }

    private void doTestTool(ITool tool) {
        IBuildObject obj = tool.getParent();
        IConfiguration cfg = obj instanceof IResourceConfiguration ? ((IResourceConfiguration)obj).getParent() : ((IToolChain)obj).getParent();
        cfg.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
        tool.setRebuildState(true);
        BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
        cfg.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        tool.setRebuildState(true);
        BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
        tool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        tool.setCommandLinePattern("asdfasdfasdfasdfasdfasdsdfghdsfg");
        BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
        tool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        tool.setOutputFlag("asdfasdfasdfasdgsdf");
        BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
        tool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        tool.setOutputPrefix("afgsdfgfadcvwerfdvsdczxv");
        BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
        tool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        tool.setRebuildState(true);
        BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
        tool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        tool.setToolCommand("dfacvzxcgrsedfxcvsdfcgv");
        BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
        tool.setRebuildState(false);
        BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
        BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
        IInputType[] iTypes = tool.getInputTypes();
        int i = 0;
        while (i < iTypes.length) {
            IInputType iType = iTypes[i];
            if (!iType.isExtensionElement()) {
                iType.setAssignToOptionId("qwertyuiop");
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                iType.setBuildVariable("asdfghjkl");
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                iType.setMultipleOfType(!iType.getMultipleOfType());
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                iType.setOptionId("zxcvbnm");
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                iType.setPrimaryInput(!iType.getPrimaryInput());
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                IAdditionalInput[] addlIns = iType.getAdditionalInputs();
                int j = 0;
                while (j < addlIns.length) {
                    IAdditionalInput a = addlIns[j];
                    a.setPaths("as;sd;fgl;fg;qw;er;ty;ui;op");
                    BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                    BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                    tool.setRebuildState(false);
                    BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                    BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                    ++j;
                }
            }
            ++i;
        }
        IOutputType[] oTypes = tool.getOutputTypes();
        int i2 = 0;
        while (i2 < oTypes.length) {
            IOutputType oType = oTypes[i2];
            if (!oType.isExtensionElement()) {
                oType.setBuildVariable("qwertyuiop");
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                oType.setMultipleOfType(!oType.getMultipleOfType());
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                oType.setNamePattern("qwerytuuioioyuioghjgfd");
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                oType.setOptionId("asdfghjklkxcvx");
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                oType.setOutputNames("asdf;dfgh;hj;jk;ghjk;fgg;sdaf;asdf");
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                oType.setOutputPrefix("asdfscvbdfgsdfgsdfvcx");
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
                oType.setPrimaryOutput(!oType.getPrimaryOutput());
                BuildDescriptionModelTests.assertTrue((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertTrue((boolean)cfg.needsRebuild());
                tool.setRebuildState(false);
                BuildDescriptionModelTests.assertFalse((boolean)tool.needsRebuild());
                BuildDescriptionModelTests.assertFalse((boolean)cfg.needsRebuild());
            }
            ++i2;
        }
    }

    public void testDesRebuildStateInDescription() {
        IProject project = this.createProject("BuildDescription_1", "cdt.managedbuild.target.bdm.exe");
        try {
            CCProjectNature.addCCNature((IProject)project, null);
        }
        catch (CoreException coreException) {
            BuildDescriptionModelTests.fail((String)"fail to add CC nature");
        }
        ManagedBuildTestHelper.createFile(project, "a.c");
        ManagedBuildTestHelper.createFile(project, "b.c");
        ManagedBuildTestHelper.createFile(project, "c.cpp");
        ManagedBuildTestHelper.createFile(project, "d/d.cpp");
        ManagedBuildTestHelper.createFile(project, "d2/e.s2");
        ManagedBuildTestHelper.createFile(project, "f.s2");
        ManagedBuildTestHelper.createFile(project, "e.o");
        ManagedBuildTestHelper.createFile(project, "dir/f.o");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject mProj = info.getManagedProject();
        Configuration cfg = (Configuration)mProj.getConfigurations()[0];
        String out = String.valueOf(cfg.getName()) + "/";
        cfg.setRebuildState(false);
        IBuildDescription des = null;
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)7);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        IBuildResource[] rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)2);
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)0);
        rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)1);
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)0);
        rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)3);
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)0);
        ITool tool = cfg.calculateTargetTool();
        tool.setToolCommand("fgdfgcvbcbv");
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)3);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)2);
        IBuildResource[] oRcs = des.getOutputStep().getInputResources();
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)1);
        BuildDescriptionModelTests.assertEquals((int)oRcs.length, (int)1);
        if (rcs[0] != oRcs[0]) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        IBuildResource targetRc = oRcs[0];
        rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)1);
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)0);
        rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)3);
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)1);
        BuildDescriptionModelTests.assertEquals((int)oRcs.length, (int)1);
        if (rcs[0] != oRcs[0]) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        cfg.setRebuildState(false);
        tool = this.getToolForInExt((IConfiguration)cfg, "cpp");
        tool.setToolCommand("sdfgzxcvzxcvzxv");
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)3);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)2);
        oRcs = des.getOutputStep().getInputResources();
        BuildDescriptionModelTests.assertEquals((int)oRcs.length, (int)1);
        targetRc = oRcs[0];
        oRcs = new IBuildResource[5];
        oRcs[0] = this.getResourceForProjPath(des, String.valueOf(out) + "c.o");
        BuildDescriptionModelTests.assertNotNull((Object)oRcs[0]);
        oRcs[1] = this.getResourceForProjPath(des, String.valueOf(out) + "d/d.o");
        BuildDescriptionModelTests.assertNotNull((Object)oRcs[1]);
        oRcs[2] = targetRc;
        oRcs[3] = this.getResourceForProjPath(des, String.valueOf(out) + "a.o");
        BuildDescriptionModelTests.assertNotNull((Object)oRcs[0]);
        oRcs[4] = this.getResourceForProjPath(des, String.valueOf(out) + "b.o");
        BuildDescriptionModelTests.assertNotNull((Object)oRcs[1]);
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)5);
        BuildDescriptionModelTests.assertEquals((int)oRcs.length, (int)5);
        if (!this.resourcesEqual(rcs, oRcs)) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)1);
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)0);
        rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)3);
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)5);
        if (!this.resourcesEqual(rcs, oRcs)) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        cfg.setRebuildState(false);
        tool = this.getToolForInExt((IConfiguration)cfg, "s2");
        tool.setToolCommand("sdfgzxcvzxcvzxv");
        try {
            des = BuildDescriptionManager.createBuildDescription((IConfiguration)cfg, null, (int)3);
        }
        catch (CoreException e) {
            BuildDescriptionModelTests.fail((String)("build description creation failed: " + e.getLocalizedMessage()));
        }
        rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)2);
        oRcs = des.getOutputStep().getInputResources();
        BuildDescriptionModelTests.assertEquals((int)oRcs.length, (int)1);
        targetRc = oRcs[0];
        oRcs = new IBuildResource[3];
        oRcs[0] = this.getResourceForProjPath(des, String.valueOf(out) + "d2/e.o");
        BuildDescriptionModelTests.assertNotNull((Object)oRcs[0]);
        oRcs[1] = this.getResourceForProjPath(des, String.valueOf(out) + "f.o");
        BuildDescriptionModelTests.assertNotNull((Object)oRcs[1]);
        oRcs[2] = targetRc;
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)3);
        BuildDescriptionModelTests.assertEquals((int)oRcs.length, (int)3);
        if (!this.resourcesEqual(rcs, oRcs)) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)1);
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)0);
        rcs = BuildDescriptionManager.filterGeneratedBuildResources((IBuildResource[])des.getResources(), (int)3);
        BuildDescriptionModelTests.assertEquals((int)rcs.length, (int)3);
        if (!this.resourcesEqual(rcs, oRcs)) {
            BuildDescriptionModelTests.fail((String)"rebuild resources do not match");
        }
        cfg.setRebuildState(false);
    }

    private IBuildResource getResourceForProjPath(IBuildDescription des, String path) {
        return this.getResourceForProjPath(des, (IPath)new Path(path));
    }

    private IBuildResource getResourceForProjPath(IBuildDescription des, IPath path) {
        IPath location = des.getConfiguration().getOwner().getProject().getLocation().append(path);
        return des.getBuildResource(location);
    }

    private ITool getToolForInExt(IConfiguration cfg, String ext) {
        ITool[] tools = cfg.getFilteredTools();
        int i = 0;
        while (i < tools.length) {
            if (tools[i].buildsFileType(ext)) {
                return tools[i];
            }
            ++i;
        }
        return null;
    }

    private boolean resourcesEqual(IBuildResource[] rcs, IBuildResource[] oRcs) {
        if (rcs.length != oRcs.length) {
            return false;
        }
        int j = 0;
        while (j < rcs.length) {
            int k = 0;
            while (k < oRcs.length) {
                if (oRcs[k] == rcs[j]) break;
                ++k;
            }
            if (k == oRcs.length) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private class CompositeCleaner
    implements Runnable {
        private List<Runnable> fRunnables = new ArrayList<Runnable>();

        private CompositeCleaner() {
        }

        public void addRunnable(Runnable r) {
            this.fRunnables.add(r);
        }

        public void run() {
            for (Runnable r : this.fRunnables) {
                r.run();
            }
            this.fRunnables.clear();
        }
    }

    private class ProjectCleaner
    implements Runnable {
        List<String> fProjList = new ArrayList<String>();

        public ProjectCleaner() {
        }

        public ProjectCleaner(String name) {
            this.addProject(name);
        }

        public ProjectCleaner(IProject project) {
            this.addProject(project);
        }

        public void addProject(IProject project) {
            this.addProject(project.getName());
        }

        public void addProject(String name) {
            this.fProjList.add(name);
        }

        public void run() {
            for (String name : this.fProjList) {
                ManagedBuildTestHelper.removeProject(name);
            }
            this.fProjList.clear();
        }
    }
}

